/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;

public class AmqpPurgeOnNoConsumersTest
extends AmqpClientTestSupport {
    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Test(timeout=60000L)
    public void testQueueReceiverReadMessage() throws Exception {
        AmqpConnection connection = null;
        String queue = "purgeQueue";
        SimpleString ssQueue = new SimpleString(queue);
        this.server.addAddressInfo(new AddressInfo(ssQueue, RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(ssQueue).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)));
        AmqpClient client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(queue);
        QueueImpl queueView = (QueueImpl)this.getProxyToQueue(queue);
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getPageSubscription().getPagingStore().getAddressSize());
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        this.sendMessages(queue, 5, null, true);
        Wait.assertEquals((long)5L, () -> ((QueueImpl)queueView).getMessageCount());
        receiver.flow(5);
        for (int i = 0; i < 4; ++i) {
            try {
                AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
                receive.accept();
                AmqpPurgeOnNoConsumersTest.assertNotNull((Object)receive);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            receiver.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Wait.assertEquals((long)0L, () -> ((QueueImpl)queueView).getMessageCount());
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getPageSubscription().getPagingStore().getAddressSize());
        connection.close();
        this.server.stop();
        this.server.start();
        queueView = (QueueImpl)this.getProxyToQueue(queue);
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getPageSubscription().getPagingStore().getAddressSize());
    }

    @Test(timeout=60000L)
    public void testPurgeQueueCoreRollback() throws Exception {
        String queue = "purgeQueue";
        SimpleString ssQueue = new SimpleString(queue);
        this.server.addAddressInfo(new AddressInfo(ssQueue, RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(ssQueue).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:5672");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("purgeQueue"));
        Queue jmsQueue = session.createQueue(queue);
        MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage("hello " + i);
            producer.send((Message)message);
        }
        session.commit();
        QueueImpl queueView = (QueueImpl)this.getProxyToQueue(queue);
        Wait.assertEquals((long)10L, () -> ((QueueImpl)queueView).getMessageCount());
        connection.start();
        for (int i = 0; i < 10; ++i) {
            TextMessage txt = (TextMessage)consumer.receive(1000L);
            AmqpPurgeOnNoConsumersTest.assertNotNull((Object)txt);
            AmqpPurgeOnNoConsumersTest.assertEquals((Object)("hello " + i), (Object)txt.getText());
        }
        consumer.close();
        session.rollback();
        connection.close();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)queueView).getMessageCount());
        this.server.stop();
        this.server.start();
        queueView = (QueueImpl)this.getProxyToQueue(queue);
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpPurgeOnNoConsumersTest.assertEquals((long)0L, (long)queueView.getPageSubscription().getPagingStore().getAddressSize());
    }
}

