/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Test;

public class JMSTopicConsumerTest
extends JMSClientTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAndReceiveOnTopic() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            TopicSession session = (TopicSession)connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createSubscriber(topic);
            TopicPublisher producer = session.createPublisher(topic);
            TextMessage message = session.createTextMessage("test-message");
            producer.send((Message)message);
            producer.close();
            connection.start();
            message = (TextMessage)consumer.receive(1000L);
            JMSTopicConsumerTest.assertNotNull((Object)message);
            JMSTopicConsumerTest.assertNotNull((Object)message.getText());
            JMSTopicConsumerTest.assertEquals((Object)"test-message", (Object)message.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAndReceiveOnAutoCreatedTopic() throws Exception {
        Connection connection = this.createConnection("myClientId");
        String topicName = UUID.randomUUID().toString();
        SimpleString simpleTopicName = SimpleString.toSimpleString((String)topicName);
        try {
            TopicSession session = (TopicSession)connection.createSession(false, 1);
            Topic topic = session.createTopic(topicName);
            TopicPublisher producer = session.createPublisher(topic);
            TextMessage message = session.createTextMessage("test-message");
            producer.send((Message)message);
            JMSTopicConsumerTest.assertNotNull((Object)this.server.getAddressInfo(simpleTopicName));
            JMSTopicConsumerTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(simpleTopicName).getRoutingType());
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getAddressInfo(simpleTopicName).isAutoCreated());
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
            TopicSubscriber consumer = session.createSubscriber(topic);
            JMSTopicConsumerTest.assertFalse((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
            producer.send((Message)message);
            producer.close();
            connection.start();
            message = (TextMessage)consumer.receive(1000L);
            JMSTopicConsumerTest.assertNotNull((Object)message);
            JMSTopicConsumerTest.assertNotNull((Object)message.getText());
            JMSTopicConsumerTest.assertEquals((Object)"test-message", (Object)message.getText());
            consumer.close();
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAndReceiveOnAutoCreatedTopicJMS2() throws Exception {
        JmsConnectionFactory cf = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        JMSContext context = cf.createContext();
        String topicName = UUID.randomUUID().toString();
        SimpleString simpleTopicName = SimpleString.toSimpleString((String)topicName);
        try {
            Topic topic = context.createTopic(topicName);
            JMSProducer producer = context.createProducer();
            TextMessage message = context.createTextMessage("test-message");
            producer.send((Destination)topic, (Message)message);
            JMSTopicConsumerTest.assertNotNull((Object)this.server.getAddressInfo(simpleTopicName));
            JMSTopicConsumerTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(simpleTopicName).getRoutingType());
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getAddressInfo(simpleTopicName).isAutoCreated());
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
            JMSConsumer consumer = context.createConsumer((Destination)topic);
            JMSTopicConsumerTest.assertFalse((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
            producer.send((Destination)topic, (Message)message);
            context.start();
            message = (TextMessage)consumer.receive(1000L);
            JMSTopicConsumerTest.assertNotNull((Object)message);
            JMSTopicConsumerTest.assertNotNull((Object)message.getText());
            JMSTopicConsumerTest.assertEquals((Object)"test-message", (Object)message.getText());
            consumer.close();
            JMSTopicConsumerTest.assertTrue((boolean)this.server.getPostOffice().getBindingsForAddress(simpleTopicName).getBindings().isEmpty());
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendWithMultipleReceiversOnTopic() throws Exception {
        try (Connection connection = this.createConnection();){
            TopicSession session = (TopicSession)connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer1 = session.createSubscriber(topic);
            TopicSubscriber consumer2 = session.createSubscriber(topic);
            TopicPublisher producer = session.createPublisher(topic);
            TextMessage message = session.createTextMessage("test-message");
            producer.send((Message)message);
            producer.close();
            connection.start();
            message = (TextMessage)consumer1.receive(1000L);
            JMSTopicConsumerTest.assertNotNull((Object)message);
            JMSTopicConsumerTest.assertNotNull((Object)message.getText());
            JMSTopicConsumerTest.assertEquals((Object)"test-message", (Object)message.getText());
            message = (TextMessage)consumer2.receive(1000L);
            JMSTopicConsumerTest.assertNotNull((Object)message);
            JMSTopicConsumerTest.assertNotNull((Object)message.getText());
            JMSTopicConsumerTest.assertEquals((Object)"test-message", (Object)message.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableSubscriptionUnsubscribe() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber myDurSub = session.createDurableSubscriber(topic, "myDurSub");
            session.close();
            connection.close();
            connection = this.createConnection("myClientId");
            session = connection.createSession(false, 1);
            myDurSub = session.createDurableSubscriber(topic, "myDurSub");
            myDurSub.close();
            Assert.assertNotNull((Object)this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")));
            session.unsubscribe("myDurSub");
            Assert.assertNull((Object)this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")));
            session.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableSharedSubscriptionUnsubscribe() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            MessageConsumer myDurSub = session.createSharedDurableConsumer(topic, "myDurSub");
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")) != null ? (byte)1 : 0) != 0);
            myDurSub.close();
            session.unsubscribe("myDurSub");
            session.close();
            connection.close();
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")) == null ? (byte)1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableMultipleSharedSubscriptionUnsubscribe() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            Session session = connection.createSession(false, 1);
            Session session2 = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            MessageConsumer myDurSub = session.createSharedDurableConsumer(topic, "myDurSub");
            MessageConsumer myDurSub2 = session2.createSharedDurableConsumer(topic, "myDurSub");
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")) != null ? (byte)1 : 0) != 0);
            myDurSub.close();
            try {
                session.unsubscribe("myDurSub");
                Assert.fail((String)"should throw exception on active durable subs");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            myDurSub2.close();
            session.unsubscribe("myDurSub");
            session.close();
            connection.close();
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myClientId.myDurSub")) == null ? (byte)1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableSharedGlobalSubscriptionUnsubscribe() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            MessageConsumer myDurSub = session.createSharedDurableConsumer(topic, "myDurSub");
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myDurSub:global")) != null ? (byte)1 : 0) != 0);
            myDurSub.close();
            session.unsubscribe("myDurSub");
            session.close();
            connection.close();
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myDurSub:global")) == null ? (byte)1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableMultipleSharedGlobalSubscriptionUnsubscribe() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        try {
            Session session = connection.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            MessageConsumer myDurSub = session.createSharedDurableConsumer(topic, "myDurSub");
            MessageConsumer myDurSub2 = session2.createSharedDurableConsumer(topic, "myDurSub");
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myDurSub:global")) != null ? (byte)1 : 0) != 0);
            myDurSub.close();
            session.unsubscribe("myDurSub");
            session.close();
            connection.close();
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myDurSub:global")) != null ? (byte)1 : 0) != 0);
            myDurSub2.close();
            session2.unsubscribe("myDurSub");
            session2.close();
            connection2.close();
            Assert.assertTrue((this.server.getPostOffice().getBinding(new SimpleString("myDurSub:global")) == null ? (byte)1 : 0) != 0);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTemporarySubscriptionDeleted() throws Exception {
        try (Connection connection = this.createConnection();){
            TopicSession session = (TopicSession)connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber myNonDurSub = session.createSubscriber(topic);
            JMSTopicConsumerTest.assertNotNull((Object)myNonDurSub);
            Bindings bindingsForAddress = this.server.getPostOffice().getBindingsForAddress(new SimpleString(this.getTopicName()));
            Assert.assertEquals((long)2L, (long)bindingsForAddress.getBindings().size());
            session.close();
            final CountDownLatch latch = new CountDownLatch(1);
            ((RemotingConnection)this.server.getRemotingService().getConnections().iterator().next()).addCloseListener(new CloseListener(){

                public void connectionClosed() {
                    latch.countDown();
                }
            });
            connection.close();
            latch.await(5L, TimeUnit.SECONDS);
            bindingsForAddress = this.server.getPostOffice().getBindingsForAddress(new SimpleString(this.getTopicName()));
            Assert.assertEquals((long)1L, (long)bindingsForAddress.getBindings().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultipleDurableConsumersSendAndReceive() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            int i;
            TopicSession session = (TopicSession)connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            int numMessages = 100;
            TopicSubscriber sub1 = session.createDurableSubscriber(topic, "myPubId1");
            TopicSubscriber sub2 = session.createDurableSubscriber(topic, "myPubId2");
            TopicSubscriber sub3 = session.createDurableSubscriber(topic, "myPubId3");
            Session sendSession = connection.createSession(false, 1);
            MessageProducer producer = sendSession.createProducer((Destination)topic);
            connection.start();
            for (i = 0; i < numMessages; ++i) {
                producer.send((Message)sendSession.createTextMessage("message:" + i));
            }
            for (i = 0; i < numMessages; ++i) {
                TextMessage receive = (TextMessage)sub1.receive(5000L);
                Assert.assertNotNull((Object)receive);
                Assert.assertEquals((Object)receive.getText(), (Object)("message:" + i));
                receive = (TextMessage)sub2.receive(5000L);
                Assert.assertNotNull((Object)receive);
                Assert.assertEquals((Object)receive.getText(), (Object)("message:" + i));
                receive = (TextMessage)sub3.receive(5000L);
                Assert.assertNotNull((Object)receive);
                Assert.assertEquals((Object)receive.getText(), (Object)("message:" + i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDurableSubscriptionReconnection() throws Exception {
        try (Connection connection = this.createConnection("myClientId");){
            TextMessage receive;
            int i;
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            int numMessages = 100;
            TopicSubscriber sub = session.createDurableSubscriber(topic, "myPubId");
            Session sendSession = connection.createSession(false, 1);
            MessageProducer producer = sendSession.createProducer((Destination)topic);
            connection.start();
            for (i = 0; i < numMessages; ++i) {
                producer.send((Message)sendSession.createTextMessage("message:" + i));
            }
            for (i = 0; i < numMessages; ++i) {
                receive = (TextMessage)sub.receive(5000L);
                Assert.assertNotNull((Object)receive);
                Assert.assertEquals((Object)receive.getText(), (Object)("message:" + i));
            }
            connection.close();
            connection = this.createConnection("myClientId");
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException exception) {
                    exception.printStackTrace();
                }
            });
            session = connection.createSession(false, 1);
            sub = session.createDurableSubscriber(topic, "myPubId");
            sendSession = connection.createSession(false, 1);
            producer = sendSession.createProducer((Destination)topic);
            connection.start();
            for (i = 0; i < numMessages; ++i) {
                producer.send((Message)sendSession.createTextMessage("message:" + i));
            }
            for (i = 0; i < numMessages; ++i) {
                receive = (TextMessage)sub.receive(5000L);
                Assert.assertNotNull((Object)receive);
                Assert.assertEquals((Object)receive.getText(), (Object)("message:" + i));
            }
        }
    }
}

