/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Symbol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IngressTimestampTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    @Parameterized.Parameter(value=0)
    public boolean restart;
    @Parameterized.Parameter(value=1)
    public boolean large;

    @Parameterized.Parameters(name="restart={0}, large={1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true, true}, {false, false}, {true, false}, {false, true});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setEnableIngressTimestamp(true));
        this.server.createQueue(new QueueConfiguration(this.QUEUE).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testSendCoreReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.AMQP);
    }

    @Test
    public void testSendAMQPReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.AMQP);
    }

    @Test
    public void testSendOpenWireReceiveAMQP() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.AMQP);
    }

    @Test
    public void testSendCoreReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.CORE);
    }

    @Test
    public void testSendAMQPReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.CORE);
    }

    @Test
    public void testSendOpenWireReceiveCore() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.CORE);
    }

    @Test
    public void testSendCoreReceiveOpenwire() throws Throwable {
        this.internalSendReceive(Protocol.CORE, Protocol.OPENWIRE);
    }

    @Test
    public void testSendAMQPReceiveOpenWire() throws Throwable {
        this.internalSendReceive(Protocol.AMQP, Protocol.OPENWIRE);
    }

    @Test
    public void testSendOpenWireReceiveOpenWire() throws Throwable {
        this.internalSendReceive(Protocol.OPENWIRE, Protocol.OPENWIRE);
    }

    private void internalSendReceive(Protocol protocolSender, Protocol protocolConsumer) throws Throwable {
        long afterSend;
        long beforeSend;
        Throwable throwable;
        Queue queue2;
        Throwable throwable2;
        Session session;
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        try (Connection connection = factorySend.createConnection();){
            session = connection.createSession(false, 1);
            throwable2 = null;
            try {
                queue2 = session.createQueue(this.QUEUE.toString());
                throwable = null;
                try (MessageProducer producer = session.createProducer((Destination)queue2);){
                    producer.setDeliveryMode(2);
                    TextMessage msg = session.createTextMessage(this.getMessagePayload());
                    beforeSend = System.currentTimeMillis();
                    producer.send((Message)msg);
                    afterSend = System.currentTimeMillis();
                }
                catch (Throwable msg) {
                    throwable = msg;
                    throw msg;
                }
            }
            catch (Throwable queue2) {
                throwable2 = queue2;
                throw queue2;
            }
            finally {
                if (session != null) {
                    if (throwable2 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable queue2) {
                            throwable2.addSuppressed(queue2);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        if (this.restart) {
            this.server.stop();
            this.server.start();
            IngressTimestampTest.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        }
        connection = factoryConsume.createConnection();
        var10_6 = null;
        try {
            connection.start();
            session = connection.createSession(false, 1);
            throwable2 = null;
            try {
                queue2 = session.createQueue(this.QUEUE.toString());
                throwable = null;
                try (MessageConsumer consumer = session.createConsumer((Destination)queue2);){
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assert.assertNotNull((Object)message);
                    Enumeration e = message.getPropertyNames();
                    while (e.hasMoreElements()) {
                        System.out.println(e.nextElement());
                    }
                    Object ingressTimestampHeader = null;
                    if (protocolConsumer == Protocol.AMQP) {
                        Method getMessageAnnotation = AmqpJmsMessageFacade.class.getDeclaredMethod("getMessageAnnotation", Symbol.class);
                        getMessageAnnotation.setAccessible(true);
                        ingressTimestampHeader = getMessageAnnotation.invoke((Object)((JmsTextMessage)message).getFacade(), Symbol.getSymbol((String)"x-opt-ingress-time"));
                    } else {
                        ingressTimestampHeader = message.getObjectProperty(org.apache.activemq.artemis.api.core.Message.HDR_INGRESS_TIMESTAMP.toString());
                    }
                    IngressTimestampTest.assertNotNull((Object)ingressTimestampHeader);
                    IngressTimestampTest.assertTrue((boolean)(ingressTimestampHeader instanceof Long));
                    long ingressTimestamp = (Long)ingressTimestampHeader;
                    IngressTimestampTest.assertTrue((String)("Ingress timstamp " + ingressTimestamp + " should be >= " + beforeSend + " and <= " + afterSend), (ingressTimestamp >= beforeSend && ingressTimestamp <= afterSend ? (byte)1 : 0) != 0);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (session != null) {
                    if (throwable2 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var10_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (connection != null) {
                if (var10_6 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable7) {
                        var10_6.addSuppressed(throwable7);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    private String getMessagePayload() {
        StringBuilder result = new StringBuilder();
        if (this.large) {
            for (int i = 0; i < 2048000; ++i) {
                result.append("AB");
            }
        } else {
            result.append("AB");
        }
        return result.toString();
    }

    private ConnectionFactory createFactory(Protocol protocol) {
        switch (protocol) {
            case CORE: {
                return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
            }
            case AMQP: {
                return new JmsConnectionFactory("amqp://localhost:61616");
            }
            case OPENWIRE: {
                return new ActiveMQConnectionFactory("tcp://localhost:61616");
            }
        }
        return null;
    }

    private static enum Protocol {
        CORE,
        AMQP,
        OPENWIRE;

    }
}

