/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSOrderTest
extends JMSTestBase {
    String protocol;
    ConnectionFactory protocolCF;

    public JMSOrderTest(String protocol) {
        this.protocol = protocol;
    }

    @Before
    public void setupCF() {
        this.protocolCF = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
    }

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection getParameters() {
        return Arrays.asList({"AMQP"}, {"OPENWIRE"}, {"CORE"});
    }

    protected void sendToAmqQueue(int count) throws Exception {
        Connection activemqConnection = this.protocolCF.createConnection();
        Session amqSession = activemqConnection.createSession(false, 1);
        jakarta.jms.Queue amqTestQueue = amqSession.createQueue(this.name.getMethodName());
        this.sendMessages(activemqConnection, (Destination)amqTestQueue, count);
        activemqConnection.close();
    }

    public void sendMessages(Connection connection, Destination destination, int count) throws Exception {
        Session session = connection.createSession(false, 1);
        MessageProducer p = session.createProducer(destination);
        for (int i = 1; i <= count; ++i) {
            TextMessage message = session.createTextMessage();
            message.setText("TextMessage: " + i);
            message.setIntProperty("nr", i);
            p.send((Message)message);
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReceiveSomeThenRollback() throws Exception {
        try (Connection connection = this.protocolCF.createConnection();){
            int i;
            connection.start();
            int totalCount = 5;
            int consumeBeforeRollback = 2;
            this.sendToAmqQueue(totalCount);
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.name.getMethodName());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 1; i2 <= consumeBeforeRollback; ++i2) {
                Message message = consumer.receive(3000L);
                JMSOrderTest.assertNotNull((Object)message);
                JMSOrderTest.assertEquals((String)"Unexpected message number", (long)i2, (long)message.getIntProperty("nr"));
            }
            session.rollback();
            ArrayList<Integer> messageNumbers = new ArrayList<Integer>();
            for (i = 1; i <= totalCount; ++i) {
                Message message = consumer.receive(3000L);
                JMSOrderTest.assertNotNull((String)("Failed to receive message: " + i), (Object)message);
                int msgNum = message.getIntProperty("nr");
                messageNumbers.add(msgNum);
            }
            session.commit();
            JMSOrderTest.assertEquals((String)"Unexpected size of list", (long)totalCount, (long)messageNumbers.size());
            for (i = 0; i < messageNumbers.size(); ++i) {
                JMSOrderTest.assertEquals((String)("Unexpected order of messages: " + messageNumbers), (Object)(i + 1), messageNumbers.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReceiveSomeThenClose() throws Exception {
        try (Connection connection = this.protocolCF.createConnection();){
            int i;
            connection.start();
            int totalCount = 5;
            int consumeBeforeRollback = 2;
            this.sendToAmqQueue(totalCount);
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.name.getMethodName());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 1; i2 <= consumeBeforeRollback; ++i2) {
                Message message = consumer.receive(3000L);
                JMSOrderTest.assertNotNull((Object)message);
                JMSOrderTest.assertEquals((String)"Unexpected message number", (long)i2, (long)message.getIntProperty("nr"));
            }
            session.close();
            session = connection.createSession(true, 0);
            queue = session.createQueue(this.name.getMethodName());
            consumer = session.createConsumer((Destination)queue);
            ArrayList<Integer> messageNumbers = new ArrayList<Integer>();
            for (i = 1; i <= totalCount; ++i) {
                Message message = consumer.receive(3000L);
                JMSOrderTest.assertNotNull((String)("Failed to receive message: " + i), (Object)message);
                int msgNum = message.getIntProperty("nr");
                messageNumbers.add(msgNum);
            }
            session.commit();
            JMSOrderTest.assertEquals((String)"Unexpected size of list", (long)totalCount, (long)messageNumbers.size());
            for (i = 0; i < messageNumbers.size(); ++i) {
                JMSOrderTest.assertEquals((String)("Unexpected order of messages: " + messageNumbers), (Object)(i + 1), messageNumbers.get(i));
            }
        }
    }

    @Test
    public void testMultipleConsumersRollback() throws Exception {
        this.internalMultipleConsumers(true);
    }

    @Test
    public void testMultipleConsumersClose() throws Exception {
        this.internalMultipleConsumers(false);
    }

    private void internalMultipleConsumers(boolean rollback) throws Exception {
        int i;
        jakarta.jms.Queue jmsQueue;
        Queue serverQueue = this.server.createQueue(new QueueConfiguration(this.getName()).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        int numberOfMessages = 100;
        int numberOfConsumers = 3;
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jmsQueue = session.createQueue(this.getName());
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (i = 0; i < numberOfMessages; ++i) {
                TextMessage message = session.createTextMessage("test " + i);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
        }
        Wait.assertEquals((long)numberOfMessages, () -> ((Queue)serverQueue).getMessageCount());
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger errors = new AtomicInteger(0);
        Runnable r = () -> {
            try (Connection c = factory.createConnection();){
                Session s = c.createSession(true, 0);
                MessageConsumer cs = s.createConsumer((Destination)jmsQueue);
                c.start();
                int rollbacks = 0;
                while (running.get()) {
                    TextMessage txt = (TextMessage)cs.receive(500L);
                    if (txt != null) {
                        if (!rollback) continue;
                        s.rollback();
                        if (++rollbacks < 3) continue;
                        break;
                    }
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                errors.incrementAndGet();
                running.set(false);
            }
        };
        Thread[] threads = new Thread[numberOfConsumers];
        for (i = 0; i < numberOfConsumers; ++i) {
            threads[i] = new Thread(r, "consumer " + i);
            threads[i].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
        Wait.assertEquals((long)numberOfMessages, () -> ((Queue)serverQueue).getMessageCount());
        try (Connection c = factory.createConnection();){
            Session s = c.createSession(true, 0);
            MessageConsumer cs = s.createConsumer((Destination)jmsQueue);
            c.start();
            for (int i2 = 0; i2 < numberOfMessages; ++i2) {
                TextMessage message = (TextMessage)cs.receive(1000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((long)i2, (long)message.getIntProperty("i"));
            }
            Assert.assertNull((Object)cs.receiveNoWait());
        }
    }
}

