/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionFactoryTest
extends ActiveMQTestBase {
    private final DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(SessionFactoryTest.getUDPDiscoveryAddress()).setGroupPort(SessionFactoryTest.getUDPDiscoveryPort()));
    private ActiveMQServer liveService;
    private TransportConfiguration liveTC;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    @Test
    public void testCloseUnusedClientSessionFactoryWithoutGlobalPools() throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        ClientSessionFactory csf = this.createSessionFactory(locator);
        csf.close();
    }

    @Test
    public void testDiscoveryConstructor() throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)this.groupConfiguration);
        this.assertFactoryParams(locator, null, this.groupConfiguration, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        Assert.assertNotNull((Object)session);
        session.close();
        this.testSettersThrowException(cf);
        cf.close();
        locator.close();
    }

    @Test
    public void testStaticConnectorListConstructor() throws Exception {
        TransportConfiguration[] tc = new TransportConfiguration[]{this.liveTC};
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tc);
        this.assertFactoryParams(locator, tc, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        Assert.assertNotNull((Object)session);
        session.close();
        this.testSettersThrowException(cf);
        cf.close();
    }

    @Test
    public void testGettersAndSetters() throws Exception {
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int ackBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        TransportConfiguration[] tc = new TransportConfiguration[]{this.liveTC};
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tc).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setCallTimeout(callTimeout).setMinLargeMessageSize(minLargeMessageSize).setConsumerWindowSize(consumerWindowSize).setConsumerMaxRate(consumerMaxRate).setConfirmationWindowSize(confirmationWindowSize).setProducerMaxRate(producerMaxRate).setBlockOnAcknowledge(blockOnAcknowledge).setBlockOnDurableSend(blockOnDurableSend).setBlockOnNonDurableSend(blockOnNonDurableSend).setAutoGroup(autoGroup).setPreAcknowledge(preAcknowledge).setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName).setAckBatchSize(ackBatchSize).setUseGlobalPools(useGlobalPools).setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize).setThreadPoolMaxSize(threadPoolMaxSize).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setReconnectAttempts(reconnectAttempts);
        SessionFactoryTest.assertEqualsTransportConfigurations((TransportConfiguration[])tc, (TransportConfiguration[])locator.getStaticTransportConfigurations());
        Assert.assertEquals((long)clientFailureCheckPeriod, (long)locator.getClientFailureCheckPeriod());
        Assert.assertEquals((long)connectionTTL, (long)locator.getConnectionTTL());
        Assert.assertEquals((long)callTimeout, (long)locator.getCallTimeout());
        Assert.assertEquals((long)minLargeMessageSize, (long)locator.getMinLargeMessageSize());
        Assert.assertEquals((long)consumerWindowSize, (long)locator.getConsumerWindowSize());
        Assert.assertEquals((long)consumerMaxRate, (long)locator.getConsumerMaxRate());
        Assert.assertEquals((long)confirmationWindowSize, (long)locator.getConfirmationWindowSize());
        Assert.assertEquals((long)producerMaxRate, (long)locator.getProducerMaxRate());
        Assert.assertEquals((Object)blockOnAcknowledge, (Object)locator.isBlockOnAcknowledge());
        Assert.assertEquals((Object)blockOnDurableSend, (Object)locator.isBlockOnDurableSend());
        Assert.assertEquals((Object)blockOnNonDurableSend, (Object)locator.isBlockOnNonDurableSend());
        Assert.assertEquals((Object)autoGroup, (Object)locator.isAutoGroup());
        Assert.assertEquals((Object)preAcknowledge, (Object)locator.isPreAcknowledge());
        Assert.assertEquals((Object)loadBalancingPolicyClassName, (Object)locator.getConnectionLoadBalancingPolicyClassName());
        Assert.assertEquals((long)ackBatchSize, (long)locator.getAckBatchSize());
        Assert.assertEquals((Object)useGlobalPools, (Object)locator.isUseGlobalPools());
        Assert.assertEquals((long)scheduledThreadPoolMaxSize, (long)locator.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)threadPoolMaxSize, (long)locator.getThreadPoolMaxSize());
        Assert.assertEquals((long)retryInterval, (long)locator.getRetryInterval());
        Assert.assertEquals((double)retryIntervalMultiplier, (double)locator.getRetryIntervalMultiplier(), (double)1.0E-6);
        Assert.assertEquals((long)reconnectAttempts, (long)locator.getReconnectAttempts());
    }

    private void testSettersThrowException(ClientSessionFactory cf) {
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int ackBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        try {
            cf.getServerLocator().setClientFailureCheckPeriod(clientFailureCheckPeriod);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConnectionTTL(connectionTTL);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setCallTimeout(callTimeout);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setMinLargeMessageSize(minLargeMessageSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConsumerWindowSize(consumerWindowSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConsumerMaxRate(consumerMaxRate);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConfirmationWindowSize(confirmationWindowSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setProducerMaxRate(producerMaxRate);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnAcknowledge(blockOnAcknowledge);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnDurableSend(blockOnDurableSend);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setBlockOnNonDurableSend(blockOnNonDurableSend);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setAutoGroup(autoGroup);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setPreAcknowledge(preAcknowledge);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setAckBatchSize(ackBatchSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setUseGlobalPools(useGlobalPools);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setThreadPoolMaxSize(threadPoolMaxSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setRetryInterval(retryInterval);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setRetryIntervalMultiplier(retryIntervalMultiplier);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.getServerLocator().setReconnectAttempts(reconnectAttempts);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        cf.getServerLocator().getStaticTransportConfigurations();
        cf.getServerLocator().getClientFailureCheckPeriod();
        cf.getServerLocator().getConnectionTTL();
        cf.getServerLocator().getCallTimeout();
        cf.getServerLocator().getMinLargeMessageSize();
        cf.getServerLocator().getConsumerWindowSize();
        cf.getServerLocator().getConsumerMaxRate();
        cf.getServerLocator().getConfirmationWindowSize();
        cf.getServerLocator().getProducerMaxRate();
        cf.getServerLocator().isBlockOnAcknowledge();
        cf.getServerLocator().isBlockOnDurableSend();
        cf.getServerLocator().isBlockOnNonDurableSend();
        cf.getServerLocator().isAutoGroup();
        cf.getServerLocator().isPreAcknowledge();
        cf.getServerLocator().getConnectionLoadBalancingPolicyClassName();
        cf.getServerLocator().getAckBatchSize();
        cf.getServerLocator().isUseGlobalPools();
        cf.getServerLocator().getScheduledThreadPoolMaxSize();
        cf.getServerLocator().getThreadPoolMaxSize();
        cf.getServerLocator().getRetryInterval();
        cf.getServerLocator().getRetryIntervalMultiplier();
        cf.getServerLocator().getReconnectAttempts();
    }

    private void assertFactoryParams(ServerLocator locator, TransportConfiguration[] staticConnectors, DiscoveryGroupConfiguration discoveryGroupConfiguration, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int ackBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts) {
        if (staticConnectors == null) {
            Assert.assertTrue((String)"no static connectors", (boolean)Arrays.equals(new String[0], locator.getStaticTransportConfigurations()));
        } else {
            SessionFactoryTest.assertEqualsTransportConfigurations((TransportConfiguration[])staticConnectors, (TransportConfiguration[])locator.getStaticTransportConfigurations());
        }
        Assert.assertEquals((Object)locator.getDiscoveryGroupConfiguration(), (Object)discoveryGroupConfiguration);
        Assert.assertEquals((long)locator.getClientFailureCheckPeriod(), (long)clientFailureCheckPeriod);
        Assert.assertEquals((long)locator.getConnectionTTL(), (long)connectionTTL);
        Assert.assertEquals((long)locator.getCallTimeout(), (long)callTimeout);
        Assert.assertEquals((long)locator.getMinLargeMessageSize(), (long)minLargeMessageSize);
        Assert.assertEquals((long)locator.getConsumerWindowSize(), (long)consumerWindowSize);
        Assert.assertEquals((long)locator.getConsumerMaxRate(), (long)consumerMaxRate);
        Assert.assertEquals((long)locator.getConfirmationWindowSize(), (long)confirmationWindowSize);
        Assert.assertEquals((long)locator.getProducerMaxRate(), (long)producerMaxRate);
        Assert.assertEquals((Object)locator.isBlockOnAcknowledge(), (Object)blockOnAcknowledge);
        Assert.assertEquals((Object)locator.isBlockOnDurableSend(), (Object)blockOnDurableSend);
        Assert.assertEquals((Object)locator.isBlockOnNonDurableSend(), (Object)blockOnNonDurableSend);
        Assert.assertEquals((Object)locator.isAutoGroup(), (Object)autoGroup);
        Assert.assertEquals((Object)locator.isPreAcknowledge(), (Object)preAcknowledge);
        Assert.assertEquals((Object)locator.getConnectionLoadBalancingPolicyClassName(), (Object)loadBalancingPolicyClassName);
        Assert.assertEquals((long)locator.getAckBatchSize(), (long)ackBatchSize);
        Assert.assertEquals((Object)locator.isUseGlobalPools(), (Object)useGlobalPools);
        Assert.assertEquals((long)locator.getScheduledThreadPoolMaxSize(), (long)scheduledThreadPoolMaxSize);
        Assert.assertEquals((long)locator.getThreadPoolMaxSize(), (long)threadPoolMaxSize);
        Assert.assertEquals((long)locator.getRetryInterval(), (long)retryInterval);
        Assert.assertEquals((double)locator.getRetryIntervalMultiplier(), (double)retryIntervalMultiplier, (double)1.0E-6);
        Assert.assertEquals((long)locator.getReconnectAttempts(), (long)reconnectAttempts);
    }

    private void startServer() throws Exception {
        this.liveTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration broadcastGroupConfiguration = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(Arrays.asList(this.liveTC.getName())).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(SessionFactoryTest.getUDPDiscoveryAddress()).setGroupPort(SessionFactoryTest.getUDPDiscoveryPort()).setLocalBindPort(5432));
        Configuration liveConf = this.createDefaultInVMConfig().addConnectorConfiguration(this.liveTC.getName(), this.liveTC).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addBroadcastGroupConfiguration(broadcastGroupConfiguration);
        this.liveService = this.createServer(false, liveConf);
        this.liveService.start();
    }
}

