/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class FailoverTestBase
extends ActiveMQTestBase {
    protected static final SimpleString ADDRESS = new SimpleString("FailoverTestAddress");
    protected static final int MIN_LARGE_MESSAGE = 1024;
    private static final int LARGE_MESSAGE_SIZE = 3072;
    protected static final int PAGE_MAX = 2048;
    protected static final int PAGE_SIZE = 1024;
    protected TestableServer liveServer;
    protected TestableServer backupServer;
    protected Configuration backupConfig;
    protected Configuration liveConfig;
    protected NodeManager nodeManager;
    protected NodeManager backupNodeManager;
    protected DistributedPrimitiveManagerConfiguration managerConfiguration;
    protected boolean startBackupServer = true;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createConfigs();
        this.setLiveIdentity();
        this.liveServer.start();
        this.waitForServerToStart(this.liveServer.getServer());
        if (this.backupServer != null) {
            this.setBackupIdentity();
            if (this.startBackupServer) {
                this.backupServer.start();
                this.waitForBackup();
            }
        }
    }

    protected void waitForBackup() {
        FailoverTestBase.waitForRemoteBackupSynchronization((ActiveMQServer)this.backupServer.getServer());
    }

    protected void setBackupIdentity() {
        this.backupServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/backupServers");
    }

    protected void setLiveIdentity() {
        this.liveServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/liveServer");
    }

    protected TestableServer createTestableServer(Configuration config) throws Exception {
        return this.createTestableServer(config, this.nodeManager);
    }

    protected TestableServer createTestableServer(Configuration config, NodeManager nodeManager) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreSlavePolicyConfiguration;
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    protected TestableServer createColocatedTestableServer(Configuration config, NodeManager liveNodeManager, NodeManager backupNodeManager, int id) {
        return new SameProcessActiveMQServer(this.createColocatedInVMFailoverServer(true, config, liveNodeManager, backupNodeManager, id));
    }

    protected static void setLargeMessageBody(int i, ClientMessage message) {
        try {
            message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)3072L));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void assertLargeMessageBody(int i, ClientMessage message) {
        ActiveMQBuffer buffer = message.getBodyBuffer();
        for (int j = 0; j < 3072; ++j) {
            Assert.assertTrue((String)("msg " + i + ", expecting " + 3072 + " bytes, got " + j), (boolean)buffer.readable());
            Assert.assertEquals((String)("equal at " + j), (long)ActiveMQTestBase.getSamplebyte((long)j), (long)buffer.readByte());
        }
    }

    protected NodeManager createNodeManager() throws Exception {
        return new InVMNodeManager(false);
    }

    protected NodeManager createNodeManager(Configuration configuration) throws Exception {
        return new InVMNodeManager(false, configuration.getNodeManagerLockLocation());
    }

    protected void createConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), new String[]{liveConnector.getName()}));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.liveConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(this.createBasicClusterConfig(liveConnector.getName(), new String[0])).addConnectorConfiguration(liveConnector.getName(), liveConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
    }

    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        return new InVMNodeManager(true, backupConfig.getJournalLocation());
    }

    protected boolean supportsRetention() {
        return true;
    }

    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.liveConfig = this.createDefaultInVMConfig();
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.liveConfig, liveConnector, null);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.liveConfig);
        this.liveServer = this.createTestableServer(this.liveConfig, this.nodeManager);
        if (this.supportsRetention()) {
            this.liveServer.getServer().getConfiguration().setJournalRetentionDirectory(this.getJournalDir(0, false) + "_retention");
            this.backupServer.getServer().getConfiguration().setJournalRetentionDirectory(this.getJournalDir(0, true) + "_retention");
        }
    }

    protected void createPluggableReplicatedConfigs() throws Exception {
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.liveConfig = this.createDefaultInVMConfig();
        this.managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.liveConfig, liveConnector, null, this.managerConfiguration, this.managerConfiguration);
        this.backupConfig.setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true)).setSecurityEnabled(false);
        this.setupHAPolicyConfiguration();
        this.backupNodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig, this.backupNodeManager);
        this.liveConfig.clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.nodeManager = this.createNodeManager(this.liveConfig);
        this.liveServer = this.createTestableServer(this.liveConfig, this.nodeManager);
    }

    protected void setupHAPolicyConfiguration() {
        Assert.assertTrue((boolean)(this.backupConfig.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration));
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
        ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
    }

    protected final void adaptLiveConfigForReplicatedFailBack(TestableServer server) {
        Configuration configuration = server.getServer().getConfiguration();
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        if (server.getServer().getHAPolicy().isSharedStore()) {
            ClusterConnectionConfiguration cc = (ClusterConnectionConfiguration)configuration.getClusterConfigurations().get(0);
            Assert.assertNotNull((String)"cluster connection configuration", (Object)cc);
            Assert.assertNotNull((String)"static connectors", (Object)cc.getStaticConnectors());
            cc.getStaticConnectors().add(backupConnector.getName());
            configuration.getConnectorConfigurations().put(backupConnector.getName(), backupConnector);
            return;
        }
        HAPolicy policy = server.getServer().getHAPolicy();
        if (policy instanceof ReplicatedPolicy) {
            ((ReplicatedPolicy)policy).setCheckForLiveServer(true);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.logAndSystemOut("#test tearDown");
        InVMConnector.failOnCreateConnection = false;
        super.tearDown();
        Assert.assertEquals((long)0L, (long)InVMRegistry.instance.size());
        this.backupServer = null;
        this.liveServer = null;
        this.nodeManager = null;
        this.backupNodeManager = null;
        ServerSocket serverSocket = new ServerSocket(61616);
        serverSocket.close();
        serverSocket = new ServerSocket(61617);
        serverSocket.close();
    }

    protected ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers);
        locator.addClusterTopologyListener((ClusterTopologyListener)new LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        Assert.assertTrue((String)("topology members expected " + topologyMembers), (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        return sf;
    }

    protected void waitForBackup(ClientSessionFactoryInternal sessionFactory, int seconds) throws Exception {
        ActiveMQServerImpl actualServer = (ActiveMQServerImpl)this.backupServer.getServer();
        if (actualServer.getHAPolicy().isSharedStore()) {
            this.waitForServerToStart((ActiveMQServer)actualServer);
        } else {
            FailoverTestBase.waitForRemoteBackup((ClientSessionFactory)sessionFactory, (int)seconds, (boolean)true, (ActiveMQServer)actualServer);
        }
    }

    protected abstract TransportConfiguration getAcceptorTransportConfiguration(boolean var1);

    protected abstract TransportConfiguration getConnectorTransportConfiguration(boolean var1);

    protected ServerLocatorInternal getServerLocator() throws Exception {
        return (ServerLocatorInternal)this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{this.getConnectorTransportConfiguration(true), this.getConnectorTransportConfiguration(false)})).setRetryInterval(50L).setInitialConnectAttempts(50);
    }

    protected void crash(ClientSession ... sessions) throws Exception {
        this.crash(true, sessions);
    }

    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.crash(true, waitFailure, sessions);
    }

    protected void crash(boolean failover, boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.liveServer.crash(failover, waitFailure, sessions);
    }

    public static final class LatchClusterTopologyListener
    implements ClusterTopologyListener {
        final CountDownLatch latch;
        List<String> liveNode = new ArrayList<String>();
        List<String> backupNode = new ArrayList<String>();

        public LatchClusterTopologyListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            if (topologyMember.getLive() != null && !this.liveNode.contains(topologyMember.getLive().getName())) {
                this.liveNode.add(topologyMember.getLive().getName());
                this.latch.countDown();
            }
            if (topologyMember.getBackup() != null && !this.backupNode.contains(topologyMember.getBackup().getName())) {
                this.backupNode.add(topologyMember.getBackup().getName());
                this.latch.countDown();
            }
        }

        public void nodeDown(long uniqueEventID, String nodeID) {
        }
    }
}

