/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.security.SimpleClient;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NettySecurityClientTest
extends SpawnedTestBase {
    private ActiveMQServer messagingService;

    @Test
    public void testProducerConsumerClientWithoutSecurityManager() throws Exception {
        this.doTestProducerConsumerClient(false);
    }

    @Test
    public void testProducerConsumerClientWithSecurityManager() throws Exception {
        this.doTestProducerConsumerClient(true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(this.getNettyAcceptorTransportConfiguration(true));
        this.messagingService = this.createServer(false, (Configuration)config);
        this.messagingService.start();
        this.waitForServerToStart(this.messagingService);
    }

    private void doTestProducerConsumerClient(boolean withSecurityManager) throws Exception {
        String[] vmargs = new String[]{};
        if (withSecurityManager) {
            URL securityPolicyURL = Thread.currentThread().getContextClassLoader().getResource("restricted-security-client.policy");
            vmargs = new String[]{"-Djava.security.manager", "-Djava.security.policy=" + URLDecoder.decode(securityPolicyURL.getPath(), "UTF-8")};
        }
        Process p = SpawnedVMSupport.spawnVM((String)SimpleClient.class.getName(), (String)"-Xms512m", (String)"-Xmx512m", (String[])vmargs, (boolean)true, (boolean)true, (boolean)false, (String[])new String[]{NETTY_CONNECTOR_FACTORY});
        InputStreamReader isr = new InputStreamReader(p.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.replace('|', '\n')).startsWith("Listening")) continue;
            if ("OK".equals(line.trim())) break;
            System.out.println(line);
        }
        SpawnedVMSupport.startLogger((String)SimpleClient.class.getName(), (Process)p);
        p.waitFor();
        Assert.assertEquals((String)"client VM did not exit cleanly", (long)0L, (long)p.exitValue());
    }
}

