/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import io.netty.handler.ssl.SslHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CoreClientOverTwoWaySSLTest
extends ActiveMQTestBase {
    public static final SimpleString QUEUE = new SimpleString("QueueOverSSL");
    private String storeType;
    private String storeProvider;
    private String clientSSLProvider;
    private String serverSSLProvider;
    private String SERVER_SIDE_KEYSTORE;
    private String SERVER_SIDE_TRUSTSTORE;
    private String CLIENT_SIDE_TRUSTSTORE;
    private String CLIENT_SIDE_KEYSTORE;
    private final String PASSWORD = "securepass";
    private ActiveMQServer server;
    private TransportConfiguration tc;

    @Parameterized.Parameters(name="storeProvider={0}, storeType={1}, clientSSLProvider={2}, serverSSLProvider={3}")
    public static Collection getParameters() {
        return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS", "OPENSSL", "OPENSSL"}, {TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS", "OPENSSL", "JDK"}, {TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS", "JDK", "OPENSSL"}, {TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS", "JDK", "JDK"}, {"SunJCE", "JCEKS", "OPENSSL", "OPENSSL"}, {"SunJCE", "JCEKS", "OPENSSL", "JDK"}, {"SunJCE", "JCEKS", "JDK", "OPENSSL"}, {"SunJCE", "JCEKS", "JDK", "JDK"}, {"SUN", "JKS", "OPENSSL", "OPENSSL"}, {"SUN", "JKS", "OPENSSL", "JDK"}, {"SUN", "JKS", "JDK", "OPENSSL"}, {"SUN", "JKS", "JDK", "JDK"}, {"SunJSSE", "PKCS12", "OPENSSL", "OPENSSL"}, {"SunJSSE", "PKCS12", "OPENSSL", "JDK"}, {"SunJSSE", "PKCS12", "JDK", "OPENSSL"}, {"SunJSSE", "PKCS12", "JDK", "JDK"}, {"JKS", null, "JDK", "JDK"}, {"JCEKS", null, "JDK", "JDK"}, {"JKS", null, "JDK", "JDK"}, {"PKCS12", null, "JDK", "JDK"});
    }

    public CoreClientOverTwoWaySSLTest(String storeProvider, String storeType, String clientSSLProvider, String serverSSLProvider) {
        String suffix;
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        this.clientSSLProvider = clientSSLProvider;
        this.serverSSLProvider = serverSSLProvider;
        String string = suffix = storeType == null || storeType.length() == 0 ? storeProvider.toLowerCase() : storeType.toLowerCase();
        if (suffix.equalsIgnoreCase("PKCS12")) {
            suffix = "p12";
        }
        this.SERVER_SIDE_KEYSTORE = "server-keystore." + suffix;
        this.SERVER_SIDE_TRUSTSTORE = "client-ca-truststore." + suffix;
        this.CLIENT_SIDE_TRUSTSTORE = "server-ca-truststore." + suffix;
        this.CLIENT_SIDE_KEYSTORE = "client-keystore." + suffix;
    }

    @Test
    public void testTwoWaySSL() throws Exception {
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("keyStoreProvider", this.storeProvider);
        this.tc.getParams().put("keyStoreType", this.storeType);
        this.tc.getParams().put("keyStorePath", this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testTwoWaySSLVerifyClientHost() throws Exception {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.getConfiguration().put("verifyHost", true);
        acceptor.getConfiguration().put("trustStorePath", this.SERVER_SIDE_TRUSTSTORE);
        this.server.getRemotingService().stop(false);
        this.server.getRemotingService().start();
        this.server.getRemotingService().startAcceptors();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("keyStoreProvider", this.storeProvider);
        this.tc.getParams().put("keyStoreType", this.storeType);
        this.tc.getParams().put("keyStorePath", this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testTwoWaySSLVerifyClientHostNegative() throws Exception {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.getConfiguration().put("verifyHost", true);
        this.server.getRemotingService().stop(false);
        this.server.getRemotingService().start();
        this.server.getRemotingService().startAcceptors();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("trustStoreProvider", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("keyStoreProvider", this.storeType);
        this.tc.getParams().put("keyStorePath", "unknown" + this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        locator.setCallTimeout(1000L);
        try {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            CoreClientOverTwoWaySSLTest.fail((String)"Creating a session here should fail due to a certificate with a CN that doesn't match the host name.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTwoWaySSLVerifyClientTrustAllTrue() throws Exception {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.getConfiguration().put("needClientAuth", true);
        this.server.getRemotingService().stop(false);
        this.server.getRemotingService().start();
        this.server.getRemotingService().startAcceptors();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("trustAll", true);
        this.tc.getParams().put("keyStoreProvider", this.storeProvider);
        this.tc.getParams().put("keyStoreType", this.storeType);
        this.tc.getParams().put("keyStorePath", this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        sf.close();
    }

    @Test
    public void testTwoWaySSLVerifyClientTrustAllTrueByURI() throws Exception {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.getConfiguration().put("needClientAuth", true);
        this.server.getRemotingService().stop(false);
        this.server.getRemotingService().start();
        this.server.getRemotingService().startAcceptors();
        StringBuilder uri = new StringBuilder("tcp://" + this.tc.getParams().get("host").toString() + ":" + this.tc.getParams().get("port").toString());
        uri.append("?").append("sslEnabled").append("=true");
        uri.append("&").append("sslProvider").append("=").append(this.clientSSLProvider);
        uri.append("&").append("trustAll").append("=true");
        if (this.storeProvider != null && !this.storeProvider.equals(TransportConstants.DEFAULT_KEYSTORE_PROVIDER)) {
            uri.append("&").append("keyStoreProvider").append("=").append(this.storeProvider);
        }
        if (this.storeType != null && !this.storeType.equals("JKS")) {
            uri.append("&").append("keyStoreType").append("=").append(this.storeType);
        }
        uri.append("&").append("keyStorePath").append("=").append(this.CLIENT_SIDE_KEYSTORE);
        uri.append("&").append("keyStorePassword").append("=").append("securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)uri.toString()));
        ClientSessionFactory sf = this.createSessionFactory(locator);
        sf.close();
    }

    @Test
    public void testTwoWaySSLVerifyClientTrustAllFalse() throws Exception {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.getConfiguration().put("needClientAuth", true);
        this.server.getRemotingService().stop(false);
        this.server.getRemotingService().start();
        this.server.getRemotingService().startAcceptors();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("keyStoreProvider", this.storeProvider);
        this.tc.getParams().put("keyStoreType", this.storeType);
        this.tc.getParams().put("keyStorePath", this.CLIENT_SIDE_KEYSTORE);
        this.tc.getParams().put("keyStorePassword", "securepass");
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new MyInterceptor());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            CoreClientOverTwoWaySSLTest.fail((String)"Creating a session here should fail due to no trust store being set");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTwoWaySSLWithoutClientKeyStore() throws Exception {
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("sslProvider", this.clientSSLProvider);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        locator.setCallTimeout(1000L);
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
        }
        catch (ActiveMQConnectionTimedOutException activeMQConnectionTimedOutException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("sslProvider", this.serverSSLProvider);
        params.put("keyStorePath", this.SERVER_SIDE_KEYSTORE);
        params.put("keyStorePassword", "securepass");
        params.put("keyStoreProvider", this.storeProvider);
        params.put("keyStoreType", this.storeType);
        params.put("trustStorePath", this.SERVER_SIDE_TRUSTSTORE);
        params.put("trustStorePassword", "securepass");
        params.put("trustStoreProvider", this.storeProvider);
        params.put("trustStoreType", this.storeType);
        params.put("needClientAuth", true);
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
    }

    private class MyInterceptor
    implements Interceptor {
        private MyInterceptor() {
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 71) {
                try {
                    if (connection.getTransportConnection() instanceof NettyConnection) {
                        NettyConnection nettyConnection = (NettyConnection)connection.getTransportConnection();
                        SslHandler sslHandler = (SslHandler)nettyConnection.getChannel().pipeline().get("ssl");
                        Assert.assertNotNull((Object)sslHandler);
                        Assert.assertNotNull((Object)sslHandler.engine().getSession());
                        Assert.assertNotNull((Object)sslHandler.engine().getSession().getPeerCertificates());
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            return true;
        }
    }
}

