/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.client.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.LargeMessageControllerImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQConsumerContext;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LargeMessageBufferTest
extends ActiveMQTestBase {
    static int tmpFileCounter = 0;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ++tmpFileCounter;
        File tmp = new File(this.getTestDir());
        tmp.mkdirs();
    }

    @Test
    public void testGetBytes() throws Exception {
        LargeMessageControllerImpl buffer = this.create15BytesSample();
        for (int i = 1; i <= 15; ++i) {
            try {
                Assert.assertEquals((long)i, (long)buffer.readByte());
                continue;
            }
            catch (Exception e) {
                throw new Exception("Exception at position " + i, e);
            }
        }
        try {
            buffer.readByte();
            Assert.fail((String)"supposed to throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBytesIByteArray() throws Exception {
        LargeMessageControllerImpl buffer = this.create15BytesSample();
        byte[] bytes = new byte[15];
        buffer.getBytes(0, bytes);
        this.validateAgainstSample(bytes);
        try {
            buffer = this.create15BytesSample();
            bytes = new byte[16];
            buffer.getBytes(0, bytes);
            Assert.fail((String)"supposed to throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBytesILChannelBufferII() throws Exception {
        LargeMessageControllerImpl buffer = this.create15BytesSample();
        ActiveMQBuffer dstBuffer = ActiveMQBuffers.fixedBuffer((int)20);
        dstBuffer.setIndex(0, 5);
        buffer.getBytes(0, dstBuffer);
        byte[] compareBytes = new byte[15];
        dstBuffer.getBytes(5, compareBytes);
        this.validateAgainstSample(compareBytes);
    }

    @Test
    public void testReadIntegers() throws Exception {
        LargeMessageControllerImpl buffer = this.createBufferWithIntegers(3, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        for (int i = 1; i <= 15; ++i) {
            Assert.assertEquals((long)i, (long)buffer.readInt());
        }
        try {
            buffer.readByte();
            Assert.fail((String)"supposed to throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testReadIntegersOverStream() throws Exception {
        LargeMessageControllerImpl buffer = this.createBufferWithIntegers(3, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
        ActiveMQBufferInputStream is = new ActiveMQBufferInputStream((ActiveMQBuffer)buffer);
        DataInputStream dataInput = new DataInputStream((InputStream)is);
        for (int i = 1; i <= 15; ++i) {
            Assert.assertEquals((long)i, (long)dataInput.readInt());
        }
        LargeMessageBufferTest.assertEquals((long)-1L, (long)dataInput.read());
        dataInput.close();
    }

    @Test
    public void testReadLongs() throws Exception {
        LargeMessageControllerImpl buffer = this.createBufferWithLongs(3, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L);
        for (int i = 1; i <= 15; ++i) {
            Assert.assertEquals((long)i, (long)buffer.readLong());
        }
        try {
            buffer.readByte();
            Assert.fail((String)"supposed to throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testReadLongsOverStream() throws Exception {
        LargeMessageControllerImpl buffer = this.createBufferWithLongs(3, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L);
        ActiveMQBufferInputStream is = new ActiveMQBufferInputStream((ActiveMQBuffer)buffer);
        DataInputStream dataInput = new DataInputStream((InputStream)is);
        for (int i = 1; i <= 15; ++i) {
            Assert.assertEquals((long)i, (long)dataInput.readLong());
        }
        LargeMessageBufferTest.assertEquals((long)-1L, (long)dataInput.read());
        dataInput.close();
    }

    @Test
    public void testReadData() throws Exception {
        ActiveMQBuffer dynamic = ActiveMQBuffers.dynamicBuffer((int)1);
        String str1 = RandomUtil.randomString();
        String str2 = RandomUtil.randomString();
        double d1 = RandomUtil.randomDouble();
        float f1 = RandomUtil.randomFloat();
        dynamic.writeUTF(str1);
        dynamic.writeString(str2);
        dynamic.writeDouble(d1);
        dynamic.writeFloat(f1);
        LargeMessageControllerImpl readBuffer = this.splitBuffer(3, dynamic.toByteBuffer().array());
        Assert.assertEquals((Object)str1, (Object)readBuffer.readUTF());
        Assert.assertEquals((Object)str2, (Object)readBuffer.readString());
        Assert.assertEquals((double)d1, (double)readBuffer.readDouble(), (double)1.0E-6);
        Assert.assertEquals((double)f1, (double)readBuffer.readFloat(), (double)1.0E-6);
    }

    private File getTestFile() {
        return new File(this.getTestDir(), "temp." + tmpFileCounter + ".file");
    }

    @Test
    public void testReadDataOverCached() throws Exception {
        this.clearDataRecreateServerDirs();
        ActiveMQBuffer dynamic = ActiveMQBuffers.dynamicBuffer((int)1);
        String str1 = RandomUtil.randomString();
        String str2 = RandomUtil.randomString();
        double d1 = RandomUtil.randomDouble();
        float f1 = RandomUtil.randomFloat();
        dynamic.writeUTF(str1);
        dynamic.writeString(str2);
        dynamic.writeDouble(d1);
        dynamic.writeFloat(f1);
        LargeMessageControllerImpl readBuffer = this.splitBuffer(3, dynamic.toByteBuffer().array(), this.getTestFile());
        Assert.assertEquals((Object)str1, (Object)readBuffer.readUTF());
        Assert.assertEquals((Object)str2, (Object)readBuffer.readString());
        Assert.assertEquals((double)d1, (double)readBuffer.readDouble(), (double)1.0E-8);
        Assert.assertEquals((double)f1, (double)readBuffer.readFloat(), (double)1.0E-6);
        readBuffer.readerIndex(0);
        Assert.assertEquals((Object)str1, (Object)readBuffer.readUTF());
        Assert.assertEquals((Object)str2, (Object)readBuffer.readString());
        Assert.assertEquals((double)d1, (double)readBuffer.readDouble(), (double)1.0E-8);
        Assert.assertEquals((double)f1, (double)readBuffer.readFloat(), (double)1.0E-6);
        readBuffer.close();
    }

    @Test
    public void testReadPartialData() throws Exception {
        final LargeMessageControllerImpl buffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 10L, 10L);
        buffer.addPacket(new byte[]{0, 1, 2, 3, 4}, 1, true);
        byte[] bytes = new byte[30];
        buffer.readBytes(bytes, 0, 5);
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)bytes[i]);
        }
        final CountDownLatch latchGo = new CountDownLatch(1);
        final AtomicInteger errorCount = new AtomicInteger(0);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    latchGo.countDown();
                    buffer.readBytes(new byte[5]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalAccessError illegalAccessError) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errorCount.incrementAndGet();
                }
            }
        };
        t.start();
        ActiveMQTestBase.waitForLatch((CountDownLatch)latchGo);
        buffer.cancel();
        t.join();
        Assert.assertEquals((long)0L, (long)errorCount.get());
    }

    @Test
    public void testInterruptData() throws Exception {
        LargeMessageControllerImpl readBuffer = this.splitBuffer(3, new byte[]{0, 1, 2, 3, 4});
        byte[] bytes = new byte[30];
        readBuffer.readBytes(bytes, 0, 5);
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)bytes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitBufferOnFile() throws Exception {
        try (LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 0x100000L, 1L, this.getTestFile(), 1024);){
            int i;
            long count = 0L;
            for (i = 0; i < 10; ++i) {
                byte[] buffer = new byte[10240];
                for (int j = 0; j < 10240; ++j) {
                    buffer[j] = LargeMessageBufferTest.getSamplebyte((long)count++);
                }
                outBuffer.addPacket(buffer, 1, true);
            }
            outBuffer.readerIndex(0);
            for (i = 0; i < 102400; ++i) {
                LargeMessageBufferTest.assertEquals((String)("position " + i), (long)LargeMessageBufferTest.getSamplebyte((long)i), (long)outBuffer.readByte());
            }
            outBuffer.readerIndex(0);
            for (i = 0; i < 102400; ++i) {
                LargeMessageBufferTest.assertEquals((String)("position " + i), (long)LargeMessageBufferTest.getSamplebyte((long)i), (long)outBuffer.readByte());
            }
        }
    }

    @Test
    public void testStreamData() throws Exception {
        final LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 11387L, 1000L);
        PipedOutputStream output = new PipedOutputStream();
        final PipedInputStream input = new PipedInputStream(output);
        final AtomicInteger errors = new AtomicInteger(0);
        final CountDownLatch done1 = new CountDownLatch(1);
        final CountDownLatch done2 = new CountDownLatch(1);
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger totalBytes = new AtomicInteger(0);
        Thread treader = new Thread("treader"){

            @Override
            public void run() {
                try {
                    byte[] line = new byte[1024];
                    int dataRead = 0;
                    while (dataRead >= 0) {
                        dataRead = input.read(line);
                        if (dataRead <= 0) continue;
                        totalBytes.addAndGet(dataRead);
                        if (count.incrementAndGet() != 3) continue;
                        done1.countDown();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    done1.countDown();
                    done2.countDown();
                }
            }
        };
        treader.setDaemon(true);
        treader.start();
        for (int i = 0; i < 3; ++i) {
            outBuffer.addPacket(new byte[1024], 1, true);
        }
        outBuffer.setOutputStream((OutputStream)output);
        final CountDownLatch waiting = new CountDownLatch(1);
        Thread twaiter = new Thread("twaiter"){

            @Override
            public void run() {
                try {
                    outBuffer.waitCompletion(0L);
                    waiting.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        twaiter.setDaemon(true);
        twaiter.start();
        Assert.assertTrue((boolean)done1.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)3L, (long)count.get());
        Assert.assertEquals((long)3072L, (long)totalBytes.get());
        for (int i = 0; i < 8; ++i) {
            outBuffer.addPacket(new byte[1024], 1, true);
        }
        Assert.assertEquals((long)1L, (long)waiting.getCount());
        outBuffer.addPacket(new byte[123], 1, false);
        Assert.assertTrue((boolean)done2.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)waiting.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)12L, (long)count.get());
        Assert.assertEquals((long)11387L, (long)totalBytes.get());
        treader.join();
        twaiter.join();
        Assert.assertEquals((long)0L, (long)errors.get());
        input.close();
    }

    @Test
    public void testStreamDataWaitCompletionOnCompleteBuffer() throws Exception {
        LargeMessageControllerImpl outBuffer = this.create15BytesSample();
        outBuffer.saveBuffer(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }

    @Test
    public void testStreamDataWaitCompletionOnInCompleteBuffer() throws Exception {
        LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 5L, 1000L);
        class FakeOutputStream
        extends OutputStream {
            FakeOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
            }
        }
        outBuffer.setOutputStream((OutputStream)new FakeOutputStream());
        long time = System.currentTimeMillis();
        try {
            outBuffer.waitCompletion(0L);
            LargeMessageBufferTest.fail((String)"supposed to throw an exception");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        LargeMessageBufferTest.assertTrue((String)"It was supposed to wait at least 1 second", (System.currentTimeMillis() - time > 1000L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testStreamDataWaitCompletionOnSlowComingBuffer() throws Exception {
        final LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 5L, 1000L);
        class FakeOutputStream
        extends OutputStream {
            FakeOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
            }
        }
        outBuffer.setOutputStream((OutputStream)new FakeOutputStream());
        Thread sender = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    outBuffer.addPacket(new byte[]{0}, 1, true);
                    Thread.sleep(100L);
                    outBuffer.addPacket(new byte[]{0}, 1, true);
                    Thread.sleep(200L);
                    outBuffer.addPacket(new byte[]{0}, 1, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        sender.start();
        LargeMessageBufferTest.assertTrue((boolean)outBuffer.waitCompletion(5000L));
        sender.join();
    }

    @Test
    public void testErrorOnSetStreaming() throws Exception {
        long start = System.currentTimeMillis();
        LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), 5L, 30000L);
        outBuffer.addPacket(new byte[]{0, 1, 2, 3, 4}, 1, true);
        final CountDownLatch latchBytesWritten1 = new CountDownLatch(5);
        final CountDownLatch latchBytesWritten2 = new CountDownLatch(10);
        outBuffer.setOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                latchBytesWritten1.countDown();
                latchBytesWritten2.countDown();
            }
        });
        ActiveMQTestBase.waitForLatch((CountDownLatch)latchBytesWritten1);
        try {
            outBuffer.readByte();
            Assert.fail((String)"supposed to throw an exception");
        }
        catch (IllegalAccessError illegalAccessError) {
            // empty catch block
        }
        Assert.assertTrue((String)"It waited too much", (System.currentTimeMillis() - start < 30000L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testReadBytesOnStreaming() throws Exception {
        int i;
        byte[] byteArray = new byte[1024];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byteArray[i2] = LargeMessageBufferTest.getSamplebyte((long)i2);
        }
        LargeMessageControllerImpl splitbuffer = this.splitBuffer(3, byteArray);
        ActiveMQBufferInputStream is = new ActiveMQBufferInputStream((ActiveMQBuffer)splitbuffer);
        for (i = 0; i < 100; ++i) {
            LargeMessageBufferTest.assertEquals((long)LargeMessageBufferTest.getSamplebyte((long)i), (long)((byte)is.read()));
        }
        for (i = 100; i < byteArray.length; i += 10) {
            byte[] readBytes = new byte[10];
            int size = is.read(readBytes);
            for (int j = 0; j < size; ++j) {
                LargeMessageBufferTest.assertEquals((long)LargeMessageBufferTest.getSamplebyte((long)(i + j)), (long)readBytes[j]);
            }
        }
        is.close();
    }

    private LargeMessageControllerImpl create15BytesSample() throws Exception {
        return this.splitBuffer(5, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
    }

    private LargeMessageControllerImpl createBufferWithIntegers(int splitFactor, int ... values) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(values.length * 4);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        for (int value : values) {
            dataOut.writeInt(value);
        }
        return this.splitBuffer(splitFactor, byteOut.toByteArray());
    }

    private LargeMessageControllerImpl createBufferWithLongs(int splitFactor, long ... values) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(values.length * 8);
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        for (long value : values) {
            dataOut.writeLong(value);
        }
        return this.splitBuffer(splitFactor, byteOut.toByteArray());
    }

    private LargeMessageControllerImpl splitBuffer(int splitFactor, byte[] bytes) throws Exception {
        return this.splitBuffer(splitFactor, bytes, null);
    }

    private LargeMessageControllerImpl splitBuffer(int splitFactor, byte[] bytes, File file) throws Exception {
        byte[] splitElement;
        int size;
        LargeMessageControllerImpl outBuffer = new LargeMessageControllerImpl((ClientConsumerInternal)new FakeConsumerInternal(), (long)bytes.length, 5000L, file);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        while ((size = input.read(splitElement = new byte[splitFactor])) > 0) {
            if (size < splitFactor) {
                byte[] newSplit = new byte[size];
                System.arraycopy(splitElement, 0, newSplit, 0, size);
                outBuffer.addPacket(newSplit, 1, input.available() > 0);
                continue;
            }
            outBuffer.addPacket(splitElement, 1, input.available() > 0);
        }
        return outBuffer;
    }

    private void validateAgainstSample(byte[] bytes) {
        for (int i = 1; i <= 15; ++i) {
            Assert.assertEquals((long)i, (long)bytes[i - 1]);
        }
    }

    static class FakeConsumerInternal
    implements ClientConsumerInternal {
        FakeConsumerInternal() {
        }

        public ConsumerContext getConsumerContext() {
            return new ActiveMQConsumerContext(0L);
        }

        public void close() throws ActiveMQException {
        }

        public Exception getLastException() {
            return null;
        }

        public MessageHandler getMessageHandler() throws ActiveMQException {
            return null;
        }

        public boolean isClosed() {
            return false;
        }

        public ClientMessage receive() throws ActiveMQException {
            return null;
        }

        public Thread getCurrentThread() {
            return null;
        }

        public ClientMessage receive(long timeout) throws ActiveMQException {
            return null;
        }

        public ClientMessage receiveImmediate() throws ActiveMQException {
            return null;
        }

        public FakeConsumerInternal setMessageHandler(MessageHandler handler) throws ActiveMQException {
            return this;
        }

        public void acknowledge(ClientMessage message) throws ActiveMQException {
        }

        public void individualAcknowledge(ClientMessage message) throws ActiveMQException {
        }

        public void cleanUp() throws ActiveMQException {
        }

        public void clear(boolean waitForOnMessage) throws ActiveMQException {
        }

        public void clearAtFailover() {
        }

        public void flowControl(int messageBytes, boolean discountSlowConsumer) throws ActiveMQException {
        }

        public void flushAcks() throws ActiveMQException {
        }

        public int getBufferSize() {
            return 0;
        }

        public int getClientWindowSize() {
            return 0;
        }

        public int getInitialWindowSize() {
            return 0;
        }

        public SimpleString getFilterString() {
            return null;
        }

        public int getPriority() {
            return 0;
        }

        public long getID() {
            return 0L;
        }

        public SimpleString getQueueName() {
            return null;
        }

        public boolean isBrowseOnly() {
            return false;
        }

        public void handleMessage(ClientMessageInternal message) throws Exception {
        }

        public void handleLargeMessage(ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        }

        public void handleLargeMessageContinuation(byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        }

        public void start() {
        }

        public void stop() throws ActiveMQException {
        }

        public void stop(boolean waitForOnMessage) throws ActiveMQException {
        }

        public ClientSession.QueueQuery getQueueInfo() {
            return null;
        }

        public long getForceDeliveryCount() {
            return 0L;
        }

        public ClientSessionInternal getSession() {
            return null;
        }

        public Thread prepareForClose(FutureLatch future) throws ActiveMQException {
            return null;
        }
    }
}

