/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import jakarta.resource.spi.security.PasswordCredential;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.jca.core.spi.security.SubjectFactory;

class SecurityActions {
    private SecurityActions() {
    }

    static Subject createSubject(final SubjectFactory subjectFactory, final String domain) {
        if (System.getSecurityManager() == null) {
            return subjectFactory.createSubject(domain);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return subjectFactory.createSubject(domain);
            }
        });
    }

    static Set<PasswordCredential> getPasswordCredentials(final Subject subject) {
        if (System.getSecurityManager() == null) {
            return subject.getPrivateCredentials(PasswordCredential.class);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Set<PasswordCredential>>(){

            @Override
            public Set<PasswordCredential> run() {
                return subject.getPrivateCredentials(PasswordCredential.class);
            }
        });
    }
}

