/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.DialectOverride;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.BasicValueBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public class BinderHelper {
    private static final Logger log = CoreLogging.logger(BinderHelper.class);
    public static final Set<String> PRIMITIVE_NAMES = Set.of(Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.TYPE.getName());

    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        SyntheticProperty clone = new SyntheticProperty();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    public static void createSyntheticPropertyReference(AnnotatedJoinColumn[] columns, PersistentClass ownerEntity, PersistentClass associatedEntity, Value value, boolean inverse, MetadataBuildingContext context) {
        AnnotatedJoinColumn firstColumn = columns[0];
        if (!firstColumn.isImplicit() && StringHelper.isEmpty(firstColumn.getMappedBy()) && AnnotatedJoinColumn.checkReferencedColumnsType(columns, ownerEntity, context) == 2) {
            Object columnOwner = BinderHelper.findColumnOwner(ownerEntity, firstColumn.getReferencedColumn(), context);
            for (AnnotatedJoinColumn col : columns) {
                Object owner = BinderHelper.findColumnOwner(ownerEntity, col.getReferencedColumn(), context);
                if (owner == null) {
                    throw new AnnotationException("A '@JoinColumn' for association " + BinderHelper.associationMessage(associatedEntity, columns[0]) + " references a column named '" + col.getReferencedColumn() + "' which is not mapped by the target entity");
                }
                if (owner == columnOwner) continue;
                throw new AnnotationException("The '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, columns[0]) + " reference columns of different tables mapped by the target entity ('" + col.getReferencedColumn() + "' belongs to a different table to '" + firstColumn.getReferencedColumn() + "'");
            }
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, columns, associatedEntity, context);
            Property property = BinderHelper.referencedProperty(ownerEntity, inverse, columns, columnOwner, properties, context);
            BinderHelper.registerSyntheticProperty(ownerEntity, value, inverse, firstColumn.getPropertyHolder().getPersistentClass(), firstColumn.getPropertyName(), property.getName(), context);
        }
    }

    private static Property referencedProperty(PersistentClass ownerEntity, boolean inverse, AnnotatedJoinColumn[] columns, Object columnOwner, List<Property> properties, MetadataBuildingContext context) {
        if (properties.size() == 1 && ownerEntity == columnOwner && !(properties.get(0).getValue() instanceof ToOne)) {
            return properties.get(0);
        }
        AnnotatedJoinColumn firstColumn = columns[0];
        PersistentClass associatedClass = firstColumn.getPropertyHolder().getPersistentClass();
        String syntheticPropertyName = BinderHelper.syntheticPropertyName(firstColumn.getPropertyName(), inverse, associatedClass);
        return BinderHelper.makeSyntheticComponentProperty(ownerEntity, columnOwner, context, syntheticPropertyName, properties);
    }

    private static void registerSyntheticProperty(PersistentClass ownerEntity, Value value, boolean inverse, PersistentClass associatedClass, String propertyName, String syntheticPropertyName, MetadataBuildingContext context) {
        if (value instanceof ToOne) {
            ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
            ((ToOne)value).setReferenceToPrimaryKey(false);
            context.getMetadataCollector().addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else if (value instanceof Collection) {
            ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
            context.getMetadataCollector().addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
        } else {
            throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
        }
        context.getMetadataCollector().addPropertyReferencedAssociation((inverse ? "inverse__" : "") + associatedClass.getEntityName(), propertyName, syntheticPropertyName);
    }

    private static String syntheticPropertyName(String propertyName, boolean inverse, PersistentClass associatedClass) {
        String syntheticPropertyName = "_" + associatedClass.getEntityName().replace('.', '_') + "_" + propertyName.replace('.', '_');
        if (inverse) {
            syntheticPropertyName = syntheticPropertyName + "_inverse";
        }
        return syntheticPropertyName;
    }

    private static String associationMessage(PersistentClass associatedEntity, AnnotatedJoinColumn firstColumn) {
        StringBuilder message = new StringBuilder();
        if (associatedEntity != null) {
            message.append("'").append(associatedEntity.getEntityName()).append(".").append(firstColumn.getPropertyName()).append("'");
        } else if (firstColumn.getPropertyHolder() != null) {
            message.append("'").append(firstColumn.getPropertyHolder().getEntityName()).append(".").append(firstColumn.getPropertyName()).append("'");
        }
        return message.toString();
    }

    private static Property makeSyntheticComponentProperty(PersistentClass ownerEntity, Object persistentClassOrJoin, MetadataBuildingContext context, String syntheticPropertyName, List<Property> properties) {
        Component embeddedComp = persistentClassOrJoin instanceof PersistentClass ? new Component(context, (PersistentClass)persistentClassOrJoin) : new Component(context, (Join)persistentClassOrJoin);
        embeddedComp.setComponentClassName(embeddedComp.getOwner().getClassName());
        embeddedComp.setEmbedded(true);
        Property property = BinderHelper.makeComponent(ownerEntity, context, syntheticPropertyName, embeddedComp, properties);
        property.setPropertyAccessorName("embedded");
        ownerEntity.addProperty(property);
        embeddedComp.createUniqueKey();
        return property;
    }

    private static Property makeComponent(PersistentClass ownerEntity, MetadataBuildingContext context, String name, Component embeddedComp, List<Property> properties) {
        for (Property property : properties) {
            Property clone = BinderHelper.cloneProperty(ownerEntity, context, property);
            embeddedComp.addProperty(clone);
        }
        embeddedComp.sortProperties();
        SyntheticProperty synthProp = new SyntheticProperty();
        synthProp.setName(name);
        synthProp.setPersistentClass(ownerEntity);
        synthProp.setUpdateable(false);
        synthProp.setInsertable(false);
        synthProp.setValue(embeddedComp);
        return synthProp;
    }

    private static Property cloneProperty(PersistentClass ownerEntity, MetadataBuildingContext context, Property property) {
        if (property.isComposite()) {
            Component component = (Component)property.getValue();
            Component copy = new Component(context, component);
            copy.setComponentClassName(component.getComponentClassName());
            copy.setEmbedded(component.isEmbedded());
            Property clone = BinderHelper.makeComponent(ownerEntity, context, property.getName(), copy, component.getProperties());
            clone.setPropertyAccessorName(property.getPropertyAccessorName());
            return clone;
        }
        Property clone = BinderHelper.shallowCopy(property);
        clone.setInsertable(false);
        clone.setUpdateable(false);
        clone.setNaturalIdentifier(false);
        clone.setValueGenerationStrategy(property.getValueGenerationStrategy());
        return clone;
    }

    private static List<Property> findPropertiesByColumns(Object columnOwner, AnnotatedJoinColumn[] columns, PersistentClass associatedEntity, MetadataBuildingContext context) {
        Table referencedTable;
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure((String)(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass()));
        }
        ArrayList<org.hibernate.mapping.Column> orderedColumns = new ArrayList<org.hibernate.mapping.Column>(columns.length);
        HashMap<org.hibernate.mapping.Column, Set<Property>> columnsToProperty = new HashMap<org.hibernate.mapping.Column, Set<Property>>();
        for (AnnotatedJoinColumn joinColumn : columns) {
            org.hibernate.mapping.Column column = new org.hibernate.mapping.Column(context.getMetadataCollector().getPhysicalColumnName(referencedTable, joinColumn.getReferencedColumn()));
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        if (columnOwner instanceof PersistentClass) {
            PersistentClass persistentClass = (PersistentClass)columnOwner;
            for (Property property : persistentClass.getProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
            if (persistentClass.hasIdentifierProperty()) {
                BinderHelper.matchColumnsByProperty(persistentClass.getIdentifierProperty(), columnsToProperty);
            } else {
                Component key = persistentClass.getIdentifierMapper();
                for (Property p : key.getProperties()) {
                    BinderHelper.matchColumnsByProperty(p, columnsToProperty);
                }
            }
        } else {
            for (Property property : ((Join)columnOwner).getProperties()) {
                BinderHelper.matchColumnsByProperty(property, columnsToProperty);
            }
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        int lastPropertyColumnIndex = 0;
        Property currentProperty = null;
        for (org.hibernate.mapping.Column column : orderedColumns) {
            Set properties = (Set)columnsToProperty.get(column);
            if (properties.isEmpty()) {
                throw new AnnotationException("Referenced column '" + column.getName() + "' in '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns[0]) + " is not mapped by any property of the target entity");
            }
            Iterator iterator = properties.iterator();
            if (!iterator.hasNext()) continue;
            Property property = (Property)iterator.next();
            if (property == currentProperty) {
                if (!property.getColumns().get(lastPropertyColumnIndex).equals(column)) {
                    throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's for association " + BinderHelper.associationMessage(associatedEntity, columns[0]));
                }
                if (++lastPropertyColumnIndex != currentProperty.getColumnSpan()) continue;
                currentProperty = null;
                lastPropertyColumnIndex = 0;
                continue;
            }
            if (currentProperty != null) {
                throw new AnnotationException("Target property '" + property.getName() + "' has " + property.getColumnSpan() + " columns which must be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns[0]) + " (every column mapped by '" + property.getName() + "' must occur exactly once as a 'referencedColumnName', and in the correct order)");
            }
            if (orderedProperties.contains(property)) {
                throw new AnnotationException("Target property '" + property.getName() + "' has only " + property.getColumnSpan() + " columns which may be referenced by a '@JoinColumn' for " + BinderHelper.associationMessage(associatedEntity, columns[0]) + " (each column mapped by '" + property.getName() + "' may only occur once as a 'referencedColumnName')");
            }
            orderedProperties.add(property);
            if (property.getColumnSpan() <= 1) continue;
            if (!property.getColumns().get(0).equals(column)) {
                throw new AnnotationException("Referenced column '" + column.getName() + "' mapped by target property '" + property.getName() + "' occurs out of order in the list of '@JoinColumn's");
            }
            currentProperty = property;
            lastPropertyColumnIndex = 1;
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<org.hibernate.mapping.Column, Set<Property>> columnsToProperty) {
        if (property != null && BuiltInPropertyAccessStrategies.NOOP != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName()) && BuiltInPropertyAccessStrategies.EMBEDDED != BuiltInPropertyAccessStrategies.interpret(property.getPropertyAccessorName())) {
            for (Selectable selectable : property.getSelectables()) {
                if (!columnsToProperty.containsKey(selectable)) continue;
                columnsToProperty.get(selectable).add(property);
            }
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String propertyName) {
        Property property = null;
        try {
            if (propertyName == null || propertyName.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(propertyName, ".", false);
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    property = component.getProperty(element);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        if (path.length() == entityName.length()) {
            return propertyName;
        }
        return StringHelper.qualify(path.substring(entityName.length() + 1), propertyName);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String columnName, MetadataBuildingContext context) {
        if (StringHelper.isEmpty(columnName)) {
            return persistentClass;
        }
        for (PersistentClass current = persistentClass; current != null; current = current.getSuperclass()) {
            try {
                context.getMetadataCollector().getPhysicalColumnName(current.getTable(), columnName);
                return current;
            }
            catch (MappingException mappingException) {
                for (Join join : current.getJoins()) {
                    try {
                        context.getMetadataCollector().getPhysicalColumnName(join.getTable(), columnName);
                        return join;
                    }
                    catch (MappingException mappingException2) {
                    }
                }
                continue;
            }
        }
        return null;
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, Map<String, IdentifierGeneratorDefinition> localGenerators) {
        log.debugf("#makeIdGenerator(%s, %s, %s, %s, ...)", new Object[]{id, idXProperty, generatorType, generatorName});
        Table table = id.getTable();
        table.setIdentifierValue(id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            params.setProperty("target_column", id.getColumns().get(0).getName());
        }
        params.put("identifier_normalizer", buildingContext.getObjectNameNormalizer());
        params.put("GENERATOR_NAME", generatorName);
        if (!BinderHelper.isEmptyAnnotationValue(generatorName)) {
            boolean avoidOverriding;
            IdentifierGeneratorDefinition gen = BinderHelper.getIdentifierGenerator(generatorName, idXProperty, localGenerators, buildingContext);
            if (gen == null) {
                throw new AnnotationException("No id generator was declared with the name '" + generatorName + "' specified by '@GeneratedValue' (define a named generator using '@SequenceGenerator', '@TableGenerator', or '@GenericGenerator')");
            }
            String identifierGeneratorStrategy = gen.getStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo");
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            for (Map.Entry<String, String> elt : gen.getParameters().entrySet()) {
                if (elt.getKey() == null) continue;
                params.setProperty(elt.getKey(), elt.getValue());
            }
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition foreignKGeneratorDefinition) {
        HashMap<String, IdentifierGeneratorDefinition> localIdentifiers = null;
        if (foreignKGeneratorDefinition != null) {
            localIdentifiers = new HashMap<String, IdentifierGeneratorDefinition>();
            localIdentifiers.put(foreignKGeneratorDefinition.getName(), foreignKGeneratorDefinition);
        }
        BinderHelper.makeIdGenerator(id, idXProperty, generatorType, generatorName, buildingContext, localIdentifiers);
    }

    private static IdentifierGeneratorDefinition getIdentifierGenerator(final String name, final XProperty idXProperty, Map<String, IdentifierGeneratorDefinition> localGenerators, final MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        log.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", (Object)name);
        final GeneratedValue generatedValueAnn = (GeneratedValue)idXProperty.getAnnotation(GeneratedValue.class);
        if (generatedValueAnn == null) {
            return new IdentifierGeneratorDefinition("assigned", "assigned");
        }
        IdGeneratorStrategyInterpreter generationInterpreter = buildingContext.getBuildingOptions().getIdGenerationTypeInterpreter();
        GenerationType generationType = BinderHelper.interpretGenerationType(generatedValueAnn);
        if (generationType == null || generationType == GenerationType.SEQUENCE) {
            log.debugf("Building implicit sequence-based IdentifierGeneratorDefinition (%s)", (Object)name);
            IdentifierGeneratorDefinition.Builder builder = new IdentifierGeneratorDefinition.Builder();
            generationInterpreter.interpretSequenceGenerator(new SequenceGenerator(){

                public String name() {
                    return name;
                }

                public String sequenceName() {
                    return "";
                }

                public String catalog() {
                    return "";
                }

                public String schema() {
                    return "";
                }

                public int initialValue() {
                    return 1;
                }

                public int allocationSize() {
                    return 50;
                }

                public Class<? extends Annotation> annotationType() {
                    return SequenceGenerator.class;
                }
            }, builder);
            return builder.build();
        }
        if (generationType == GenerationType.TABLE) {
            log.debugf("Building implicit table-based IdentifierGeneratorDefinition (%s)", (Object)name);
            IdentifierGeneratorDefinition.Builder builder = new IdentifierGeneratorDefinition.Builder();
            generationInterpreter.interpretTableGenerator(new TableGenerator(){

                public String name() {
                    return name;
                }

                public String table() {
                    return "";
                }

                public int initialValue() {
                    return 0;
                }

                public int allocationSize() {
                    return 50;
                }

                public String catalog() {
                    return "";
                }

                public String schema() {
                    return "";
                }

                public String pkColumnName() {
                    return "";
                }

                public String valueColumnName() {
                    return "";
                }

                public String pkColumnValue() {
                    return "";
                }

                public UniqueConstraint[] uniqueConstraints() {
                    return new UniqueConstraint[0];
                }

                public Index[] indexes() {
                    return new Index[0];
                }

                public Class<? extends Annotation> annotationType() {
                    return TableGenerator.class;
                }
            }, builder);
            return builder.build();
        }
        String strategyName = generationType == GenerationType.IDENTITY ? "identity" : generationInterpreter.determineGeneratorName(generationType, new IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext(){

            @Override
            public Class<?> getIdType() {
                return buildingContext.getBootstrapContext().getReflectionManager().toClass(idXProperty.getType());
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValueAnn.generator();
            }
        });
        log.debugf("Building implicit generic IdentifierGeneratorDefinition (%s) : %s", (Object)name, (Object)strategyName);
        return new IdentifierGeneratorDefinition(name, strategyName, Collections.singletonMap("GENERATOR_NAME", name));
    }

    private static GenerationType interpretGenerationType(GeneratedValue generatedValueAnn) {
        if (generatedValueAnn.strategy() == null) {
            return GenerationType.AUTO;
        }
        return generatedValueAnn.strategy();
    }

    public static boolean isEmptyAnnotationValue(String annotationString) {
        return annotationString != null && annotationString.length() == 0;
    }

    public static boolean isEmptyOrNullAnnotationValue(String annotationString) {
        return annotationString == null || annotationString.length() == 0;
    }

    public static String getAnnotationValueStringOrNull(String value) {
        return BinderHelper.isEmptyOrNullAnnotationValue(value) ? null : value;
    }

    public static Any buildAnyValue(Column discriminatorColumn, Formula discriminatorFormula, AnnotatedJoinColumn[] keyColumns, PropertyData inferredData, boolean cascadeOnDelete, boolean lazy, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean optional, MetadataBuildingContext context) {
        XProperty xProperty = inferredData.getProperty();
        Any value = new Any(context, keyColumns[0].getTable(), true);
        value.setLazy(lazy);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        BasicValueBinder discriminatorValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_DISCRIMINATOR, context);
        AnnotatedColumn[] discriminatorColumns = AnnotatedColumn.buildColumnOrFormulaFromAnnotation(discriminatorColumn, discriminatorFormula, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), context);
        assert (discriminatorColumns.length == 1);
        discriminatorColumns[0].setTable(value.getTable());
        discriminatorValueBinder.setColumns(discriminatorColumns);
        discriminatorValueBinder.setReturnedClassName(inferredData.getTypeName());
        discriminatorValueBinder.setType(xProperty, xProperty.getType(), null, null);
        BasicValue discriminatorDescriptor = discriminatorValueBinder.make();
        value.setDiscriminator(discriminatorDescriptor);
        discriminatorValueBinder.fillSimpleValue();
        discriminatorColumns[0].linkWithValue(discriminatorDescriptor);
        JavaType<?> discriminatorJavaType = discriminatorDescriptor.resolve().getRelationalJavaType();
        HashMap discriminatorValueMappings = new HashMap();
        BinderHelper.processAnyDiscriminatorValues(inferredData.getProperty(), valueMapping -> discriminatorValueMappings.put(discriminatorJavaType.wrap(valueMapping.discriminator(), null), valueMapping.entity()));
        value.setDiscriminatorValueMappings(discriminatorValueMappings);
        BasicValueBinder keyValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ANY_KEY, context);
        assert (keyColumns.length == 1);
        keyColumns[0].setTable(value.getTable());
        keyValueBinder.setColumns(keyColumns);
        if (!optional) {
            for (AnnotatedJoinColumn column : keyColumns) {
                column.setNullable(false);
            }
        }
        keyValueBinder.setType(xProperty, xProperty.getType(), null, null);
        BasicValue keyDescriptor = keyValueBinder.make();
        value.setKey(keyDescriptor);
        keyValueBinder.fillSimpleValue();
        AnnotatedColumn.checkPropertyConsistency(keyColumns, propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
        keyColumns[0].linkWithValue(keyDescriptor);
        return value;
    }

    private static void processAnyDiscriminatorValues(XProperty property, Consumer<AnyDiscriminatorValue> consumer) {
        AnyDiscriminatorValue[] valueAnns;
        AnyDiscriminatorValue valueAnn = (AnyDiscriminatorValue)property.getAnnotation(AnyDiscriminatorValue.class);
        if (valueAnn != null) {
            consumer.accept(valueAnn);
            return;
        }
        AnyDiscriminatorValues valuesAnn = (AnyDiscriminatorValues)property.getAnnotation(AnyDiscriminatorValues.class);
        if (valuesAnn != null && (valueAnns = valuesAnn.value()) != null && valueAnns.length > 0) {
            for (AnyDiscriminatorValue ann : valueAnns) {
                consumer.accept(ann);
            }
        }
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass declaringClass, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) {
        boolean retrieve = false;
        if (declaringClass != null) {
            InheritanceState inheritanceState = inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + declaringClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                retrieve = true;
            }
        }
        if (retrieve) {
            return context.getMetadataCollector().getMappedSuperclass(context.getBootstrapContext().getReflectionManager().toClass(declaringClass));
        }
        return null;
    }

    public static String getPath(PropertyHolder holder, PropertyData property) {
        return StringHelper.qualify(holder.getPath(), property.getPropertyName());
    }

    static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        XClass persistentXClass = buildingContext.getBootstrapContext().getReflectionManager().toXClass(propertyHolder.getPersistentClass().getMappedClass());
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        if (propertyHolder.isInIdClass()) {
            PropertyData pd = metadataCollector.getPropertyAnnotatedWithIdAndToOne(persistentXClass, propertyName);
            if (pd == null && buildingContext.getBuildingOptions().isSpecjProprietarySyntaxEnabled()) {
                pd = metadataCollector.getPropertyAnnotatedWithMapsId(persistentXClass, propertyName);
            }
            return pd;
        }
        return metadataCollector.getPropertyAnnotatedWithMapsId(persistentXClass, isId ? "" : propertyName);
    }

    public static Map<String, String> toAliasTableMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (!StringHelper.isNotEmpty(aliase.table())) continue;
            ret.put(aliase.alias(), aliase.table());
        }
        return ret;
    }

    public static Map<String, String> toAliasEntityMap(SqlFragmentAlias[] aliases) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlFragmentAlias aliase : aliases) {
            if (aliase.entity() == Void.TYPE) continue;
            ret.put(aliase.alias(), aliase.entity().getName());
        }
        return ret;
    }

    public static boolean hasToOneAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(OneToOne.class);
    }

    public static <T extends Annotation> T getOverridableAnnotation(XAnnotatedElement element, Class<T> annotationType, MetadataBuildingContext context) {
        Dialect dialect = context.getMetadataCollector().getDatabase().getDialect();
        Iterator annotations = Arrays.stream(element.getAnnotations()).flatMap(annotation -> {
            try {
                Method value = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
                Class<?> returnType = value.getReturnType();
                if (returnType.isArray() && returnType.getComponentType().isAnnotationPresent(Repeatable.class) && returnType.getComponentType().isAnnotationPresent(DialectOverride.OverridesAnnotation.class)) {
                    return Stream.of((Annotation[])value.invoke(annotation, new Object[0]));
                }
            }
            catch (NoSuchMethodException value) {
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
            return Stream.of(annotation);
        }).iterator();
        while (annotations.hasNext()) {
            Annotation annotation2 = (Annotation)annotations.next();
            Class<? extends Annotation> type = annotation2.annotationType();
            DialectOverride.OverridesAnnotation overridesAnnotation = type.getAnnotation(DialectOverride.OverridesAnnotation.class);
            if (overridesAnnotation == null || !overridesAnnotation.value().equals(annotationType)) continue;
            try {
                Class overrideDialect = (Class)type.getDeclaredMethod("dialect", new Class[0]).invoke((Object)annotation2, new Object[0]);
                if (!overrideDialect.isAssignableFrom(dialect.getClass())) continue;
                DialectOverride.Version before = (DialectOverride.Version)type.getDeclaredMethod("before", new Class[0]).invoke((Object)annotation2, new Object[0]);
                DialectOverride.Version sameOrAfter = (DialectOverride.Version)type.getDeclaredMethod("sameOrAfter", new Class[0]).invoke((Object)annotation2, new Object[0]);
                if (!dialect.getVersion().isBefore(before.major(), before.minor()) || !dialect.getVersion().isSameOrAfter(sameOrAfter.major(), sameOrAfter.minor())) continue;
                return (T)((Annotation)type.getDeclaredMethod("override", new Class[0]).invoke((Object)annotation2, new Object[0]));
            }
            catch (Exception e) {
                throw new AssertionFailure("could not read @DialectOverride annotation", e);
            }
        }
        return (T)element.getAnnotation(annotationType);
    }
}

