/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmNegatedPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmPredicate wrappedPredicate;

    public SqmNegatedPredicate(SqmPredicate wrappedPredicate, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.wrappedPredicate = wrappedPredicate;
    }

    public SqmNegatedPredicate(SqmPredicate wrappedPredicate, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.wrappedPredicate = wrappedPredicate;
    }

    @Override
    public SqmNegatedPredicate copy(SqmCopyContext context) {
        SqmNegatedPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNegatedPredicate predicate = context.registerCopy(this, new SqmNegatedPredicate(this.wrappedPredicate.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmPredicate getWrappedPredicate() {
        return this.wrappedPredicate;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        ArrayList<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>(1);
        expressions.add(this.wrappedPredicate);
        return expressions;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitNegatedPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("not (");
        this.wrappedPredicate.appendHqlString(sb);
        sb.append(')');
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmNegatedPredicate(this, (NodeBuilder)this.nodeBuilder());
    }
}

