/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBigDecimalFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchNumericFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBigDecimalIndexFieldTypeOptionsStep
extends AbstractElasticsearchNumericFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal>
implements ScaledNumberIndexFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    ElasticsearchBigDecimalIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigDecimal.class, "scaled_float");
        this.defaultsProvider = defaultsProvider;
    }

    public ElasticsearchBigDecimalIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this.thisAsS();
    }

    @Override
    protected ElasticsearchFieldCodec<BigDecimal> completeCodec() {
        int resolvedDecimalScale = this.resolveDecimalScale();
        ElasticsearchBigDecimalFieldCodec codec = new ElasticsearchBigDecimalFieldCodec(resolvedDecimalScale);
        this.builder.mapping().setScalingFactor(codec.scalingFactor().doubleValue());
        return codec;
    }

    @Override
    protected ElasticsearchBigDecimalIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.decimalScale() != null) {
            return this.defaultsProvider.decimalScale();
        }
        throw log.nullDecimalScale(this.buildContext.getEventContext());
    }
}

