/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.junit.Test;

public class BrokerDefinedMulticastConsumerTest
extends AmqpClientTestSupport {
    SimpleString address = new SimpleString("testAddress");
    SimpleString queue1 = new SimpleString("queue1");
    SimpleString queue2 = new SimpleString("queue2");

    @Test(timeout=60000L)
    public void testConsumeFromSingleQueueOnAddressSameName() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.MULTICAST));
        this.server.createQueue(new QueueConfiguration(this.address));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString() + "::" + this.address.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        BrokerDefinedMulticastConsumerTest.assertNotNull((Object)amqpMessage);
        BrokerDefinedMulticastConsumerTest.assertEquals((long)1L, (long)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testConsumeWhenOnlyAnycast() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Source jmsSource = this.createJmsSource(true);
        jmsSource.setAddress(this.address.toString());
        try {
            session.createReceiver(jmsSource);
            BrokerDefinedMulticastConsumerTest.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testConsumeWhenNoAddressHasBothRoutingTypesButDefaultQueueIsAnyCast() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        addressInfo.getRoutingTypes().add(RoutingType.ANYCAST);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration(this.address));
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.address.toString());
            BrokerDefinedMulticastConsumerTest.fail((String)"expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    protected Source createJmsSource(boolean topic) {
        Source source = new Source();
        if (!topic) {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.QUEUE_CAPABILITY});
        } else {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        }
        return source;
    }
}

