/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.Test;

public class MultipleThreadsOpeningTest
extends JMSClusteredTestBase {
    @Test
    public void testRepetitions() throws Exception {
        int ITERATIONS = 50;
        for (int i = 0; i < 50; ++i) {
            this.instanceLog.info((Object)("#test " + i));
            this.internalMultipleOpen(200, 1);
            this.tearDown();
            this.setUp();
        }
    }

    @Test
    public void testMultipleOpen() throws Exception {
        this.internalMultipleOpen(20, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalMultipleOpen(int numberOfThreads, final int numberOfOpens) throws Exception {
        this.cf1 = ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), this.generateInVMParams(1))});
        final CountDownLatch flagAlignSemaphore = new CountDownLatch(numberOfThreads);
        final CountDownLatch flagStartRace = new CountDownLatch(1);
        class ThreadOpen
        extends Thread {
            int errors;

            ThreadOpen(int i) {
                super("MultipleThreadsOpeningTest/ThreadOpen::" + i);
                this.errors = 0;
            }

            @Override
            public void run() {
                try {
                    flagAlignSemaphore.countDown();
                    flagStartRace.await();
                    for (int i = 0; i < numberOfOpens; ++i) {
                        if (i > 0 && i % 100 == 0) {
                            MultipleThreadsOpeningTest.this.instanceLog.debug((Object)("connections created on Thread " + Thread.currentThread() + " " + i));
                        }
                        Connection conn = MultipleThreadsOpeningTest.this.cf1.createConnection();
                        Session sess = conn.createSession(true, 1);
                        sess.close();
                        conn.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.errors;
                }
            }
        }
        ThreadOpen[] threads = new ThreadOpen[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new ThreadOpen(i);
            threads[i].start();
        }
        flagAlignSemaphore.await();
        flagStartRace.countDown();
        try {
            for (ThreadOpen t : threads) {
                t.join(60000L);
                MultipleThreadsOpeningTest.assertFalse((boolean)t.isAlive());
                MultipleThreadsOpeningTest.assertEquals((String)"There are Errors on the test thread", (long)0L, (long)t.errors);
            }
        }
        finally {
            for (ThreadOpen t : threads) {
                if (t.isAlive()) {
                    t.interrupt();
                }
                t.join(1000L);
            }
        }
    }
}

