/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.tests.integration.management.AddressControlTest;
import org.apache.activemq.artemis.tests.integration.management.CoreMessagingProxy;

public class AddressControlUsingCoreTest
extends AddressControlTest {
    @Override
    protected AddressControl createManagementControl(final SimpleString name) throws Exception {
        return new AddressControl(){
            private final CoreMessagingProxy proxy;
            {
                this.proxy = new CoreMessagingProxy(AddressControlUsingCoreTest.this.addServerLocator(AddressControlUsingCoreTest.this.createInVMNonHALocator()), "address." + name);
            }

            public String getAddress() {
                return (String)this.proxy.retrieveAttributeValue("address");
            }

            public String[] getRoutingTypes() {
                return (String[])this.proxy.retrieveAttributeValue("routingTypes", String.class);
            }

            public String getRoutingTypesAsJSON() throws Exception {
                return (String)this.proxy.retrieveAttributeValue("routingTypesAsJSON");
            }

            public Object[] getRoles() throws Exception {
                return (Object[])this.proxy.retrieveAttributeValue("roles");
            }

            public String getRolesAsJSON() throws Exception {
                return (String)this.proxy.retrieveAttributeValue("rolesAsJSON");
            }

            public long getAddressSize() {
                return (Long)this.proxy.retrieveAttributeValue("addressSize");
            }

            public long getNumberOfMessages() throws Exception {
                return (Long)this.proxy.retrieveAttributeValue("numberOfMessages");
            }

            public String[] getRemoteQueueNames() throws Exception {
                return (String[])this.proxy.retrieveAttributeValue("remoteQueueNames", String.class);
            }

            public String[] getAllQueueNames() throws Exception {
                return (String[])this.proxy.retrieveAttributeValue("allQueueNames", String.class);
            }

            public String[] getQueueNames() throws Exception {
                return (String[])this.proxy.retrieveAttributeValue("queueNames", String.class);
            }

            public int getNumberOfPages() {
                return (Integer)this.proxy.retrieveAttributeValue("numberOfPages", Integer.class);
            }

            public boolean isPaging() throws Exception {
                return (Boolean)this.proxy.retrieveAttributeValue("paging");
            }

            public long getNumberOfBytesPerPage() throws Exception {
                return (Long)this.proxy.retrieveAttributeValue("numberOfBytesPerPage");
            }

            public String[] getBindingNames() throws Exception {
                return (String[])this.proxy.retrieveAttributeValue("bindingNames", String.class);
            }

            public long getMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("messageCount");
            }

            public long getRoutedMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("routedMessageCount");
            }

            public long getUnRoutedMessageCount() {
                return (Long)this.proxy.retrieveAttributeValue("unRoutedMessageCount");
            }

            public void pause() throws Exception {
                this.proxy.invokeOperation("pause", new Object[0]);
            }

            public void pause(boolean persist) throws Exception {
                this.proxy.invokeOperation("pause", persist);
            }

            public void resume() throws Exception {
                this.proxy.invokeOperation("resume", new Object[0]);
            }

            public boolean isPaused() {
                return (Boolean)this.proxy.retrieveAttributeValue("paused");
            }

            public boolean isRetroactiveResource() {
                return (Boolean)this.proxy.retrieveAttributeValue("retroactiveResource");
            }

            public long getCurrentDuplicateIdCacheSize() {
                return (Long)this.proxy.retrieveAttributeValue("currentDuplicateIdCacheSize");
            }

            public boolean clearDuplicateIdCache() throws Exception {
                return (Boolean)this.proxy.invokeOperation("clearDuplicateIdCache", new Object[0]);
            }

            public boolean isAutoCreated() {
                return (Boolean)this.proxy.retrieveAttributeValue("autoCreated");
            }

            public boolean isInternal() {
                return (Boolean)this.proxy.retrieveAttributeValue("internal");
            }

            public boolean isTemporary() {
                return (Boolean)this.proxy.retrieveAttributeValue("temporary");
            }

            public long purge() throws Exception {
                return (Long)this.proxy.invokeOperation("purge", new Object[0]);
            }

            public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password) throws Exception {
                return (String)this.proxy.invokeOperation("sendMessage", headers, type, body, durable, user, password);
            }

            public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password, boolean createMessageId) throws Exception {
                return (String)this.proxy.invokeOperation("sendMessage", headers, type, body, durable, user, password, createMessageId);
            }
        };
    }

    @Override
    public boolean usingCore() {
        return true;
    }
}

