/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSConsumer6Test
extends BasicOpenWireTest {
    public byte destinationType;

    @Parameterized.Parameters(name="destinationType={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({(byte)1}, {(byte)2});
    }

    public JMSConsumer6Test(byte destinationType) {
        this.destinationType = destinationType;
    }

    @Test
    public void testPassMessageListenerIntoCreateConsumer() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.start();
        ActiveMQSession session = (ActiveMQSession)this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination((Session)session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination, new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        JMSConsumer6Test.assertNotNull((Object)consumer);
        this.sendMessages((Session)session, (Destination)destination, 4);
        JMSConsumer6Test.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumer6Test.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void testAckOfExpired() throws Exception {
        TextMessage message;
        int i;
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.setStatsEnabled(true);
        Session sendSession = this.connection.createSession(false, 1);
        MessageProducer producer = sendSession.createProducer((Destination)destination);
        producer.setTimeToLive(1000L);
        int count = 4;
        for (i = 0; i < 4; ++i) {
            message = sendSession.createTextMessage("" + i);
            producer.send((Message)message);
        }
        Thread.sleep(2000L);
        producer.setTimeToLive(0L);
        for (i = 0; i < 4; ++i) {
            message = sendSession.createTextMessage("no expiry" + i);
            producer.send((Message)message);
        }
        ActiveMQMessageConsumer amqConsumer = (ActiveMQMessageConsumer)consumer;
        for (int i2 = 0; i2 < 4; ++i2) {
            TextMessage msg = (TextMessage)amqConsumer.receive();
            JMSConsumer6Test.assertNotNull((Object)msg);
            JMSConsumer6Test.assertTrue((String)("message has \"no expiry\" text: " + msg.getText()), (boolean)msg.getText().contains("no expiry"));
            amqConsumer.acknowledge();
        }
        JMSConsumer6Test.assertEquals((String)"consumer has expiredMessages", (long)4L, (long)amqConsumer.getConsumerStats().getExpiredMessageCount().getCount());
    }
}

