/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.persistence.impl;

import java.io.File;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BatchIDGeneratorUnitTest
extends ActiveMQTestBase {
    @Test
    public void testSequence() throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getTestDir()), 1);
        JournalImpl journal = new JournalImpl(10240, 2, 2, 0, 0, (SequentialFileFactory)factory, "activemq-bindings", "bindings", 1);
        journal.start();
        journal.load(new ArrayList(), new ArrayList(), null);
        BatchingIDGenerator batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
        long id1 = batch.generateID();
        long id2 = batch.generateID();
        Assert.assertTrue((id2 > id1 ? 1 : 0) != 0);
        journal.stop();
        batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
        this.loadIDs((Journal)journal, batch);
        long id3 = batch.generateID();
        Assert.assertEquals((long)1001L, (long)id3);
        long id4 = batch.generateID();
        Assert.assertTrue((id4 > id3 && id4 < 2000L ? 1 : 0) != 0);
        batch.persistCurrentID();
        journal.stop();
        batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
        this.loadIDs((Journal)journal, batch);
        long id5 = batch.generateID();
        Assert.assertTrue((id5 > id4 && id5 < 2000L ? 1 : 0) != 0);
        long lastId = id5;
        boolean close = true;
        for (int i = 0; i < 100000; ++i) {
            long id;
            if (i % 1000 == 0) {
                if (close) {
                    batch.persistCurrentID();
                }
                close = !close;
                journal.stop();
                batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
                this.loadIDs((Journal)journal, batch);
            }
            Assert.assertTrue(((id = batch.generateID()) > lastId ? 1 : 0) != 0);
            lastId = id;
        }
        batch.persistCurrentID();
        journal.stop();
        batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
        this.loadIDs((Journal)journal, batch);
        lastId = batch.getCurrentID();
        journal.stop();
        batch = new BatchingIDGenerator(0L, 1000L, this.getJournalStorageManager((Journal)journal));
        this.loadIDs((Journal)journal, batch);
        Assert.assertEquals((String)"No Ids were generated, so the currentID was supposed to stay the same", (long)lastId, (long)batch.getCurrentID());
        journal.stop();
    }

    protected void loadIDs(Journal journal, BatchingIDGenerator batch) throws Exception {
        ArrayList records = new ArrayList();
        ArrayList tx = new ArrayList();
        journal.start();
        journal.load(records, tx, null);
        Assert.assertEquals((long)0L, (long)tx.size());
        Assert.assertTrue((String)("Contains " + records.size()), (records.size() > 0 ? 1 : 0) != 0);
        for (RecordInfo record : records) {
            if (record.userRecordType != 24) continue;
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])record.data);
            batch.loadState(record.id, buffer);
        }
    }

    private StorageManager getJournalStorageManager(final Journal bindingsJournal) {
        NullStorageManager storageManager = new NullStorageManager(){

            public synchronized void storeID(long journalID, long id) throws Exception {
                bindingsJournal.appendAddRecord(journalID, (byte)24, BatchingIDGenerator.createIDEncodingSupport((long)id), true);
            }
        };
        try {
            storageManager.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return storageManager;
    }
}

