/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge.impl;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionRolledbackException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.bridge.ActiveMQJMSBridgeLogger;
import org.apache.activemq.artemis.jms.bridge.ConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.DestinationFactory;
import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.apache.activemq.artemis.jms.bridge.JMSBridgeControl;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.apache.activemq.artemis.jms.bridge.impl.JMSBridgeControlImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerBundle;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQRegistry;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public final class JMSBridgeImpl
implements JMSBridge {
    private static final String[] RESOURCE_RECOVERY_CLASS_NAMES = new String[]{"org.jboss.as.messaging.jms.AS7RecoveryRegistry"};
    private static final int TEN_YEARS = 315360000;
    private static final long DEFAULT_FAILOVER_TIMEOUT = 60000L;
    private final Object lock = new Object();
    private String bridgeName = "N/A";
    private String sourceUsername;
    private String sourcePassword;
    private String targetUsername;
    private String targetPassword;
    private TransactionManager tm;
    private String selector;
    private long failureRetryInterval;
    private int maxRetries;
    private QualityOfServiceMode qualityOfServiceMode;
    private int maxBatchSize;
    private long maxBatchTime;
    private String subName;
    private String clientID;
    private volatile boolean addMessageIDInHeader;
    private boolean started;
    private static final Object stoppingGuard = new Object();
    private volatile boolean stopping = false;
    private final LinkedList<Message> messages = new LinkedList();
    private ConnectionFactoryFactory sourceCff;
    private ConnectionFactoryFactory targetCff;
    private DestinationFactory sourceDestinationFactory;
    private DestinationFactory targetDestinationFactory;
    private Connection sourceConn;
    private Connection targetConn;
    private Destination sourceDestination;
    private Destination targetDestination;
    private Session sourceSession;
    private Session targetSession;
    private MessageConsumer sourceConsumer;
    private MessageProducer targetProducer;
    private CountDownLatch batchTimeCheckerFinished;
    private Future<?> batchTimeCheckerTask;
    private CountDownLatch sourceReceiverFinished;
    private Future<?> sourceReceiverTask;
    private ExecutorService executor = this.createExecutor();
    private long batchExpiryTime;
    private boolean paused;
    private Transaction tx;
    private boolean failed;
    private boolean connectedSource = false;
    private boolean connectedTarget = false;
    private int forwardMode;
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private Boolean useMaskedPassword;
    private String passwordCodec;
    private long failoverTimeout;
    private static final int FORWARD_MODE_XA = 0;
    private static final int FORWARD_MODE_LOCALTX = 1;
    private static final int FORWARD_MODE_NONTX = 2;
    private ActiveMQRegistry registry;
    private ClassLoader moduleTccl;
    private long messageCount = 0L;
    private long abortedMessageCount = 0L;

    public JMSBridgeImpl() {
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader) {
        this(sourceCff, targetCff, sourceDestinationFactory, targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader, null, null);
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader, MBeanServer mbeanServer, String objectName) {
        this(sourceCff, targetCff, sourceDestinationFactory, targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader, mbeanServer, objectName, 60000L);
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader, MBeanServer mbeanServer, String objectName, long failoverTimeout) {
        this();
        this.sourceCff = sourceCff;
        this.targetCff = targetCff;
        this.sourceDestinationFactory = sourceDestinationFactory;
        this.targetDestinationFactory = targetDestinationFactory;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.targetUsername = targetUsername;
        this.targetPassword = targetPassword;
        this.selector = selector;
        this.failureRetryInterval = failureRetryInterval;
        this.maxRetries = maxRetries;
        this.qualityOfServiceMode = qosMode;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.subName = subName;
        this.clientID = clientID;
        this.addMessageIDInHeader = addMessageIDInHeader;
        this.failoverTimeout = failoverTimeout;
        this.checkParams();
        if (mbeanServer != null) {
            if (objectName != null) {
                this.mbeanServer = mbeanServer;
                try {
                    JMSBridgeControlImpl controlBean = new JMSBridgeControlImpl(this);
                    this.objectName = ObjectName.getInstance(objectName);
                    StandardMBean mbean = new StandardMBean(controlBean, JMSBridgeControl.class);
                    mbeanServer.registerMBean(mbean, this.objectName);
                    ActiveMQJMSBridgeLogger.LOGGER.debug("Registered JMSBridge instance as: " + this.objectName.getCanonicalName());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register JMSBridge MBean", e);
                }
            } else {
                throw new IllegalArgumentException("objectName is required when specifying an MBeanServer");
            }
        }
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Created " + this);
        }
    }

    @Override
    public JMSBridgeImpl setBridgeName(String name) {
        this.bridgeName = name;
        return this;
    }

    @Override
    public String getBridgeName() {
        return this.bridgeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        boolean ok;
        Object object = stoppingGuard;
        synchronized (object) {
            this.stopping = false;
        }
        this.moduleTccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.locateRecoveryRegistry();
        if (this.started) {
            ActiveMQJMSBridgeLogger.LOGGER.errorBridgeAlreadyStarted(this.bridgeName);
            return;
        }
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Starting " + this);
        }
        if (this.executor.isShutdown()) {
            this.executor = this.createExecutor();
        }
        this.initPasswords();
        this.checkParams();
        if (this.qualityOfServiceMode.equals((Object)QualityOfServiceMode.ONCE_AND_ONLY_ONCE) && this.sourceCff != this.targetCff) {
            if (this.tm == null) {
                this.tm = ServiceUtils.getTransactionManager();
            }
            if (this.tm == null) {
                ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeTransactionManagerMissing(this.qualityOfServiceMode, this.bridgeName);
                throw new RuntimeException();
            }
            Transaction toResume = null;
            try {
                toResume = this.tm.suspend();
                ok = this.setupJMSObjects();
            }
            finally {
                if (toResume != null) {
                    this.tm.resume(toResume);
                }
            }
        } else {
            ok = this.setupJMSObjects();
        }
        if (ok) {
            this.connectedSource = true;
            this.connectedTarget = true;
            this.startSource();
        } else {
            ActiveMQJMSBridgeLogger.LOGGER.errorStartingBridge(this.bridgeName);
            this.handleFailureOnStartup();
        }
    }

    private void startSource() throws JMSException {
        this.sourceConn.start();
        this.started = true;
        if (this.maxBatchTime != -1L) {
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Starting time checker thread");
            }
            this.batchExpiryTime = System.currentTimeMillis() + this.maxBatchTime;
            this.batchTimeCheckerFinished = new CountDownLatch(1);
            this.batchTimeCheckerTask = this.executor.submit(new BatchTimeChecker());
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Started time checker thread");
            }
        } else {
            this.batchTimeCheckerFinished = null;
            this.batchTimeCheckerTask = null;
        }
        this.sourceReceiverFinished = new CountDownLatch(1);
        this.sourceReceiverTask = this.executor.submit(new SourceReceiver());
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Started " + this);
        }
    }

    private void initPasswords() throws ActiveMQException {
        try {
            if (this.sourcePassword != null) {
                this.sourcePassword = PasswordMaskingUtil.resolveMask((Boolean)this.useMaskedPassword, (String)this.sourcePassword, (String)this.passwordCodec);
            }
            if (this.targetPassword != null) {
                this.targetPassword = PasswordMaskingUtil.resolveMask((Boolean)this.useMaskedPassword, (String)this.targetPassword, (String)this.passwordCodec);
            }
        }
        catch (Exception e) {
            throw ActiveMQJMSServerBundle.BUNDLE.errorDecodingPassword(e);
        }
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    private boolean awaitTaskCompletion(CountDownLatch finished, long time, TimeUnit timeUnit, String taskName) {
        try {
            boolean taskCompleted = finished.await(time, timeUnit);
            if (!taskCompleted) {
                ActiveMQJMSBridgeLogger.LOGGER.tracef("%s task on bridge %s wasn't able to finish", taskName, this.bridgeName);
            }
            return taskCompleted;
        }
        catch (InterruptedException ie) {
            ActiveMQJMSBridgeLogger.LOGGER.tracef("An interruption has happened on bridge %s while waiting %s task to finish", this.bridgeName, taskName);
            return false;
        }
    }

    private boolean awaitAll(long time, TimeUnit timeUnit, Pair<String, CountDownLatch> ... namedTaskCompletions) {
        long remainingNanos = timeUnit.toNanos(time);
        boolean allFinished = true;
        for (Pair<String, CountDownLatch> namedTaskCompletion : namedTaskCompletions) {
            CountDownLatch taskCompletion = (CountDownLatch)namedTaskCompletion.getB();
            if (taskCompletion == null) continue;
            String taskName = (String)namedTaskCompletion.getA();
            long start = System.nanoTime();
            boolean taskCompleted = this.awaitTaskCompletion(taskCompletion, remainingNanos, TimeUnit.NANOSECONDS, taskName);
            long elapsed = System.nanoTime() - start;
            if (!taskCompleted) {
                allFinished = false;
            }
            remainingNanos = Math.max(0L, remainingNanos - elapsed);
        }
        return allFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean isFailureHandler) throws Exception {
        Object object = stoppingGuard;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        object = this;
        synchronized (object) {
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Stopping " + this);
            }
            Connection sourceConn = this.sourceConn;
            if (!this.connectedSource && sourceConn != null) {
                try {
                    sourceConn.close();
                }
                catch (Throwable t) {
                    ActiveMQJMSBridgeLogger.LOGGER.tracef("Failed to close source connection on bridge %s", t);
                }
                finally {
                    sourceConn = null;
                }
            }
            Connection targetConn = this.targetConn;
            if (!this.connectedTarget && targetConn != null) {
                try {
                    targetConn.close();
                }
                catch (Throwable t) {
                    ActiveMQJMSBridgeLogger.LOGGER.tracef("Failed to close target connection on bridge %s", t);
                }
                finally {
                    targetConn = null;
                }
            }
            CountDownLatch sourceReceiverFinished = this.sourceReceiverFinished;
            Future<?> sourceReceiverTask = this.sourceReceiverTask;
            CountDownLatch batchTimeCheckerFinished = this.batchTimeCheckerFinished;
            Future<?> batchTimeCheckerTask = this.batchTimeCheckerTask;
            this.sourceReceiverFinished = null;
            this.sourceReceiverTask = null;
            this.batchTimeCheckerFinished = null;
            this.batchTimeCheckerTask = null;
            Object object2 = this.lock;
            synchronized (object2) {
                this.started = false;
                if (!isFailureHandler) {
                    this.executor.shutdownNow();
                } else {
                    if (sourceReceiverTask != null) {
                        sourceReceiverTask.cancel(true);
                    }
                    if (batchTimeCheckerTask != null) {
                        batchTimeCheckerTask.cancel(true);
                    }
                }
            }
            boolean ok = !isFailureHandler ? this.executor.awaitTermination(60L, TimeUnit.SECONDS) : this.awaitAll(60L, TimeUnit.SECONDS, new Pair((Object)"SourceReceiver", (Object)sourceReceiverFinished), new Pair((Object)"BatchTimeChecker", (Object)batchTimeCheckerFinished));
            try {
                if (!ok) {
                    throw new Exception("the bridge hasn't cleanly stopped: transactions, connections or messages could have leaked!");
                }
                if (this.tx != null) {
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Rolling back remaining tx");
                    }
                    try {
                        block49: {
                            this.stopSessionFailover();
                            try {
                                this.tx.rollback();
                                this.abortedMessageCount += (long)this.messages.size();
                            }
                            catch (Exception ignore) {
                                if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block49;
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to rollback", ignore);
                            }
                        }
                        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace("Rolled back remaining tx");
                        }
                    }
                    catch (Throwable t) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failed stopSessionFailover", t);
                    }
                }
                if (sourceConn != null) {
                    try {
                        sourceConn.close();
                    }
                    catch (Exception ignore) {
                        ActiveMQJMSBridgeLogger.LOGGER.tracef("Failed to close source connection on bridge %s", ignore);
                    }
                }
                if (targetConn != null) {
                    try {
                        targetConn.close();
                    }
                    catch (Exception ignore) {
                        ActiveMQJMSBridgeLogger.LOGGER.tracef("Failed to close target connection on bridge %s", ignore);
                    }
                }
                if (this.messages.size() > 0) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Clearing up messages before stopping...");
                    this.messages.clear();
                }
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Stopped " + this);
                }
            }
            finally {
                if (isFailureHandler) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    private static void releaseCommunications(Session session, String sessionName) {
        XASession xaSession = (XASession)session;
        if (xaSession.getXAResource() instanceof ClientSessionInternal) {
            try {
                ((ClientSessionInternal)xaSession.getXAResource()).getSessionContext().releaseCommunications();
            }
            catch (Throwable t) {
                ActiveMQJMSBridgeLogger.LOGGER.warnf(t, "Cannot release communications on %s", sessionName);
            }
        } else if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.tracef("Cannot cast XAResource of %s to ClientSessionInternal and release communications: found class %s", sessionName, xaSession.getClass().getCanonicalName());
        }
    }

    private void stopSessionFailover() {
        try {
            JMSBridgeImpl.releaseCommunications(this.sourceSession, "sourceSession");
        }
        catch (Throwable t) {
            ActiveMQJMSBridgeLogger.LOGGER.error("cannot release communications on sourceSession ", t);
        }
        try {
            JMSBridgeImpl.releaseCommunications(this.targetSession, "targetSession");
        }
        catch (Throwable t) {
            ActiveMQJMSBridgeLogger.LOGGER.error("cannot release communications on targetSession ", t);
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void destroy() {
        if (this.mbeanServer != null && this.objectName != null) {
            try {
                this.mbeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                ActiveMQJMSBridgeLogger.LOGGER.errorUnregisteringBridge(this.objectName, this.bridgeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pause() throws Exception {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Pausing " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.sourceConn.stop();
        }
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Paused " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resume() throws Exception {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Resuming " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.sourceConn.start();
        }
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Resumed " + this);
        }
    }

    @Override
    public DestinationFactory getSourceDestinationFactory() {
        return this.sourceDestinationFactory;
    }

    @Override
    public void setSourceDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.sourceDestinationFactory = dest;
    }

    @Override
    public DestinationFactory getTargetDestinationFactory() {
        return this.targetDestinationFactory;
    }

    @Override
    public void setTargetDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.targetDestinationFactory = dest;
    }

    @Override
    public synchronized String getSourceUsername() {
        return this.sourceUsername;
    }

    @Override
    public synchronized void setSourceUsername(String name) {
        this.checkBridgeNotStarted();
        this.sourceUsername = name;
    }

    @Override
    public synchronized String getSourcePassword() {
        return this.sourcePassword;
    }

    @Override
    public synchronized void setSourcePassword(String pwd) {
        this.checkBridgeNotStarted();
        this.sourcePassword = pwd;
    }

    @Override
    public synchronized String getTargetUsername() {
        return this.targetUsername;
    }

    @Override
    public synchronized void setTargetUsername(String name) {
        this.checkBridgeNotStarted();
        this.targetUsername = name;
    }

    @Override
    public synchronized String getTargetPassword() {
        return this.targetPassword;
    }

    @Override
    public synchronized void setTargetPassword(String pwd) {
        this.checkBridgeNotStarted();
        this.targetPassword = pwd;
    }

    @Override
    public synchronized String getSelector() {
        return this.selector;
    }

    @Override
    public synchronized void setSelector(String selector) {
        this.checkBridgeNotStarted();
        this.selector = selector;
    }

    @Override
    public synchronized long getFailureRetryInterval() {
        return this.failureRetryInterval;
    }

    @Override
    public synchronized void setFailureRetryInterval(long interval) {
        this.checkBridgeNotStarted();
        if (interval < 1L) {
            throw new IllegalArgumentException("FailureRetryInterval must be >= 1");
        }
        this.failureRetryInterval = interval;
    }

    @Override
    public synchronized int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public synchronized void setMaxRetries(int retries) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(retries, "MaxRetries");
        this.maxRetries = retries;
    }

    @Override
    public synchronized QualityOfServiceMode getQualityOfServiceMode() {
        return this.qualityOfServiceMode;
    }

    @Override
    public synchronized void setQualityOfServiceMode(QualityOfServiceMode mode) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull((Object)mode, "QualityOfServiceMode");
        this.qualityOfServiceMode = mode;
    }

    @Override
    public synchronized int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public synchronized void setMaxBatchSize(int size) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkMaxBatchSize(size);
        this.maxBatchSize = size;
    }

    @Override
    public synchronized long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    @Override
    public synchronized void setMaxBatchTime(long time) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(time, "MaxBatchTime");
        this.maxBatchTime = time;
    }

    @Override
    public synchronized String getSubscriptionName() {
        return this.subName;
    }

    @Override
    public synchronized void setSubscriptionName(String subname) {
        this.checkBridgeNotStarted();
        this.subName = subname;
    }

    @Override
    public synchronized String getClientID() {
        return this.clientID;
    }

    @Override
    public synchronized void setClientID(String clientID) {
        this.checkBridgeNotStarted();
        this.clientID = clientID;
    }

    @Override
    public boolean isAddMessageIDInHeader() {
        return this.addMessageIDInHeader;
    }

    @Override
    public void setAddMessageIDInHeader(boolean value) {
        this.addMessageIDInHeader = value;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.failed;
    }

    @Override
    public synchronized long getMessageCount() {
        return this.messageCount;
    }

    @Override
    public synchronized long getAbortedMessageCount() {
        return this.abortedMessageCount;
    }

    @Override
    public synchronized void setSourceConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "SourceConnectionFactoryFactory");
        this.sourceCff = cff;
    }

    @Override
    public synchronized void setTargetConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "TargetConnectionFactoryFactory");
        this.targetCff = cff;
    }

    @Override
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    private synchronized void checkParams() {
        JMSBridgeImpl.checkNotNull(this.sourceCff, "sourceCff");
        JMSBridgeImpl.checkNotNull(this.targetCff, "targetCff");
        JMSBridgeImpl.checkNotNull(this.sourceDestinationFactory, "sourceDestinationFactory");
        JMSBridgeImpl.checkNotNull(this.targetDestinationFactory, "targetDestinationFactory");
        JMSBridgeImpl.checkValidValue(this.failureRetryInterval, "failureRetryInterval");
        JMSBridgeImpl.checkValidValue(this.maxRetries, "maxRetries");
        if (this.failureRetryInterval == -1L && this.maxRetries > 0) {
            throw new IllegalArgumentException("If failureRetryInterval == -1 maxRetries must be set to -1");
        }
        JMSBridgeImpl.checkMaxBatchSize(this.maxBatchSize);
        JMSBridgeImpl.checkValidValue(this.maxBatchTime, "maxBatchTime");
        JMSBridgeImpl.checkNotNull((Object)this.qualityOfServiceMode, "qualityOfServiceMode");
    }

    private static void checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private void checkBridgeNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Cannot set bridge attributes while it is started");
        }
    }

    private static void checkValidValue(long value, String name) {
        if (value != -1L && value <= 0L) {
            throw new IllegalArgumentException(name + " must be > 0 or -1");
        }
    }

    private static void checkMaxBatchSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("maxBatchSize must be >= 1");
        }
    }

    private void enlistResources(Transaction tx) throws Exception {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Enlisting resources in tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.enlistResource(resSource);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.enlistResource(resDest);
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Enlisted resources in tx");
        }
    }

    private void delistResources(Transaction tx) {
        block7: {
            block6: {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Delisting resources from tx");
                }
                XAResource resSource = ((XASession)this.sourceSession).getXAResource();
                try {
                    tx.delistResource(resSource, 0x4000000);
                }
                catch (Exception e) {
                    if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block6;
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist source resource", e);
                }
            }
            XAResource resDest = ((XASession)this.targetSession).getXAResource();
            try {
                tx.delistResource(resDest, 0x4000000);
            }
            catch (Exception e) {
                if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block7;
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist target resource", e);
            }
        }
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Delisted resources from tx");
        }
    }

    private Transaction startTx() throws Exception {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Starting JTA transaction");
        }
        if (this.tm == null) {
            this.tm = ServiceUtils.getTransactionManager();
        }
        this.tm.setTransactionTimeout(315360000);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.tm.suspend();
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Started JTA transaction");
        }
        return tx;
    }

    private Connection createConnection(String username, String password, ConnectionFactoryFactory cff, String clientID, boolean isXA, boolean isSource) throws Exception {
        XAConnection conn = null;
        try {
            ActiveMQConnectionFactory activeMQCF;
            Object cf = cff.createConnectionFactory();
            if (cf instanceof ActiveMQConnectionFactory && this.registry != null) {
                this.registry.register(XARecoveryConfig.newConfig((ActiveMQConnectionFactory)((ActiveMQConnectionFactory)cf), (String)username, (String)password, null));
            }
            if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE && !(cf instanceof XAConnectionFactory)) {
                throw new IllegalArgumentException("Connection factory must be XAConnectionFactory");
            }
            if (username == null) {
                if (isXA) {
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Creating an XA connection");
                    }
                    conn = ((XAConnectionFactory)cf).createXAConnection();
                } else {
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Creating a non XA connection");
                    }
                    conn = ((ConnectionFactory)cf).createConnection();
                }
            } else if (isXA) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating an XA connection");
                }
                conn = ((XAConnectionFactory)cf).createXAConnection(username, password);
            } else {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating a non XA connection");
                }
                conn = ((ConnectionFactory)cf).createConnection(username, password);
            }
            if (clientID != null) {
                conn.setClientID(clientID);
            }
            boolean ha = false;
            BridgeFailoverListener failoverListener = null;
            if (conn instanceof ActiveMQConnection && (ha = (activeMQCF = (ActiveMQConnectionFactory)cf).isHA())) {
                ActiveMQConnection activeMQConn = (ActiveMQConnection)conn;
                failoverListener = new BridgeFailoverListener(isSource);
                activeMQConn.setFailoverListener((FailoverEventListener)failoverListener);
            }
            conn.setExceptionListener((ExceptionListener)new BridgeExceptionListener(ha, failoverListener, isSource));
            return conn;
        }
        catch (JMSException e) {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    private boolean setupJMSObjects() {
        try {
            this.forwardMode = this.sourceCff == this.targetCff ? 1 : (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE ? 0 : 2);
            this.sourceDestination = this.sourceDestinationFactory.createDestination();
            this.targetDestination = this.targetDestinationFactory.createDestination();
            if (this.forwardMode == 1) {
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, false, true);
                this.sourceSession = this.sourceConn.createSession(true, 0);
            } else if (this.forwardMode == 0) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating XA source session");
                }
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, true, true);
                this.sourceSession = ((XAConnection)this.sourceConn).createXASession();
            } else {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating non XA source session");
                }
                this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff, this.clientID, false, true);
                this.sourceSession = this.qualityOfServiceMode == QualityOfServiceMode.AT_MOST_ONCE && this.maxBatchSize == 1 ? this.sourceConn.createSession(false, 1) : this.sourceConn.createSession(false, 2);
            }
            this.sourceConsumer = this.subName == null ? (this.selector == null ? this.sourceSession.createConsumer(this.sourceDestination) : this.sourceSession.createConsumer(this.sourceDestination, this.selector, false)) : (this.selector == null ? this.sourceSession.createDurableSubscriber((Topic)this.sourceDestination, this.subName) : this.sourceSession.createDurableSubscriber((Topic)this.sourceDestination, this.subName, this.selector, false));
            if (this.forwardMode == 1) {
                this.targetConn = this.sourceConn;
                this.targetSession = this.sourceSession;
            } else if (this.forwardMode == 0) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating XA dest session");
                }
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff, null, true, false);
                this.targetSession = ((XAConnection)this.targetConn).createXASession();
            } else {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Creating non XA dest session");
                }
                boolean transacted = this.maxBatchSize > 1;
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff, null, false, false);
                this.targetSession = this.targetConn.createSession(transacted, transacted ? 0 : 1);
            }
            if (this.forwardMode == 0) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Starting JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.targetProducer = this.targetSession.createProducer(null);
            return true;
        }
        catch (Exception e) {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeConnectError(e, this.bridgeName);
            this.cleanup();
            return false;
        }
    }

    private void cleanup() {
        block18: {
            block17: {
                block16: {
                    block14: {
                        if (this.sourceConn != null) {
                            try {
                                this.sourceConn.stop();
                            }
                            catch (Throwable ignore) {
                                if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block14;
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to stop source connection", ignore);
                            }
                        }
                    }
                    if (this.tx != null) {
                        block15: {
                            try {
                                this.delistResources(this.tx);
                            }
                            catch (Throwable ignore) {
                                if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block15;
                                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to delist resources", ignore);
                            }
                        }
                        try {
                            this.tx.rollback();
                            this.abortedMessageCount += (long)this.messages.size();
                        }
                        catch (Throwable ignore) {
                            if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block16;
                            ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to rollback", ignore);
                        }
                    }
                }
                if (this.sourceConn != null) {
                    try {
                        this.sourceConn.close();
                    }
                    catch (Throwable ignore) {
                        if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block17;
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close source connection", ignore);
                    }
                }
            }
            try {
                if (this.targetConn != null) {
                    this.targetConn.close();
                }
            }
            catch (Throwable ignore) {
                if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block18;
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failed to close target connection", ignore);
            }
        }
    }

    private static boolean pause(long millis) {
        assert (millis >= 0L);
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    private boolean setupJMSObjectsWithRetry() {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Setting up connections");
        }
        int count = 0;
        while (!this.stopping) {
            boolean ok = this.setupJMSObjects();
            if (ok) {
                return true;
            }
            if (this.maxRetries != -1 && ++count == this.maxRetries) break;
            ActiveMQJMSBridgeLogger.LOGGER.failedToSetUpBridge(this.failureRetryInterval, this.bridgeName);
            if (JMSBridgeImpl.pause(this.failureRetryInterval)) continue;
            ActiveMQJMSBridgeLogger.LOGGER.tracef("Interrupted while pausing the bridge %s", this.bridgeName);
            return false;
        }
        return false;
    }

    private void sendBatch() {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Sending batch of " + this.messages.size() + " messages");
        }
        if (this.paused) {
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Paused, so not sending now");
            }
            return;
        }
        if (this.forwardMode == 1) {
            this.sendBatchLocalTx();
        } else if (this.forwardMode == 0) {
            this.sendBatchXA();
        } else {
            this.sendBatchNonTransacted();
        }
    }

    private void sendBatchNonTransacted() {
        try {
            boolean exHappened;
            if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE || this.qualityOfServiceMode == QualityOfServiceMode.AT_MOST_ONCE && this.maxBatchSize > 1) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acked source session");
                }
            }
            do {
                exHappened = false;
                try {
                    this.sendMessages();
                }
                catch (TransactionRolledbackException e) {
                    ActiveMQJMSBridgeLogger.LOGGER.transactionRolledBack((Exception)((Object)e));
                    exHappened = true;
                }
            } while (exHappened);
            if (this.maxBatchSize > 1) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Committing target session");
                }
                this.targetSession.commit();
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Committed target session");
                }
            }
            if (this.qualityOfServiceMode == QualityOfServiceMode.DUPLICATES_OK) {
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace("Client acked source session");
                }
            }
        }
        catch (Exception e) {
            if (!this.stopping) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e, this.bridgeName);
            }
            if (this.connectedSource) {
                try {
                    this.sourceSession.recover();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.messages.clear();
        }
    }

    private void sendBatchXA() {
        try {
            this.sendMessages();
            this.delistResources(this.tx);
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committing JTA transaction");
            }
            this.tx.commit();
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committed JTA transaction");
            }
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
                this.abortedMessageCount += (long)this.messages.size();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e, this.bridgeName);
        }
        finally {
            try {
                this.tx = this.startTx();
                this.enlistResources(this.tx);
                this.messages.clear();
            }
            catch (Exception e) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e, this.bridgeName);
                this.handleFailureOnSend();
            }
        }
    }

    private void sendBatchLocalTx() {
        try {
            this.sendMessages();
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committing source session");
            }
            this.sourceSession.commit();
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Committed source session");
            }
        }
        catch (Exception e) {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeAckError(e, this.bridgeName);
            try {
                this.sourceSession.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.targetSession.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.messages.clear();
        }
    }

    private void sendMessages() throws Exception {
        Iterator iter = this.messages.iterator();
        Message msg = null;
        while (iter.hasNext()) {
            long timeToLive;
            msg = (Message)iter.next();
            if (this.addMessageIDInHeader) {
                this.addMessageIDInHeader(msg);
            }
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Sending message " + msg);
            }
            if ((timeToLive = msg.getJMSExpiration()) != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                timeToLive = 1L;
            }
            this.targetProducer.send(this.targetDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive);
            ++this.messageCount;
            if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) continue;
            ActiveMQJMSBridgeLogger.LOGGER.trace("Sent message " + msg);
        }
    }

    private void handleFailureOnSend() {
        this.handleFailure(new FailureHandler());
    }

    private void handleFailureOnStartup() {
        this.handleFailure(new StartupFailureHandler());
    }

    private void handleFailure(Runnable failureHandler) {
        this.failed = true;
        this.executor.execute(failureHandler);
    }

    private void addMessageIDInHeader(Message msg) throws Exception {
        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
            ActiveMQJMSBridgeLogger.LOGGER.trace("Adding old message id in Message header");
        }
        JMSBridgeImpl.copyProperties(msg);
        String val = null;
        val = msg.getStringProperty("AMQ_BRIDGE_MSG_ID_LIST");
        if (val == null) {
            val = msg.getJMSMessageID();
        } else {
            StringBuffer sb = new StringBuffer(val);
            sb.append(",").append(msg.getJMSMessageID());
            val = sb.toString();
        }
        msg.setStringProperty("AMQ_BRIDGE_MSG_ID_LIST", val);
    }

    private static void copyProperties(Message msg) throws JMSException {
        Enumeration en = msg.getPropertyNames();
        HashMap<String, Object> oldProps = null;
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            if (oldProps == null) {
                oldProps = new HashMap<String, Object>();
            }
            oldProps.put(propName, msg.getObjectProperty(propName));
        }
        msg.clearProperties();
        if (oldProps != null) {
            for (Map.Entry entry : oldProps.entrySet()) {
                String propName = (String)entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof byte[])) {
                    msg.setObjectProperty(propName, entry.getValue());
                    continue;
                }
                if (!(msg instanceof ActiveMQMessage)) continue;
                ((ActiveMQMessage)msg).getCoreMessage().putBytesProperty(propName, (byte[])val);
            }
        }
    }

    private ExecutorService createExecutor() {
        ExecutorService service = Executors.newFixedThreadPool(3, new ThreadFactory(){
            ThreadGroup group = new ThreadGroup("JMSBridgeImpl");

            @Override
            public Thread newThread(Runnable r) {
                final Thread thr = new Thread(this.group, r);
                if (JMSBridgeImpl.this.moduleTccl != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            thr.setContextClassLoader(JMSBridgeImpl.this.moduleTccl);
                            return null;
                        }
                    });
                }
                return thr;
            }
        });
        return service;
    }

    private void locateRecoveryRegistry() {
        if (this.registry == null) {
            for (String locatorClasse : RESOURCE_RECOVERY_CLASS_NAMES) {
                try {
                    ServiceLoader<ActiveMQRegistry> sl = ServiceLoader.load(ActiveMQRegistry.class, JMSBridgeImpl.class.getClassLoader());
                    if (sl.iterator().hasNext()) {
                        this.registry = sl.iterator().next();
                    }
                }
                catch (Throwable e) {
                    ActiveMQJMSBridgeLogger.LOGGER.debug("unable to load  recovery registry " + locatorClasse, e);
                }
                if (this.registry != null) break;
            }
            if (this.registry != null) {
                ActiveMQJMSBridgeLogger.LOGGER.debug("Recovery Registry located = " + this.registry);
            }
        }
    }

    @Override
    public boolean isUseMaskedPassword() {
        return this.useMaskedPassword;
    }

    @Override
    public void setUseMaskedPassword(boolean maskPassword) {
        this.useMaskedPassword = maskPassword;
    }

    @Override
    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    @Override
    public void setPasswordCodec(String passwordCodec) {
        this.passwordCodec = passwordCodec;
    }

    public long getFailoverTimeout() {
        return this.failoverTimeout;
    }

    public void setFailoverTimeout(long failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    private class BridgeFailoverListener
    implements FailoverEventListener {
        private final boolean isSource;
        volatile FailoverEventType lastEvent;

        private BridgeFailoverListener(boolean isSource) {
            this.isSource = isSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failoverEvent(FailoverEventType eventType) {
            BridgeFailoverListener bridgeFailoverListener = this;
            synchronized (bridgeFailoverListener) {
                this.lastEvent = eventType;
                if (eventType == FailoverEventType.FAILURE_DETECTED) {
                    if (this.isSource) {
                        JMSBridgeImpl.this.connectedSource = false;
                    } else {
                        JMSBridgeImpl.this.connectedTarget = false;
                    }
                }
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForFailover() {
            long toWait = JMSBridgeImpl.this.failoverTimeout;
            long start = 0L;
            long waited = 0L;
            boolean timedOut = false;
            FailoverEventType result = null;
            BridgeFailoverListener bridgeFailoverListener = this;
            synchronized (bridgeFailoverListener) {
                while (this.lastEvent == null || this.lastEvent == FailoverEventType.FAILURE_DETECTED) {
                    try {
                        if (toWait <= 0L) {
                            timedOut = true;
                            break;
                        }
                        start = System.currentTimeMillis();
                        this.wait(toWait);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                    finally {
                        waited = System.currentTimeMillis() - start;
                        toWait = JMSBridgeImpl.this.failoverTimeout - waited;
                    }
                }
                result = this.lastEvent;
                this.lastEvent = null;
            }
            if (timedOut) {
                ActiveMQJMSBridgeLogger.LOGGER.debug("Timed out waiting for failover completion " + this);
                return false;
            }
            if (result == FailoverEventType.FAILOVER_COMPLETED) {
                if (this.isSource) {
                    JMSBridgeImpl.this.connectedSource = true;
                } else {
                    JMSBridgeImpl.this.connectedTarget = true;
                }
                return true;
            }
            return false;
        }
    }

    private class BridgeExceptionListener
    implements ExceptionListener {
        boolean ha;
        BridgeFailoverListener failoverListener;
        private final boolean isSource;

        private BridgeExceptionListener(boolean ha, BridgeFailoverListener failoverListener, boolean isSource) {
            this.ha = ha;
            this.failoverListener = failoverListener;
            this.isSource = isSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException e) {
            if (JMSBridgeImpl.this.stopping) {
                return;
            }
            ActiveMQJMSBridgeLogger.LOGGER.bridgeFailure((Exception)e, JMSBridgeImpl.this.bridgeName);
            if (this.isSource) {
                JMSBridgeImpl.this.connectedSource = false;
            } else {
                JMSBridgeImpl.this.connectedTarget = false;
            }
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                if (JMSBridgeImpl.this.stopping) {
                    return;
                }
                if (JMSBridgeImpl.this.failed) {
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace("Failure recovery already in progress");
                    }
                } else {
                    boolean shouldHandleFailure = true;
                    if (this.ha) {
                        boolean bl = shouldHandleFailure = !this.failoverListener.waitForFailover();
                    }
                    if (shouldHandleFailure) {
                        JMSBridgeImpl.this.handleFailure(new FailureHandler());
                    }
                }
            }
        }
    }

    private class BatchTimeChecker
    implements Runnable {
        private BatchTimeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " running");
            }
            CountDownLatch completed = JMSBridgeImpl.this.batchTimeCheckerFinished;
            try {
                Object object = JMSBridgeImpl.this.lock;
                synchronized (object) {
                    while (JMSBridgeImpl.this.started) {
                        long toWait = JMSBridgeImpl.this.batchExpiryTime - System.currentTimeMillis();
                        if (toWait <= 0L) {
                            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " waited enough");
                            }
                            Object object2 = JMSBridgeImpl.this.lock;
                            synchronized (object2) {
                                if (!JMSBridgeImpl.this.failed && !JMSBridgeImpl.this.messages.isEmpty()) {
                                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " got some messages so sending batch");
                                    }
                                    JMSBridgeImpl.this.sendBatch();
                                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " sent batch");
                                    }
                                }
                            }
                            JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                            continue;
                        }
                        try {
                            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " waiting for " + toWait);
                            }
                            JMSBridgeImpl.this.lock.wait(toWait);
                            if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) continue;
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " woke up");
                        }
                        catch (InterruptedException e) {
                            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                                ActiveMQJMSBridgeLogger.LOGGER.trace(this + " thread was interrupted");
                            }
                            if (!JMSBridgeImpl.this.stopping) throw new ActiveMQInterruptedException((Throwable)e);
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 8, 11] lbl34 : MonitorExitStatement: MONITOREXIT : var2_2
                            completed.countDown();
                            return;
                        }
                    }
                    return;
                }
            }
            finally {
                completed.countDown();
            }
        }
    }

    private class StartupFailureHandler
    extends FailureHandler {
        private StartupFailureHandler() {
        }

        @Override
        protected void failed() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeNotStarted(JMSBridgeImpl.this.bridgeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void succeeded() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeConnected(JMSBridgeImpl.this.bridgeName);
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.connectedSource = true;
                JMSBridgeImpl.this.connectedTarget = true;
                JMSBridgeImpl.this.failed = false;
                JMSBridgeImpl.this.started = true;
                try {
                    JMSBridgeImpl.this.startSource();
                }
                catch (JMSException e) {
                    ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeSrcConnectError((Exception)((Object)e), JMSBridgeImpl.this.bridgeName);
                }
            }
        }
    }

    private class FailureHandler
    implements Runnable {
        private FailureHandler() {
        }

        protected void startSourceConnection() {
            try {
                JMSBridgeImpl.this.sourceConn.start();
            }
            catch (JMSException e) {
                ActiveMQJMSBridgeLogger.LOGGER.jmsBridgeSrcConnectError((Exception)((Object)e), JMSBridgeImpl.this.bridgeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void succeeded() {
            ActiveMQJMSBridgeLogger.LOGGER.bridgeReconnected(JMSBridgeImpl.this.bridgeName);
            JMSBridgeImpl.this.connectedSource = true;
            JMSBridgeImpl.this.connectedTarget = true;
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.failed = false;
                this.startSourceConnection();
            }
        }

        protected void failed() {
            ActiveMQJMSBridgeLogger.LOGGER.errorConnectingBridge(JMSBridgeImpl.this.bridgeName);
            try {
                JMSBridgeImpl.this.stop(true);
            }
            catch (Throwable ignore) {
                ActiveMQJMSBridgeLogger.LOGGER.tracef("Failed to stop bridge %s from %s ", JMSBridgeImpl.this.bridgeName, this.getClass().getSimpleName(), ignore);
            }
        }

        @Override
        public void run() {
            if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                ActiveMQJMSBridgeLogger.LOGGER.trace("Failure handler running");
            }
            JMSBridgeImpl.this.messages.clear();
            JMSBridgeImpl.this.cleanup();
            boolean ok = false;
            if (JMSBridgeImpl.this.maxRetries > 0 || JMSBridgeImpl.this.maxRetries == -1) {
                ActiveMQJMSBridgeLogger.LOGGER.bridgeRetry(JMSBridgeImpl.this.failureRetryInterval, JMSBridgeImpl.this.bridgeName);
                if (!JMSBridgeImpl.pause(JMSBridgeImpl.this.failureRetryInterval)) {
                    ActiveMQJMSBridgeLogger.LOGGER.tracef("Interrupted while pausing the bridge %s", JMSBridgeImpl.this.bridgeName);
                    this.failed();
                    return;
                }
                ok = JMSBridgeImpl.this.setupJMSObjectsWithRetry();
            }
            if (!ok) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
    }

    private final class SourceReceiver
    implements Runnable {
        private SourceReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            CountDownLatch finished = JMSBridgeImpl.this.sourceReceiverFinished;
            while (true) {
                Message msg;
                block27: {
                    block26: {
                        while (JMSBridgeImpl.this.started) {
                            if (JMSBridgeImpl.this.stopping) {
                                return;
                            }
                            Object object = JMSBridgeImpl.this.lock;
                            // MONITORENTER : object
                            if (!JMSBridgeImpl.this.paused && !JMSBridgeImpl.this.failed) break block26;
                            try {
                                JMSBridgeImpl.this.lock.wait(500L);
                            }
                            catch (InterruptedException e) {
                                if (!JMSBridgeImpl.this.stopping) throw new ActiveMQInterruptedException((Throwable)e);
                                // MONITOREXIT : object
                                finished.countDown();
                                return;
                            }
                        }
                        return;
                    }
                    msg = null;
                    try {
                        msg = JMSBridgeImpl.this.sourceConsumer.receive(1000L);
                        if (msg instanceof ActiveMQMessage) {
                            ((ActiveMQMessage)msg).checkBuffer();
                        }
                    }
                    catch (JMSException jmse) {
                        if (!ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) break block27;
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " exception while receiving a message", jmse);
                    }
                }
                if (msg == null) {
                    try {
                        JMSBridgeImpl.this.lock.wait(500L);
                    }
                    catch (InterruptedException e) {
                        if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                            ActiveMQJMSBridgeLogger.LOGGER.trace(this + " thread was interrupted");
                        }
                        if (!JMSBridgeImpl.this.stopping) throw new ActiveMQInterruptedException((Throwable)e);
                        // MONITOREXIT : object
                        finished.countDown();
                        return;
                    }
                    continue;
                }
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace(this + " received message " + msg);
                }
                JMSBridgeImpl.this.messages.add(msg);
                JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                    ActiveMQJMSBridgeLogger.LOGGER.trace(this + " rescheduled batchExpiryTime to " + JMSBridgeImpl.this.batchExpiryTime);
                }
                if (JMSBridgeImpl.this.maxBatchSize != -1 && JMSBridgeImpl.this.messages.size() >= JMSBridgeImpl.this.maxBatchSize) {
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " maxBatchSize has been reached so sending batch");
                    }
                    JMSBridgeImpl.this.sendBatch();
                    if (ActiveMQJMSBridgeLogger.LOGGER.isTraceEnabled()) {
                        ActiveMQJMSBridgeLogger.LOGGER.trace(this + " sent batch");
                    }
                }
                // MONITOREXIT : object
            }
            finally {
                finished.countDown();
            }
        }
    }
}

