/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.routing.pools.AbstractPool;
import org.apache.activemq.artemis.core.server.routing.targets.TargetFactory;

public class ClusterPool
extends AbstractPool
implements ClusterTopologyListener {
    private final ClusterConnection clusterConnection;
    private final Map<String, TopologyMember> clusterMembers = new ConcurrentHashMap<String, TopologyMember>();

    public ClusterPool(TargetFactory targetFactory, ScheduledExecutorService scheduledExecutor, int checkPeriod, ClusterConnection clusterConnection) {
        super(targetFactory, scheduledExecutor, checkPeriod);
        this.clusterConnection = clusterConnection;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.clusterConnection.addClusterTopologyListener(this);
    }

    @Override
    public void stop() throws Exception {
        this.clusterConnection.removeClusterTopologyListener(this);
        super.stop();
    }

    public void nodeUP(TopologyMember member, boolean last) {
        if (!this.clusterConnection.getNodeID().equals(member.getNodeId()) && this.clusterMembers.putIfAbsent(member.getNodeId(), member) == null) {
            this.addTarget(member.getLive(), member.getNodeId());
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
        if (this.clusterMembers.remove(nodeID) != null) {
            this.removeTarget(this.getTarget(nodeID));
        }
    }
}

