/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;

abstract class AbstractElasticsearchCompositeProjection<P>
extends AbstractElasticsearchProjection<Object[], P> {
    private final ElasticsearchSearchProjection<?, ?>[] children;

    AbstractElasticsearchCompositeProjection(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchProjection<?, ?> ... children) {
        super(scope);
        this.children = children;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[children=" + Arrays.toString(this.children) + "]";
    }

    @Override
    public final void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        for (ElasticsearchSearchProjection<?, ?> child : this.children) {
            child.request(requestBody, context);
        }
    }

    @Override
    public final Object[] extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        Object[] extractedData = new Object[this.children.length];
        for (int i = 0; i < extractedData.length; ++i) {
            ElasticsearchSearchProjection<?, ?> child = this.children[i];
            extractedData[i] = child.extract(projectionHitMapper, hit, context);
        }
        return extractedData;
    }

    @Override
    public final P transform(LoadingResult<?, ?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        for (int i = 0; i < extractedData.length; ++i) {
            ElasticsearchSearchProjection<?, ?> child = this.children[i];
            Object extractedElement = extractedData[i];
            extractedData[i] = ElasticsearchSearchProjection.transformUnsafe(child, loadingResult, extractedElement, context);
        }
        return this.doTransform(extractedData);
    }

    abstract P doTransform(Object[] var1);

    static class Builder<P>
    implements CompositeProjectionBuilder<P> {
        private final AbstractElasticsearchCompositeProjection<P> projection;

        Builder(AbstractElasticsearchCompositeProjection<P> projection) {
            this.projection = projection;
        }

        public SearchProjection<P> build() {
            return this.projection;
        }
    }
}

