/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

@Incubating
public class PersistentBag<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    protected List<E> bag;
    private Collection<E> providedCollection;

    public PersistentBag() {
    }

    public PersistentBag(SharedSessionContractImplementor session) {
        super(session);
    }

    public PersistentBag(SharedSessionContractImplementor session, Collection<E> coll) {
        super(session);
        this.providedCollection = coll;
        this.bag = coll instanceof List ? (List)coll : new ArrayList<E>(coll);
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.bag == collection;
    }

    @Override
    public boolean isDirectlyProvidedCollection(Object collection) {
        return this.isDirectlyAccessible() && this.providedCollection == collection;
    }

    @Override
    public boolean empty() {
        return this.bag.isEmpty();
    }

    @Override
    public Iterator<E> entries(CollectionPersister persister) {
        return this.bag.iterator();
    }

    @Override
    public void injectLoadedState(PluralAttributeMapping attributeMapping, List<?> loadingState) {
        assert (this.bag == null);
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
        int elementCount = loadingState == null ? 0 : loadingState.size();
        this.bag = (List)collectionSemantics.instantiateRaw(elementCount, collectionDescriptor);
        if (loadingState != null) {
            for (int i = 0; i < elementCount; ++i) {
                this.bag.add(loadingState.get(i));
            }
        }
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        List<Object> instancesSn;
        List<Object> instancesBag;
        Integer hash;
        Type elementType = persister.getElementType();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        Map<Integer, List<Object>> hashToInstancesBag = this.groupByEqualityHash(this.bag, elementType);
        Map<Integer, List<Object>> hashToInstancesSn = this.groupByEqualityHash(sn, elementType);
        if (hashToInstancesBag.size() != hashToInstancesSn.size()) {
            return false;
        }
        for (Map.Entry<Integer, List<Object>> hashToInstancesBagEntry : hashToInstancesBag.entrySet()) {
            hash = hashToInstancesBagEntry.getKey();
            instancesBag = hashToInstancesBagEntry.getValue();
            instancesSn = hashToInstancesSn.get(hash);
            if (instancesSn != null && instancesBag.size() == instancesSn.size()) continue;
            return false;
        }
        for (Map.Entry<Integer, List<Object>> hashToInstancesBagEntry : hashToInstancesBag.entrySet()) {
            hash = hashToInstancesBagEntry.getKey();
            instancesBag = hashToInstancesBagEntry.getValue();
            instancesSn = hashToInstancesSn.get(hash);
            for (Object instance : instancesBag) {
                if (this.expectOccurrences(instance, instancesBag, elementType, this.countOccurrences(instance, instancesSn, elementType))) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Integer, List<Object>> groupByEqualityHash(List<?> searchedBag, Type elementType) {
        if (searchedBag.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>();
        for (Object o : searchedBag) {
            map.computeIfAbsent(this.nullableHashCode(o, elementType), k -> new ArrayList()).add(o);
        }
        return map;
    }

    private Integer nullableHashCode(Object o, Type elementType) {
        if (o == null) {
            return null;
        }
        return elementType.getHashCode(o);
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    private int countOccurrences(Object element, List<Object> list, Type elementType) {
        int result = 0;
        for (Object listElement : list) {
            if (!elementType.isSame(element, listElement)) continue;
            ++result;
        }
        return result;
    }

    private boolean expectOccurrences(Object element, List<Object> list, Type elementType, int expected) {
        int result = 0;
        for (Object listElement : list) {
            if (!elementType.isSame(element, listElement) || result++ <= expected) continue;
            return false;
        }
        return result == expected;
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.bag.size());
        for (E item : this.bag) {
            clonedList.add(persister.getElementType().deepCopy(item, persister.getFactory()));
        }
        return clonedList;
    }

    @Override
    public Collection<E> getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentBag.getOrphans(sn, this.bag, entityName, this.getSession());
    }

    @Override
    public void initializeEmptyCollection(CollectionPersister persister) {
        assert (this.bag == null);
        this.bag = (List)persister.getCollectionType().instantiate(0);
        this.endRead();
    }

    @Override
    public Object disassemble(CollectionPersister persister) {
        int length = this.bag.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(this.bag.get(i), this.getSession(), null);
        }
        return result;
    }

    @Override
    public void initializeFromCache(CollectionPersister collectionDescriptor, Object disassembled, Object owner) throws HibernateException {
        assert (this.bag == null);
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.bag = (List)collectionDescriptor.getCollectionSemantics().instantiateRaw(size, collectionDescriptor);
        for (Serializable item : array) {
            Object element = collectionDescriptor.getElementType().assemble(item, this.getSession(), owner);
            if (element == null) continue;
            this.bag.add(element);
        }
    }

    @Override
    public boolean needsRecreate(CollectionPersister persister) {
        return !persister.isOneToMany();
    }

    @Override
    public Iterator<?> getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList deletes = new ArrayList();
        List sn = (List)((Object)this.getSnapshot());
        Iterator olditer = sn.iterator();
        int i = 0;
        while (olditer.hasNext()) {
            Object old = olditer.next();
            Iterator<E> newiter = this.bag.iterator();
            boolean found = false;
            if (this.bag.size() > i && elementType.isSame(old, this.bag.get(i++))) {
                found = true;
            } else {
                while (newiter.hasNext()) {
                    if (!elementType.isSame(old, newiter.next())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > i && elemType.isSame(sn.get(i), entry)) {
            return false;
        }
        for (Object old : sn) {
            if (!elemType.isSame(old, entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return false;
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.bag.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.bag.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Boolean exists = this.readElementExistence(object);
        return exists == null ? this.bag.contains(object) : exists.booleanValue();
    }

    @Override
    public Iterator<E> iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy<E>(this.bag.iterator());
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    @Override
    public boolean add(E object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        if (this.bag.remove(o)) {
            this.elementRemoved = true;
            this.dirty();
            return true;
        }
        return false;
    }

    @Internal
    public boolean queuedRemove(Object element) {
        CollectionEntry entry = this.getSession().getPersistenceContextInternal().getCollectionEntry(this);
        if (entry == null) {
            this.throwLazyInitializationExceptionIfNotConnected();
            this.throwLazyInitializationException("collection not associated with session");
        } else {
            CollectionPersister persister = entry.getLoadedPersister();
            if (this.hasQueuedOperations()) {
                this.getSession().flush();
            }
            if (persister.elementExists(entry.getLoadedKey(), element, this.getSession())) {
                this.elementRemoved = true;
                this.queueOperation(new SimpleRemove(element));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.read();
        return this.bag.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> values) {
        if (values.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.addAll(values);
        }
        for (E value : values) {
            this.queueOperation(new SimpleAdd(value));
        }
        return values.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.size() > 0) {
            this.initialize(true);
            if (this.bag.removeAll(c)) {
                this.elementRemoved = true;
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.initialize(true);
        if (this.bag.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.bag.isEmpty()) {
                this.bag.clear();
                this.dirty();
            }
        }
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Bags don't have indexes : " + persister.getRole());
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(i);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator<E> itr = this.bag.iterator();
        int result = 0;
        while (itr.hasNext()) {
            if (!o.equals(itr.next())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void add(int i, E o) {
        this.write();
        this.bag.add(i, o);
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.addAll(i, c);
        }
        return false;
    }

    @Override
    public E get(int i) {
        this.read();
        return this.bag.get(i);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator(i));
    }

    @Override
    public E remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    @Override
    public E set(int i, E o) {
        this.write();
        return this.bag.set(i, o);
    }

    @Override
    public List<E> subList(int start, int end) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bag.subList(start, end));
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    final class SimpleRemove
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleRemove(E orphan) {
            super(null, orphan);
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.remove(this.getOrphan());
        }
    }

    final class SimpleAdd
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleAdd(E addedValue) {
            super(addedValue, null);
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.add(this.getAddedInstance());
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation<E> {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.clear();
        }

        @Override
        public E getAddedInstance() {
            return null;
        }

        @Override
        public E getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

