/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.dialect.StructHelper;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractPostgreSQLStructJdbcType
implements AggregateJdbcType {
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").toFormatter();
    private static final DateTimeFormatter LOCAL_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").toFormatter();
    private final String typeName;
    private final int[] orderMapping;
    private final int[] inverseOrderMapping;
    private final EmbeddableMappingType embeddableMappingType;

    protected AbstractPostgreSQLStructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        this.typeName = typeName;
        this.embeddableMappingType = embeddableMappingType;
        this.orderMapping = orderMapping;
        if (orderMapping == null) {
            this.inverseOrderMapping = null;
        } else {
            int[] inverseOrderMapping = new int[orderMapping.length];
            for (int i = 0; i < orderMapping.length; ++i) {
                inverseOrderMapping[orderMapping[i]] = i;
            }
            this.inverseOrderMapping = inverseOrderMapping;
        }
    }

    @Override
    public int getJdbcTypeCode() {
        return 2002;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        if (this.embeddableMappingType == null) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        }
        return this.embeddableMappingType.getMappedJavaType();
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(name), options);
            }

            private X getObject(Object object, WrapperOptions options) throws SQLException {
                if (object == null) {
                    return null;
                }
                return ((AbstractPostgreSQLStructJdbcType)this.getJdbcType()).fromString(object.toString(), this.getJavaType(), options);
            }
        };
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        Object[] array;
        int end;
        boolean returnEmbeddable;
        if (string == null) {
            return null;
        }
        boolean bl = returnEmbeddable = javaType.getJavaTypeClass() != Object[].class;
        if (this.embeddableMappingType == null) {
            assert (!returnEmbeddable);
            ArrayList<Object> values = new ArrayList<Object>(8);
            end = this.deserializeStruct(string, 0, string.length() - 1, values);
            array = values.toArray();
        } else {
            array = new Object[this.embeddableMappingType.getJdbcValueCount()];
            end = this.deserializeStruct(string, 0, 0, array, returnEmbeddable, options);
        }
        assert (end == string.length());
        if (returnEmbeddable) {
            Object[] attributeValues = this.getAttributeValues(this.embeddableMappingType, this.orderMapping, array, options);
            return (X)this.embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> attributeValues, options.getSessionFactory());
        }
        if (this.inverseOrderMapping != null) {
            StructHelper.orderJdbcValues(this.embeddableMappingType, this.inverseOrderMapping, (Object[])array.clone(), array);
        }
        return (X)array;
    }

    private int deserializeStruct(String string, int begin, int end, ArrayList<Object> values) {
        int column = 0;
        boolean inQuote = false;
        boolean hasEscape = false;
        assert (string.charAt(begin) == '(');
        int start = begin + 1;
        int element = 1;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (inQuote) {
                        if (i + 1 != end && string.charAt(i + 1) == '\"') {
                            ++i;
                            hasEscape = true;
                            continue block5;
                        }
                        if (hasEscape) {
                            values.add(AbstractPostgreSQLStructJdbcType.unescape(string, start, i));
                        } else {
                            values.add(string.substring(start, i));
                        }
                        ++column;
                        inQuote = false;
                    } else {
                        inQuote = true;
                    }
                    hasEscape = false;
                    start = i + 1;
                    continue block5;
                }
                case ',': {
                    if (inQuote) continue block5;
                    if (column < element) {
                        if (start == i) {
                            values.add(null);
                        } else {
                            values.add(string.substring(start, i));
                        }
                        ++column;
                    }
                    start = i + 1;
                    ++element;
                    continue block5;
                }
                case ')': {
                    if (inQuote) continue block5;
                    if (column < element) {
                        if (start == i) {
                            values.add(null);
                        } else {
                            values.add(string.substring(start, i));
                        }
                    }
                    return i + 1;
                }
            }
        }
        throw new IllegalArgumentException("Struct not properly formed: " + string.subSequence(start, end));
    }

    private int deserializeStruct(String string, int begin, int quoteLevel, Object[] values, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        int start;
        int column = 0;
        boolean inQuote = false;
        StringBuilder escapingSb = null;
        assert (string.charAt(begin) == '(');
        block12: for (int i = start = begin + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    JdbcMapping jdbcMapping;
                    if (inQuote) {
                        if (AbstractPostgreSQLStructJdbcType.repeatsChar(string, i, 1 << quoteLevel + 1, '\"')) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\"');
                            start = (i += (1 << quoteLevel + 1) - 1) + 1;
                            continue block12;
                        }
                        assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, i, 1 << quoteLevel, '\"'));
                        jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping();
                        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
                            case 91: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseDate(CharSequenceHelper.subSequence(string, start, i)), options);
                                break;
                            }
                            case 92: 
                            case 2013: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTime(CharSequenceHelper.subSequence(string, start, i)), options);
                                break;
                            }
                            case 93: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTimestamp(CharSequenceHelper.subSequence(string, start, i), jdbcMapping.getJdbcJavaType()), options);
                                break;
                            }
                            case 2014: 
                            case 3003: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTimestampWithTimeZone(CharSequenceHelper.subSequence(string, start, i), jdbcMapping.getJdbcJavaType()), options);
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 4003: {
                                int backslashes = 1 << quoteLevel + 1;
                                assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, start, backslashes, '\\'));
                                int xCharPosition = start + backslashes;
                                assert (string.charAt(xCharPosition) == 'x');
                                values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, xCharPosition + 1, i);
                                break;
                            }
                            default: {
                                if (escapingSb == null || escapingSb.length() == 0) {
                                    values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, start, i);
                                    break;
                                }
                                escapingSb.append(string, start, i);
                                values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, escapingSb, 0, escapingSb.length());
                                escapingSb.setLength(0);
                            }
                        }
                        ++column;
                        inQuote = false;
                        if (string.charAt(i += 1 << quoteLevel) == ')') {
                            assert (column == values.length);
                            return i + 1;
                        }
                        assert (string.charAt(i) == ',');
                    } else {
                        int expectedQuotes = Math.max(1, 1 << quoteLevel);
                        assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, i, expectedQuotes, '\"'));
                        if (string.charAt((i += expectedQuotes - 1) + 1) == '(') {
                            JdbcMapping jdbcMapping2 = this.getJdbcValueSelectable(column).getJdbcMapping();
                            if (jdbcMapping2.getJdbcType() instanceof AbstractPostgreSQLStructJdbcType) {
                                AbstractPostgreSQLStructJdbcType structJdbcType = (AbstractPostgreSQLStructJdbcType)jdbcMapping2.getJdbcType();
                                Object[] subValues = new Object[structJdbcType.embeddableMappingType.getJdbcValueCount()];
                                int subEnd = structJdbcType.deserializeStruct(string, i + 1, quoteLevel + 1, subValues, returnEmbeddable, options);
                                if (returnEmbeddable) {
                                    Object subValue;
                                    Object[] attributeValues = structJdbcType.getAttributeValues(structJdbcType.embeddableMappingType, structJdbcType.orderMapping, subValues, options);
                                    values[column] = subValue = structJdbcType.embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> attributeValues, options.getSessionFactory());
                                } else {
                                    if (structJdbcType.inverseOrderMapping != null) {
                                        StructHelper.orderJdbcValues(structJdbcType.embeddableMappingType, structJdbcType.inverseOrderMapping, (Object[])subValues.clone(), subValues);
                                    }
                                    values[column] = subValues;
                                }
                                ++column;
                                assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, subEnd, expectedQuotes, '\"'));
                                i = subEnd + expectedQuotes;
                                if (string.charAt(i) == ')') {
                                    assert (column == values.length);
                                    return i + 1;
                                }
                                assert (string.charAt(i) == ',');
                            } else {
                                inQuote = true;
                            }
                        } else {
                            inQuote = true;
                        }
                    }
                    start = i + 1;
                    continue block12;
                }
                case ',': {
                    JdbcMapping jdbcMapping;
                    if (inQuote) continue block12;
                    values[column] = start == i ? null : ((jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping()).getJdbcType().getDefaultSqlTypeCode() == 16 ? AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, string.charAt(start) == 't', options) : AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, start, i));
                    ++column;
                    start = i + 1;
                    continue block12;
                }
                case ')': {
                    if (inQuote) continue block12;
                    if (column < values.length) {
                        values[column] = start == i ? null : this.fromString(column, string, start, i);
                    }
                    return i + 1;
                }
            }
        }
        throw new IllegalArgumentException("Struct not properly formed: " + string.substring(start));
    }

    private SelectableMapping getJdbcValueSelectable(int jdbcValueSelectableIndex) {
        if (this.orderMapping != null) {
            int numberOfAttributeMappings = this.embeddableMappingType.getNumberOfAttributeMappings();
            int count = 0;
            for (int i = 0; i < numberOfAttributeMappings; ++i) {
                AttributeMapping attributeMapping = this.embeddableMappingType.getAttributeMapping(this.orderMapping[i]);
                MappingType mappedType = attributeMapping.getMappedType();
                if (mappedType instanceof EmbeddableMappingType) {
                    EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
                    SelectableMapping aggregateMapping = embeddableMappingType.getAggregateMapping();
                    if (aggregateMapping == null) {
                        SelectableMapping subSelectable = embeddableMappingType.getJdbcValueSelectable(jdbcValueSelectableIndex - count);
                        if (subSelectable != null) {
                            return subSelectable;
                        }
                        count += embeddableMappingType.getJdbcValueCount();
                        continue;
                    }
                    if (count == jdbcValueSelectableIndex) {
                        return aggregateMapping;
                    }
                    ++count;
                    continue;
                }
                if (count == jdbcValueSelectableIndex) {
                    return (SelectableMapping)((Object)attributeMapping);
                }
                count += attributeMapping.getJdbcTypeCount();
            }
            return null;
        }
        return this.embeddableMappingType.getJdbcValueSelectable(jdbcValueSelectableIndex);
    }

    private static boolean repeatsChar(String string, int start, int times, char c) {
        int end = start + times;
        if (end < string.length()) {
            while (start < end) {
                if (string.charAt(start) != c) {
                    return false;
                }
                ++start;
            }
            return true;
        }
        return false;
    }

    private Object fromString(int selectableIndex, String string, int start, int end) {
        return AbstractPostgreSQLStructJdbcType.fromString(this.getJdbcValueSelectable(selectableIndex).getJdbcMapping(), string, start, end);
    }

    private static Object fromString(JdbcMapping jdbcMapping, CharSequence charSequence, int start, int end) {
        return jdbcMapping.getJdbcJavaType().fromEncodedString(charSequence, start, end);
    }

    private static Object fromRawObject(JdbcMapping jdbcMapping, Object raw, WrapperOptions options) {
        return jdbcMapping.getJdbcJavaType().wrap(raw, options);
    }

    private Object parseDate(CharSequence subSequence) {
        return LOCAL_DATE.parse(subSequence, LocalDate::from);
    }

    private Object parseTime(CharSequence subSequence) {
        return DateTimeFormatter.ISO_LOCAL_TIME.parse(subSequence, LocalTime::from);
    }

    private Object parseTimestamp(CharSequence subSequence, JavaType<?> jdbcJavaType) {
        TemporalAccessor temporalAccessor = LOCAL_DATE_TIME.parse(subSequence);
        LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        timestamp.setNanos(temporalAccessor.get(ChronoField.NANO_OF_SECOND));
        return timestamp;
    }

    private Object parseTimestampWithTimeZone(CharSequence subSequence, JavaType<?> jdbcJavaType) {
        TemporalAccessor temporalAccessor = LOCAL_DATE_TIME.parse(subSequence);
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (jdbcJavaType.getJavaTypeClass() == Instant.class) {
                return Instant.from(temporalAccessor);
            }
            return OffsetDateTime.from(temporalAccessor);
        }
        return LocalDateTime.from(temporalAccessor);
    }

    private static String unescape(CharSequence string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append(string.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        StringBuilder sb = new StringBuilder();
        this.serializeStructTo(new PostgreSQLAppender(sb), domainValue, options);
        return sb.toString();
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        Object[] array = new Object[this.embeddableMappingType.getJdbcValueCount()];
        this.deserializeStruct((String)rawJdbcValue, 0, 0, array, true, options);
        if (this.inverseOrderMapping != null) {
            StructHelper.orderJdbcValues(this.embeddableMappingType, this.inverseOrderMapping, (Object[])array.clone(), array);
        }
        return array;
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.serializeStructTo(new PostgreSQLAppender(sb), value, options);
        return sb.toString();
    }

    private void serializeStructTo(PostgreSQLAppender appender, Object value, WrapperOptions options) {
        Object[] array = this.embeddableMappingType.getValues(value);
        this.serializeValuesTo(appender, options, this.embeddableMappingType, array, '(');
        appender.append(')');
    }

    private void serializeValuesTo(PostgreSQLAppender appender, WrapperOptions options, EmbeddableMappingType embeddableMappingType, Object[] array, char separator) {
        int end = embeddableMappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < end; ++i) {
            Object attributeValue;
            AttributeMapping attributeMapping;
            if (this.orderMapping == null) {
                attributeMapping = embeddableMappingType.getAttributeMapping(i);
                attributeValue = array == null ? null : array[i];
            } else {
                attributeMapping = embeddableMappingType.getAttributeMapping(this.orderMapping[i]);
                Object object = attributeValue = array == null ? null : array[this.orderMapping[i]];
            }
            if (attributeMapping instanceof BasicValuedMapping) {
                appender.append(separator);
                separator = (char)44;
                if (attributeValue == null) continue;
                JdbcMapping jdbcMapping = ((BasicValuedMapping)((Object)attributeMapping)).getJdbcMapping();
                this.serializeBasicTo(appender, options, jdbcMapping, attributeValue);
                continue;
            }
            if (attributeMapping instanceof EmbeddedAttributeMapping) {
                EmbeddableMappingType mappingType = (EmbeddableMappingType)attributeMapping.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    this.serializeValuesTo(appender, options, mappingType, attributeValue == null ? null : mappingType.getValues(attributeValue), separator);
                    separator = (char)44;
                    continue;
                }
                appender.append(separator);
                separator = (char)44;
                if (attributeValue == null) continue;
                appender.quoteStart();
                ((AbstractPostgreSQLStructJdbcType)aggregateMapping.getJdbcMapping().getJdbcType()).serializeStructTo(appender, attributeValue, options);
                appender.quoteEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unsupported attribute mapping: " + attributeMapping);
        }
    }

    private void serializeBasicTo(PostgreSQLAppender appender, WrapperOptions options, JdbcMapping jdbcMapping, Object array) {
        JavaType<?> jdbcJavaType = jdbcMapping.getJdbcJavaType();
        Object subValue = jdbcMapping.convertToRelationalValue(array);
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (subValue instanceof Boolean) {
                    appender.append((Boolean)subValue != false ? (char)'1' : '0');
                    break;
                }
            }
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(subValue, jdbcJavaType.getJavaTypeClass(), options));
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (subValue instanceof Boolean) {
                    appender.append((Boolean)subValue != false ? (char)'Y' : 'N');
                    break;
                }
            }
            case -16: 
            case -1: 
            case 4001: 
            case 4002: {
                appender.quoteStart();
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(subValue, jdbcJavaType.getJavaTypeClass(), options));
                appender.quoteEnd();
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: 
            case 3003: {
                this.appendTemporal(appender, jdbcMapping, subValue, options);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                byte[] bytes = jdbcJavaType.unwrap(subValue, byte[].class, options);
                int escapes = 1 << appender.quote;
                appender.ensureCanFit(escapes + 1 + (bytes.length << 1));
                for (int i = 0; i < escapes; ++i) {
                    appender.append('\\');
                }
                appender.append('x');
                PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
                break;
            }
            case 3000: {
                appender.append(subValue.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in struct: " + jdbcMapping.getJdbcType());
            }
        }
    }

    private Object[] getAttributeValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        Object[] attributeValues = numberOfAttributeMappings != rawJdbcValues.length || orderMapping != null ? new Object[numberOfAttributeMappings] : rawJdbcValues;
        int jdbcIndex = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            int attributeIndex = orderMapping == null ? i : orderMapping[i];
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(attributeIndex);
            jdbcIndex += this.injectAttributeValue(attributeMapping, attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private int injectAttributeValue(AttributeMapping attributeMapping, Object[] attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = attributeMapping.getMappedType();
        Object rawJdbcValue = rawJdbcValues[jdbcIndex];
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                jdbcValueCount = 1;
                attributeValues[attributeIndex] = rawJdbcValue;
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                Object[] subJdbcValues = new Object[jdbcValueCount];
                System.arraycopy(rawJdbcValues, jdbcIndex, subJdbcValues, 0, subJdbcValues.length);
                Object[] subValues = this.getAttributeValues(embeddableMappingType, null, subJdbcValues, options);
                attributeValues[attributeIndex] = embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> subValues, embeddableMappingType.findContainingEntityMapping().getEntityPersister().getFactory());
            }
        } else {
            assert (attributeMapping.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = attributeMapping.getSingleJdbcMapping();
            Object jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
            attributeValues[attributeIndex] = jdbcMapping.convertToDomainValue(jdbcValue);
        }
        return jdbcValueCount;
    }

    private void appendTemporal(SqlAppender appender, JdbcMapping jdbcMapping, Object value, WrapperOptions options) {
        TimeZone jdbcTimeZone = AbstractPostgreSQLStructJdbcType.getJdbcTimeZone(options);
        JavaType<?> javaType = jdbcMapping.getJdbcJavaType();
        appender.append('\"');
        switch (jdbcMapping.getJdbcType().getJdbcTypeCode()) {
            case 91: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsDate(appender, (Date)value);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsDate(appender, (Calendar)value);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    DateTimeUtils.appendAsDate(appender, (TemporalAccessor)value);
                    break;
                }
                DateTimeUtils.appendAsDate(appender, javaType.unwrap(value, Date.class, options));
                break;
            }
            case 92: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsTime(appender, (Date)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsTime(appender, (Calendar)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    TemporalAccessor temporalAccessor = (TemporalAccessor)value;
                    if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                        DateTimeUtils.appendAsTime(appender, temporalAccessor, true, jdbcTimeZone);
                        break;
                    }
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                    break;
                }
                DateTimeUtils.appendAsTime(appender, javaType.unwrap(value, Time.class, options), jdbcTimeZone);
                break;
            }
            case 93: 
            case 2014: 
            case 3003: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsTimestampWithMicros(appender, (Date)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsTimestampWithMillis(appender, (Calendar)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    TemporalAccessor temporalAccessor = (TemporalAccessor)value;
                    if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                        DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, true, jdbcTimeZone);
                        break;
                    }
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, false, jdbcTimeZone);
                    break;
                }
                DateTimeUtils.appendAsTimestampWithMicros(appender, javaType.unwrap(value, Date.class, options), jdbcTimeZone);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        appender.append('\"');
    }

    private static TimeZone getJdbcTimeZone(WrapperOptions options) {
        return options == null || options.getJdbcTimeZone() == null ? TimeZone.getDefault() : options.getJdbcTimeZone();
    }

    private static class PostgreSQLAppender
    extends StringBuilderSqlAppender {
        private int quote = 1;

        public PostgreSQLAppender(StringBuilder sb) {
            super(sb);
        }

        public void quoteStart() {
            this.append('\"');
            this.quote <<= 1;
        }

        public void quoteEnd() {
            this.quote >>= 1;
            this.append('\"');
        }

        @Override
        public PostgreSQLAppender append(char fragment) {
            if (this.quote != 1) {
                this.appendWithQuote(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public PostgreSQLAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public PostgreSQLAppender append(CharSequence csq, int start, int end) {
            if (this.quote != 1) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendWithQuote(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        private void appendWithQuote(char fragment) {
            if (fragment == '\"') {
                this.sb.ensureCapacity(this.sb.length() + this.quote);
                for (int i = 0; i < this.quote; ++i) {
                    this.sb.append('\"');
                }
            } else {
                this.sb.append(fragment);
            }
        }

        public void ensureCanFit(int lengthIncrease) {
            this.sb.ensureCapacity(this.sb.length() + lengthIncrease);
        }
    }
}

