/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.lang.reflect.Member;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.CurrentTimestamp;
import org.hibernate.annotations.SourceType;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.tuple.GenerationTiming;

public class CurrentTimestampGeneration
implements BeforeExecutionGenerator,
OnExecutionGenerator {
    private final EnumSet<EventType> eventTypes;
    private final CurrentTimestampGeneratorDelegate delegate;
    private static final Map<Class<?>, CurrentTimestampGeneratorDelegate> generatorDelegates = new HashMap();

    public CurrentTimestampGeneration(CurrentTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member);
        this.eventTypes = annotation.timing() == GenerationTiming.ALWAYS ? EventTypeSets.fromArray(annotation.event()) : annotation.timing().getEquivalent().eventTypes();
    }

    public CurrentTimestampGeneration(CreationTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member);
        this.eventTypes = EventTypeSets.INSERT_ONLY;
    }

    public CurrentTimestampGeneration(UpdateTimestamp annotation, Member member, GeneratorCreationContext context) {
        this.delegate = CurrentTimestampGeneration.getGeneratorDelegate(annotation.source(), member);
        this.eventTypes = EventTypeSets.INSERT_AND_UPDATE;
    }

    private static CurrentTimestampGeneratorDelegate getGeneratorDelegate(SourceType source, Member member) {
        switch (source) {
            case VM: {
                return generatorDelegates.get(ReflectHelper.getPropertyType(member));
            }
            case DB: {
                return null;
            }
        }
        throw new AssertionFailure("unknown source");
    }

    @Override
    public boolean generatedOnExecution() {
        return this.delegate == null;
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return this.delegate.generate();
    }

    @Override
    public boolean writePropertyValue() {
        return false;
    }

    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return true;
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.currentTimestamp()};
    }

    static {
        generatorDelegates.put(java.util.Date.class, java.util.Date::new);
        generatorDelegates.put(Calendar.class, () -> {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new java.util.Date());
            return calendar;
        });
        generatorDelegates.put(Date.class, () -> new Date(System.currentTimeMillis()));
        generatorDelegates.put(Time.class, () -> new Time(System.currentTimeMillis()));
        generatorDelegates.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        generatorDelegates.put(Instant.class, Instant::now);
        generatorDelegates.put(LocalDate.class, LocalDate::now);
        generatorDelegates.put(LocalDateTime.class, LocalDateTime::now);
        generatorDelegates.put(LocalTime.class, LocalTime::now);
        generatorDelegates.put(MonthDay.class, MonthDay::now);
        generatorDelegates.put(OffsetDateTime.class, OffsetDateTime::now);
        generatorDelegates.put(OffsetTime.class, OffsetTime::now);
        generatorDelegates.put(Year.class, Year::now);
        generatorDelegates.put(YearMonth.class, YearMonth::now);
        generatorDelegates.put(ZonedDateTime.class, ZonedDateTime::now);
    }

    private static interface CurrentTimestampGeneratorDelegate {
        public Object generate();
    }
}

