/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Map;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class ExplicitColumnDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final String tableExpression;
    private final String columnName;
    private final String columnFormula;
    private final boolean isPhysical;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;

    public ExplicitColumnDiscriminatorMappingImpl(EntityMappingType entityDescriptor, String tableExpression, String columnExpression, boolean isFormula, boolean isPhysical, String columnDefinition, Long length, Integer precision, Integer scale, DiscriminatorType<?> discriminatorType, Map<Object, EntityDiscriminatorMapping.DiscriminatorValueDetails> valueMappings, MappingModelCreationProcess creationProcess) {
        super(entityDescriptor, discriminatorType, valueMappings, creationProcess);
        this.tableExpression = tableExpression;
        this.isPhysical = isPhysical;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        if (isFormula) {
            this.columnName = null;
            this.columnFormula = columnExpression;
        } else {
            this.columnName = columnExpression;
            this.columnFormula = null;
        }
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.tableExpression);
        return expressionResolver.resolveSqlExpression(tableReference, this);
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName == null ? this.columnFormula : this.columnName;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public boolean isFormula() {
        return this.columnFormula != null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return this.isPhysical;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public boolean hasPhysicalColumn() {
        return this.isPhysical;
    }
}

