/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class CteUpdateHandler
extends AbstractCteMutationHandler
implements UpdateHandler {
    private static final String UPDATE_RESULT_TABLE_NAME_PREFIX = "update_cte_";
    private static final String INSERT_RESULT_TABLE_NAME_PREFIX = "insert_cte_";

    public CteUpdateHandler(CteTable cteTable, SqmUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void addDmlCtes(CteContainer statement, CteStatement idSelectCte, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter<?>, List<JdbcParameter>> parameterResolutions, SessionFactoryImplementor factory) {
        int i;
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        SqmUpdateStatement updateStatement = (SqmUpdateStatement)this.getSqmDeleteOrUpdateStatement();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        AbstractEntityPersister entityPersister = (AbstractEntityPersister)entityDescriptor.getEntityPersister();
        String rootEntityName = entityPersister.getRootEntityName();
        EntityPersister rootEntityDescriptor = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = ((Joinable)((Object)rootEntityDescriptor)).getTableName();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        SqmSetClause setClause = updateStatement.getSetClause();
        ArrayList assignments = new ArrayList(setClause.getAssignments().size());
        sqmConverter.visitSetClause(setClause, assignments::add, (sqmParam, mappingType, jdbcParameters) -> parameterResolutions.put(sqmParam, jdbcParameters));
        sqmConverter.addVersionedAssignment(assignments::add, updateStatement);
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i2 = 0; i2 < updatingTableGroup.getTableReferenceJoins().size(); ++i2) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i2), tableReferenceByAlias::put);
        }
        HashMap assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        for (i = 0; i < assignments.size(); ++i) {
            Assignment assignment = (Assignment)assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && !assignmentTableReference.equals(tableReference)) {
                    throw new IllegalStateException("Assignment referred to columns from multiple tables");
                }
                assignmentTableReference = tableReference;
            }
            assert (assignmentTableReference != null);
            ArrayList<Assignment> assignmentsForTable = (ArrayList<Assignment>)assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
        for (i = 0; i < entityPersister.getTableSpan(); ++i) {
            String insertCteTableName;
            if (!entityPersister.isNullableTable(i)) continue;
            String tableExpression2 = entityPersister.getTableName(i);
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression2, true, true);
            List assignmentList = (List)assignmentsByTable.get(updatingTableReference);
            if (assignmentList == null || statement.getCteStatement(insertCteTableName = this.getInsertCteTableName(tableExpression2)) != null) continue;
            CteTable dmlResultCte = new CteTable(insertCteTableName, idSelectCte.getCteTable().getCteColumns());
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression2);
            NamedTableReference existsTableReference = new NamedTableReference(tableExpression2, "dml_");
            ArrayList<ColumnReference> existsKeyColumns = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            String[] keyColumns = entityPersister.getKeyColumns(i);
            entityPersister.getIdentifierMapping().forEachSelectable((selectionIndex, selectableMapping) -> existsKeyColumns.add(new ColumnReference(existsTableReference, keyColumns[selectionIndex], selectableMapping.getJdbcMapping())));
            QuerySpec querySpec = this.createIdSubQuery(idSelectCte, null, factory).asRootQuery();
            QuerySpec existsQuerySpec = new QuerySpec(false);
            existsQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(-1, 0, new QueryLiteral<Integer>(1, factory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class))));
            existsQuerySpec.getFromClause().addRoot(new TableGroupImpl(null, null, existsTableReference, entityPersister));
            existsQuerySpec.applyPredicate(new ComparisonPredicate(this.asExpression(existsKeyColumns), ComparisonOperator.EQUAL, this.asExpression(querySpec.getSelectClause())));
            querySpec.applyPredicate(new ExistsPredicate(existsQuerySpec, true, factory.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class)));
            ArrayList<ColumnReference> targetColumnReferences = new ArrayList<ColumnReference>(existsKeyColumns);
            for (Assignment assignment : assignments) {
                targetColumnReferences.addAll(assignment.getAssignable().getColumnReferences());
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, -1, assignment.getAssignedValue()));
            }
            InsertSelectStatement dmlStatement = new InsertSelectStatement(dmlTableReference, existsKeyColumns);
            dmlStatement.addTargetColumnReferences(targetColumnReferences.toArray(new ColumnReference[0]));
            dmlStatement.setSourceSelectStatement(querySpec);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        }
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> {
            String cteTableName = this.getCteTableName(tableExpression);
            if (statement.getCteStatement(cteTableName) != null) {
                return;
            }
            CteTable dmlResultCte = new CteTable(cteTableName, idSelectCte.getCteTable().getCteColumns());
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true, true);
            List assignmentList = (List)assignmentsByTable.get(updatingTableReference);
            if (assignmentList == null) {
                return;
            }
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            ((Consumer)tableColumnsVisitationSupplier.get()).accept((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable)));
            UpdateStatement dmlStatement = new UpdateStatement(dmlTableReference, assignmentList, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        });
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    private TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    @Override
    protected String getCteTableName(String tableExpression) {
        Dialect dialect = this.getSessionFactory().getJdbcServices().getDialect();
        if (Identifier.isQuoted(tableExpression)) {
            tableExpression = tableExpression.substring(1, tableExpression.length() - 1);
        }
        return Identifier.toIdentifier(UPDATE_RESULT_TABLE_NAME_PREFIX + tableExpression).render(dialect);
    }

    protected String getInsertCteTableName(String tableExpression) {
        Dialect dialect = this.getSessionFactory().getJdbcServices().getDialect();
        if (Identifier.isQuoted(tableExpression)) {
            tableExpression = tableExpression.substring(1, tableExpression.length() - 1);
        }
        return Identifier.toIdentifier(INSERT_RESULT_TABLE_NAME_PREFIX + tableExpression).render(dialect);
    }

    private Expression asExpression(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        if (sqlSelections.size() == 1) {
            return sqlSelections.get(0).getExpression();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(sqlSelections.size());
        for (SqlSelection sqlSelection : sqlSelections) {
            expressions.add(sqlSelection.getExpression());
        }
        return new SqlTuple(expressions, null);
    }

    private Expression asExpression(List<ColumnReference> columnReferences) {
        if (columnReferences.size() == 1) {
            return columnReferences.get(0);
        }
        return new SqlTuple(columnReferences, null);
    }
}

