/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.BindableType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractJdbcParameter
implements JdbcParameter,
JdbcParameterBinder,
MappingModelExpressible,
SqlExpressible {
    private final JdbcMapping jdbcMapping;

    public AbstractJdbcParameter(JdbcMapping jdbcMapping) {
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitParameter(this);
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, javaType, this);
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
        JdbcParameterBinding binding = jdbcParamBindings.getBinding(this);
        if (binding == null) {
            throw new ExecutionException("JDBC parameter value not bound - " + this);
        }
        Object bindValue = binding.getBindValue();
        JdbcMapping jdbcMapping = binding.getBindType();
        if (jdbcMapping == null) {
            jdbcMapping = this.jdbcMapping;
        }
        if (jdbcMapping == null || jdbcMapping.getMappedJavaType().getJavaTypeClass() == Object.class) {
            jdbcMapping = this.guessBindType(executionContext, bindValue, jdbcMapping);
        }
        this.bindParameterValue(jdbcMapping, statement, bindValue, startPosition, executionContext);
    }

    protected void bindParameterValue(JdbcMapping jdbcMapping, PreparedStatement statement, Object bindValue, int startPosition, ExecutionContext executionContext) throws SQLException {
        jdbcMapping.getJdbcValueBinder().bind(statement, bindValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    private JdbcMapping guessBindType(ExecutionContext executionContext, Object bindValue, JdbcMapping jdbcMapping) {
        if (bindValue == null && jdbcMapping != null) {
            return jdbcMapping;
        }
        BindableType<Object> parameterType = executionContext.getSession().getFactory().getMappingMetamodel().resolveParameterBindType(bindValue);
        if (parameterType instanceof JdbcMapping) {
            return (JdbcMapping)((Object)parameterType);
        }
        return null;
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }
}

