/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractArrayJavaType<T, E>
extends AbstractClassJavaType<T>
implements BasicPluralJavaType<E> {
    private final JavaType<E> componentJavaType;

    public AbstractArrayJavaType(Class<T> clazz, BasicType<E> baseDescriptor, MutabilityPlan<T> mutabilityPlan) {
        this(clazz, baseDescriptor.getJavaTypeDescriptor(), mutabilityPlan);
    }

    public AbstractArrayJavaType(Class<T> clazz, JavaType<E> baseDescriptor, MutabilityPlan<T> mutabilityPlan) {
        super(clazz, mutabilityPlan);
        this.componentJavaType = baseDescriptor;
    }

    @Override
    public JavaType<E> getElementJavaType() {
        return this.componentJavaType;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        int preferredSqlTypeCodeForArray = indicators.getPreferredSqlTypeCodeForArray();
        JdbcType recommendedComponentJdbcType = this.componentJavaType.getRecommendedJdbcType(indicators);
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcType jdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(preferredSqlTypeCodeForArray);
        if (jdbcType instanceof ArrayJdbcType) {
            return ((ArrayJdbcType)jdbcType).resolveType(typeConfiguration, indicators.getDialect(), recommendedComponentJdbcType, ColumnTypeInformation.EMPTY);
        }
        return jdbcType;
    }

    @Override
    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<E> elementType, ColumnTypeInformation columnTypeInformation) {
        Class<E> elementJavaTypeClass = elementType.getJavaTypeDescriptor().getJavaTypeClass();
        if (elementType instanceof BasicPluralType || elementJavaTypeClass != null && elementJavaTypeClass.isArray()) {
            return null;
        }
        return typeConfiguration.standardBasicTypeForJavaType(this.getJavaType(), javaType -> {
            JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(2003);
            if (arrayJdbcType instanceof ArrayJdbcType) {
                arrayJdbcType = ((ArrayJdbcType)arrayJdbcType).resolveType(typeConfiguration, dialect, elementType, columnTypeInformation);
            }
            return new BasicArrayType(elementType, arrayJdbcType, (JavaType<T[]>)javaType);
        });
    }
}

