/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.Clock;
import java.time.Duration;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class ClockHelper {
    private static final Clock TICK_9 = Clock.systemDefaultZone();
    private static final Clock TICK_8 = Clock.tick(TICK_9, Duration.ofNanos(10L));
    private static final Clock TICK_7 = Clock.tick(TICK_9, Duration.ofNanos(100L));
    private static final Clock TICK_6 = Clock.tick(TICK_9, Duration.ofNanos(1000L));
    private static final Clock TICK_5 = Clock.tick(TICK_9, Duration.ofNanos(10000L));
    private static final Clock TICK_4 = Clock.tick(TICK_9, Duration.ofNanos(100000L));
    private static final Clock TICK_3 = Clock.tick(TICK_9, Duration.ofNanos(1000000L));
    private static final Clock TICK_2 = Clock.tick(TICK_9, Duration.ofNanos(10000000L));
    private static final Clock TICK_1 = Clock.tick(TICK_9, Duration.ofNanos(100000000L));
    private static final Clock TICK_0 = Clock.tick(TICK_9, Duration.ofNanos(1000000000L));

    public static Clock forPrecision(Integer precision, SharedSessionContractImplementor session) {
        int resolvedPrecision = precision == null ? session.getJdbcServices().getDialect().getDefaultTimestampPrecision() : precision.intValue();
        switch (resolvedPrecision) {
            case 0: {
                return TICK_0;
            }
            case 1: {
                return TICK_1;
            }
            case 2: {
                return TICK_2;
            }
            case 3: {
                return TICK_3;
            }
            case 4: {
                return TICK_4;
            }
            case 5: {
                return TICK_5;
            }
            case 6: {
                return TICK_6;
            }
            case 7: {
                return TICK_7;
            }
            case 8: {
                return TICK_8;
            }
            case 9: {
                return TICK_9;
            }
        }
        throw new IllegalArgumentException("Illegal precision: " + resolvedPrecision);
    }
}

