/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.ReplaceMissingSortedDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;

public class LuceneTextFieldComparatorSource
extends LuceneFieldComparatorSource {
    private final Object missingValue;
    private final MultiValueMode multiValueMode;

    public LuceneTextFieldComparatorSource(String nestedDocumentPath, Object missingValue, MultiValueMode multiValueMode, Query luceneFilter) {
        super(nestedDocumentPath, luceneFilter);
        this.missingValue = missingValue;
        this.multiValueMode = multiValueMode;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        boolean sortMissingLast = this.missingLast() ^ reversed;
        final TextMultiValuesToSingleValuesSource source = TextMultiValuesToSingleValuesSource.fromField(fieldname, this.multiValueMode, this.nestedDocsProvider);
        return new FieldComparator.TermOrdValComparator(numHits, fieldname, sortMissingLast){

            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                SortedDocValues sortedDocValues = source.getValues(context);
                if (LuceneTextFieldComparatorSource.this.missingValue == null || LuceneTextFieldComparatorSource.this.missingFirst() || LuceneTextFieldComparatorSource.this.missingLast()) {
                    return sortedDocValues;
                }
                return new ReplaceMissingSortedDocValues(sortedDocValues, (BytesRef)LuceneTextFieldComparatorSource.this.missingValue);
            }
        };
    }

    private boolean missingFirst() {
        return SortMissingValue.MISSING_FIRST.equals(this.missingValue);
    }

    private boolean missingLast() {
        return SortMissingValue.MISSING_LAST.equals(this.missingValue);
    }
}

