/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBClientContextService;
import org.jboss.as.ejb3.remote.LocalTransportProvider;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.EJBClientConfiguratorService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.Option;
import org.xnio.OptionMap;

public class EJBClientDescriptorMetaDataProcessor
implements DeploymentUnitProcessor {
    private static final String INTERNAL_REMOTING_PROFILE = "internal-remoting-profile";
    private static final String OUTBOUND_CONNECTION_CAPABILITY_NAME = "org.wildfly.remoting.outbound-connection";
    private static final String REMOTING_PROFILE_CAPABILITY_NAME = "org.wildfly.ejb3.remoting-profile";
    private final boolean appclient;

    public EJBClientDescriptorMetaDataProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        List<EJBClientInterceptor> deploymentEjbClientInterceptors = this.getClassPathInterceptors((ClassLoader)module.getClassLoader());
        List staticEjbClientInterceptors = (List)deploymentUnit.getAttachment(org.jboss.as.ejb3.subsystem.Attachments.STATIC_EJB_CLIENT_INTERCEPTORS);
        ArrayList<EJBClientInterceptor> ejbClientInterceptors = new ArrayList<EJBClientInterceptor>();
        if (deploymentEjbClientInterceptors != null) {
            ejbClientInterceptors.addAll(deploymentEjbClientInterceptors);
        }
        if (staticEjbClientInterceptors != null) {
            ejbClientInterceptors.addAll(staticEjbClientInterceptors);
        }
        boolean interceptorsDefined = ejbClientInterceptors != null && !ejbClientInterceptors.isEmpty();
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EJB_CLIENT_METADATA);
        if (ejbClientDescriptorMetaData == null && !interceptorsDefined) {
            return;
        }
        ServiceName ejbClientContextServiceName = EJBClientContextService.DEPLOYMENT_BASE_SERVICE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        final EJBClientContextService service = new EJBClientContextService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(ejbClientContextServiceName, (org.jboss.msc.service.Service)service);
        if (this.appclient) {
            serviceBuilder.addDependency(EJBClientContextService.APP_CLIENT_URI_SERVICE_NAME, URI.class, service.getAppClientUri());
            serviceBuilder.addDependency(EJBClientContextService.APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME, String.class, service.getAppClientEjbProperties());
        }
        serviceBuilder.addDependency(EJBClientConfiguratorService.SERVICE_NAME, EJBClientConfiguratorService.class, service.getConfiguratorServiceInjector());
        if (ejbClientDescriptorMetaData != null) {
            ServiceName profileServiceName;
            this.checkDescriptorConfiguration(ejbClientDescriptorMetaData);
            Injector<RemotingProfileService> profileServiceInjector = new Injector<RemotingProfileService>(){
                final Injector<EJBTransportProvider> injector;
                boolean injected;
                {
                    this.injector = service.getLocalProviderInjector();
                    this.injected = false;
                }

                public void inject(RemotingProfileService value) throws InjectionException {
                    EJBTransportProvider provider;
                    Supplier<EJBTransportProvider> transportSupplier = value.getLocalTransportProviderSupplier();
                    EJBTransportProvider eJBTransportProvider = provider = transportSupplier != null ? transportSupplier.get() : null;
                    if (provider != null) {
                        this.injected = true;
                        this.injector.inject((Object)provider);
                    }
                }

                public void uninject() {
                    if (this.injected) {
                        this.injected = false;
                        this.injector.uninject();
                    }
                }
            };
            String profile = ejbClientDescriptorMetaData.getProfile();
            if (profile != null) {
                profileServiceName = capabilityServiceSupport.getCapabilityServiceName(REMOTING_PROFILE_CAPABILITY_NAME, new String[]{profile});
                serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, (Injector)profileServiceInjector);
                serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, service.getProfileServiceInjector());
            } else {
                profileServiceName = ejbClientContextServiceName.append(new String[]{INTERNAL_REMOTING_PROFILE});
                HashMap<String, RemotingProfileService.RemotingConnectionSpec> remotingConnectionMap = new HashMap<String, RemotingProfileService.RemotingConnectionSpec>();
                ArrayList<RemotingProfileService.HttpConnectionSpec> httpConnections = new ArrayList<RemotingProfileService.HttpConnectionSpec>();
                ServiceBuilder profileServiceBuilder = serviceTarget.addService(profileServiceName);
                Consumer consumer = profileServiceBuilder.provides(new ServiceName[]{profileServiceName});
                Supplier localTransportProviderSupplier = null;
                if (ejbClientDescriptorMetaData.isLocalReceiverExcluded() != Boolean.TRUE) {
                    Boolean passByValue = ejbClientDescriptorMetaData.isLocalReceiverPassByValue();
                    localTransportProviderSupplier = profileServiceBuilder.requires(passByValue == Boolean.FALSE ? LocalTransportProvider.BY_REFERENCE_SERVICE_NAME : LocalTransportProvider.BY_VALUE_SERVICE_NAME);
                }
                Collection receiverConfigurations = ejbClientDescriptorMetaData.getRemotingReceiverConfigurations();
                for (EJBClientDescriptorMetaData.RemotingReceiverConfiguration receiverConfiguration : receiverConfigurations) {
                    String connectionRef = receiverConfiguration.getOutboundConnectionRef();
                    long connectTimeout = receiverConfiguration.getConnectionTimeout();
                    Properties channelCreationOptions = receiverConfiguration.getChannelCreationOptions();
                    OptionMap optionMap = this.getOptionMapFromProperties(channelCreationOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                    ServiceName internalServiceName = capabilityServiceSupport.getCapabilityServiceName(OUTBOUND_CONNECTION_CAPABILITY_NAME, new String[]{connectionRef});
                    Supplier supplier = profileServiceBuilder.requires(internalServiceName);
                    RemotingProfileService.RemotingConnectionSpec connectionSpec = new RemotingProfileService.RemotingConnectionSpec(connectionRef, supplier, optionMap, connectTimeout);
                    remotingConnectionMap.put(connectionRef, connectionSpec);
                }
                for (EJBClientDescriptorMetaData.HttpConnectionConfiguration httpConfigurations : ejbClientDescriptorMetaData.getHttpConnectionConfigurations()) {
                    String uri = httpConfigurations.getUri();
                    RemotingProfileService.HttpConnectionSpec httpConnectionSpec = new RemotingProfileService.HttpConnectionSpec(uri);
                    httpConnections.add(httpConnectionSpec);
                }
                RemotingProfileService profileService = new RemotingProfileService(consumer, localTransportProviderSupplier, Collections.emptyList(), remotingConnectionMap, httpConnections);
                profileServiceBuilder.setInstance((Service)profileService);
                profileServiceBuilder.install();
                serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, (Injector)profileServiceInjector);
                serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, service.getProfileServiceInjector());
            }
            String deploymentNodeSelectorClassName = ejbClientDescriptorMetaData.getDeploymentNodeSelector();
            if (deploymentNodeSelectorClassName != null) {
                DeploymentNodeSelector deploymentNodeSelector;
                try {
                    deploymentNodeSelector = module.getClassLoader().loadClass(deploymentNodeSelectorClassName).asSubclass(DeploymentNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw EjbLogger.ROOT_LOGGER.failedToCreateDeploymentNodeSelector(e, deploymentNodeSelectorClassName);
                }
                service.setDeploymentNodeSelector(deploymentNodeSelector);
            }
            long invocationTimeout = ejbClientDescriptorMetaData.getInvocationTimeout();
            service.setInvocationTimeout(invocationTimeout);
            int defaultCompression = ejbClientDescriptorMetaData.getDefaultCompression();
            service.setDefaultCompression(defaultCompression);
            Collection clusterConfigs = ejbClientDescriptorMetaData.getClusterConfigs();
            if (!clusterConfigs.isEmpty()) {
                ArrayList<EJBClientCluster> clientClusters = new ArrayList<EJBClientCluster>(clusterConfigs.size());
                AuthenticationContext clustersAuthenticationContext = AuthenticationContext.empty();
                for (EJBClientDescriptorMetaData.ClusterConfig clusterConfig : clusterConfigs) {
                    MatchRule defaultRule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
                    AuthenticationConfiguration defaultAuthenticationConfiguration = AuthenticationConfiguration.EMPTY;
                    EJBClientCluster.Builder clientClusterBuilder = new EJBClientCluster.Builder();
                    String clusterName = clusterConfig.getClusterName();
                    clientClusterBuilder.setName(clusterName);
                    defaultRule = defaultRule.matchProtocol("cluster");
                    defaultRule = defaultRule.matchUrnName(clusterName);
                    long maxAllowedConnectedNodes = clusterConfig.getMaxAllowedConnectedNodes();
                    clientClusterBuilder.setMaximumConnectedNodes(maxAllowedConnectedNodes);
                    String clusterNodeSelectorClassName = clusterConfig.getNodeSelector();
                    if (clusterNodeSelectorClassName != null) {
                        ClusterNodeSelector clusterNodeSelector;
                        try {
                            clusterNodeSelector = module.getClassLoader().loadClass(clusterNodeSelectorClassName).asSubclass(ClusterNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw EjbLogger.ROOT_LOGGER.failureDuringLoadOfClusterNodeSelector(clusterNodeSelectorClassName, clusterName, e);
                        }
                        clientClusterBuilder.setClusterNodeSelector(clusterNodeSelector);
                    }
                    Properties clusterChannelCreationOptions = clusterConfig.getChannelCreationOptions();
                    OptionMap clusterChannelCreationOptionMap = this.getOptionMapFromProperties(clusterChannelCreationOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                    Properties clusterConnectionOptions = clusterConfig.getConnectionOptions();
                    OptionMap clusterConnectionOptionMap = this.getOptionMapFromProperties(clusterConnectionOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                    long clusterConnectTimeout = clusterConfig.getConnectTimeout();
                    clientClusterBuilder.setConnectTimeoutMilliseconds(clusterConnectTimeout);
                    if (clusterConnectionOptionMap != null) {
                        RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)clusterConnectionOptionMap, (AuthenticationConfiguration)defaultAuthenticationConfiguration);
                    }
                    clustersAuthenticationContext = clustersAuthenticationContext.with(defaultRule, defaultAuthenticationConfiguration);
                    Collection clusterNodeConfigs = clusterConfig.getClusterNodeConfigs();
                    for (EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig : clusterNodeConfigs) {
                        MatchRule nodeRule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
                        AuthenticationConfiguration nodeAuthenticationConfiguration = AuthenticationConfiguration.EMPTY;
                        String nodeName = clusterNodeConfig.getNodeName();
                        nodeRule = nodeRule.matchProtocol("node");
                        nodeRule = nodeRule.matchUrnName(nodeName);
                        Properties channelCreationOptions = clusterNodeConfig.getChannelCreationOptions();
                        Properties connectionOptions = clusterNodeConfig.getConnectionOptions();
                        OptionMap connectionOptionMap = this.getOptionMapFromProperties(connectionOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                        long connectTimeout = clusterNodeConfig.getConnectTimeout();
                        if (connectionOptionMap != null) {
                            RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)connectionOptionMap, (AuthenticationConfiguration)nodeAuthenticationConfiguration);
                        }
                        clustersAuthenticationContext = clustersAuthenticationContext.with(0, nodeRule, nodeAuthenticationConfiguration);
                    }
                    EJBClientCluster clientCluster = clientClusterBuilder.build();
                    clientClusters.add(clientCluster);
                }
                service.setClientClusters(clientClusters);
                service.setClustersAuthenticationContext(clustersAuthenticationContext);
            }
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME, (Object)profileServiceName);
        } else if (!this.appclient) {
            serviceBuilder.addDependency(LocalTransportProvider.DEFAULT_LOCAL_TRANSPORT_PROVIDER_SERVICE_NAME, EJBTransportProvider.class, service.getLocalProviderInjector());
        }
        if (interceptorsDefined) {
            service.setClientInterceptors(ejbClientInterceptors);
        }
        serviceBuilder.install();
        EjbLogger.DEPLOYMENT_LOGGER.debugf("Deployment unit %s will use %s as the EJB client context service", deploymentUnit, ejbClientContextServiceName);
        phaseContext.addDeploymentDependency(ejbClientContextServiceName, EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE);
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME, (Object)ejbClientContextServiceName);
    }

    private void checkDescriptorConfiguration(EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws DeploymentUnitProcessingException {
        boolean receiversDefined;
        boolean profileDefined = ejbClientDescriptorMetaData.getProfile() != null;
        boolean bl = receiversDefined = !ejbClientDescriptorMetaData.getRemotingReceiverConfigurations().isEmpty() || ejbClientDescriptorMetaData.isLocalReceiverExcluded() != null || ejbClientDescriptorMetaData.isLocalReceiverPassByValue() != null;
        if (profileDefined && receiversDefined) {
            throw EjbLogger.ROOT_LOGGER.profileAndRemotingEjbReceiversUsedTogether();
        }
    }

    private OptionMap getOptionMapFromProperties(Properties properties, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                try {
                    Option option = Option.fromString((String)propertyName, (ClassLoader)classLoader);
                    optionMapBuilder.parse(option, properties.getProperty(propertyName), classLoader);
                }
                catch (IllegalArgumentException e) {
                    EjbLogger.DEPLOYMENT_LOGGER.failedToCreateOptionForProperty(propertyName, e.getMessage());
                }
            }
        }
        return optionMapBuilder.getMap();
    }

    /*
     * Exception decompiling
     */
    private List<EJBClientInterceptor> getClassPathInterceptors(ClassLoader classLoader) throws DeploymentUnitProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

