/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.operator.OutputCompressor;

public class SMIMECompressedGenerator
extends SMIMEGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private static final String COMPRESSED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, OutputCompressor outputCompressor) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentCompressor(mimeBodyPart, outputCompressor), COMPRESSED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", COMPRESSED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7z\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Compressed Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, OutputCompressor outputCompressor) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), outputCompressor);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, OutputCompressor outputCompressor) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), outputCompressor);
    }

    static {
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        if (commandMap instanceof MailcapCommandMap) {
            final MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
            mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
                    return null;
                }
            });
        }
    }

    private static class ContentCompressor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart content;
        private final OutputCompressor compressor;

        ContentCompressor(MimeBodyPart mimeBodyPart, OutputCompressor outputCompressor) {
            this.content = mimeBodyPart;
            this.compressor = outputCompressor;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            CMSCompressedDataStreamGenerator cMSCompressedDataStreamGenerator = new CMSCompressedDataStreamGenerator();
            OutputStream outputStream2 = cMSCompressedDataStreamGenerator.open(outputStream, this.compressor);
            try {
                this.content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.toString());
            }
        }
    }
}

