/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogRecordProcessor
implements LogRecordProcessor {
    private static final Logger logger = Logger.getLogger(SimpleLogRecordProcessor.class.getName());
    private final LogRecordExporter logRecordExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static LogRecordProcessor create(LogRecordExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleLogRecordProcessor(exporter);
    }

    SimpleLogRecordProcessor(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        try {
            List<LogRecordData> logs = Collections.singletonList(logRecord.toLogRecordData());
            CompletableResultCode result = this.logRecordExporter.export(logs);
            this.pendingExports.add(result);
            result.whenComplete(() -> {
                this.pendingExports.remove(result);
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.logRecordExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }
}

