/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StoppedServerResource
extends SimpleResourceDefinition {
    private static final PathElement SERVER = PathElement.pathElement((String)"server");
    private final ServerInventory serverInventory;

    public StoppedServerResource(ServerInventory serverInventory) {
        super(new SimpleResourceDefinition.Parameters(SERVER, HostResolver.getResolver("server", false)).setRuntime());
        this.serverInventory = serverInventory;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServerRootResourceDefinition.LAUNCH_TYPE, (context, operation) -> {
            this.readResourceServerConfig(context);
            context.getResult().set(ServerEnvironment.LaunchType.DOMAIN.toString());
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServerRootResourceDefinition.SERVER_STATE, (context, operation) -> {
            this.readResourceServerConfig(context);
            context.getResult().set("STOPPED");
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServerRootResourceDefinition.RUNTIME_CONFIGURATION_STATE, (context, operation) -> {
            this.readResourceServerConfig(context);
            context.getResult().set("stopped");
        });
    }

    private void readResourceServerConfig(OperationContext context) {
        PathAddress address = context.getCurrentAddress();
        String hostName = address.getElement(0).getValue();
        PathElement element = address.getLastElement();
        String serverName = element.getValue();
        ModelNode addr = new ModelNode();
        addr.add("host", hostName);
        addr.add("server-config", serverName);
        context.readResourceFromRoot(PathAddress.pathAddress((ModelNode)addr), false);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(ServerRootResourceDefinition.getDomainServerLifecycleDefinition((String)"start", (ModelType)ModelType.STRING, null, (AttributeDefinition[])new AttributeDefinition[]{ServerRootResourceDefinition.BLOCKING, ServerRootResourceDefinition.START_MODE}), (OperationStepHandler)new ServerStartHandler(this.serverInventory));
        resourceRegistration.registerOperationHandler(CompositeOperationHandler.INTERNAL_DEFINITION, (OperationStepHandler)CompositeOperationHandler.INSTANCE);
    }
}

