/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.logging;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordValidationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;

public class DomainManagementLogger_$logger
extends DelegatingBasicLogger
implements DomainManagementLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DomainManagementLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public DomainManagementLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void userAndPasswordWarning() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.userAndPasswordWarning$str(), new Object[0]);
    }

    protected String userAndPasswordWarning$str() {
        return "WFLYDM0001: Properties file defined with default user and password, this will be easy to guess.";
    }

    protected String unableToLoadProperties$str() {
        return "WFLYDM0017: Unable to load properties";
    }

    @Override
    public final StartException unableToLoadProperties(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLoadProperties$str(), new Object[0]), cause);
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String userNotFoundInDirectory$str() {
        return "WFLYDM0020: User '%s' not found in directory.";
    }

    @Override
    public final NamingException userNotFoundInDirectory(String username) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.userNotFoundInDirectory$str(), username));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConsoleAvailable$str() {
        return "WFLYDM0021: No java.io.Console available to interact with user.";
    }

    @Override
    public final IllegalStateException noConsoleAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noConsoleAvailable$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertiesFileNotFound$str() {
        return "WFLYDM0023: No %s files found.";
    }

    @Override
    public final String propertiesFileNotFound(String file) {
        return String.format(this.getLoggingLocale(), this.propertiesFileNotFound$str(), file);
    }

    protected String enterNewUserDetails$str() {
        return "Enter the details of the new user to add.";
    }

    @Override
    public final String enterNewUserDetails() {
        return String.format(this.getLoggingLocale(), this.enterNewUserDetails$str(), new Object[0]);
    }

    protected String realmPrompt$str() {
        return "Realm (%s)";
    }

    @Override
    public final String realmPrompt(String realm) {
        return String.format(this.getLoggingLocale(), this.realmPrompt$str(), realm);
    }

    protected String usernamePrompt0$str() {
        return "Username";
    }

    @Override
    public final String usernamePrompt() {
        return String.format(this.getLoggingLocale(), this.usernamePrompt0$str(), new Object[0]);
    }

    protected String usernamePrompt1$str() {
        return "Username (%s)";
    }

    @Override
    public final String usernamePrompt(String defaultUsername) {
        return String.format(this.getLoggingLocale(), this.usernamePrompt1$str(), defaultUsername);
    }

    protected String noUsernameExiting$str() {
        return "WFLYDM0024: No Username entered, exiting.";
    }

    @Override
    public final String noUsernameExiting() {
        return String.format(this.getLoggingLocale(), this.noUsernameExiting$str(), new Object[0]);
    }

    protected String passwordPrompt$str() {
        return "Password";
    }

    @Override
    public final String passwordPrompt() {
        return String.format(this.getLoggingLocale(), this.passwordPrompt$str(), new Object[0]);
    }

    protected String noPasswordExiting$str() {
        return "WFLYDM0025: No Password entered, exiting.";
    }

    @Override
    public final String noPasswordExiting() {
        return String.format(this.getLoggingLocale(), this.noPasswordExiting$str(), new Object[0]);
    }

    protected String passwordConfirmationPrompt$str() {
        return "Re-enter Password";
    }

    @Override
    public final String passwordConfirmationPrompt() {
        return String.format(this.getLoggingLocale(), this.passwordConfirmationPrompt$str(), new Object[0]);
    }

    protected String passwordMisMatch$str() {
        return "WFLYDM0026: The passwords do not match.";
    }

    @Override
    public final String passwordMisMatch() {
        return String.format(this.getLoggingLocale(), this.passwordMisMatch$str(), new Object[0]);
    }

    protected String usernameNotAlphaNumeric$str() {
        return "WFLYDM0028: Username must be alphanumeric with the exception of the following accepted symbols (%s)";
    }

    @Override
    public final String usernameNotAlphaNumeric(String symbols) {
        return String.format(this.getLoggingLocale(), this.usernameNotAlphaNumeric$str(), symbols);
    }

    protected String aboutToAddUser$str() {
        return "About to add user '%s' for realm '%s'";
    }

    @Override
    public final String aboutToAddUser(String username, String realm) {
        return String.format(this.getLoggingLocale(), this.aboutToAddUser$str(), username, realm);
    }

    protected String isCorrectPrompt$str() {
        return "Is this correct";
    }

    @Override
    public final String isCorrectPrompt() {
        return String.format(this.getLoggingLocale(), this.isCorrectPrompt$str(), new Object[0]);
    }

    protected String usernameEasyToGuess$str() {
        return "The username '%s' is easy to guess";
    }

    @Override
    public final String usernameEasyToGuess(String username) {
        return String.format(this.getLoggingLocale(), this.usernameEasyToGuess$str(), username);
    }

    protected String sureToAddUser$str() {
        return "Are you sure you want to add user '%s' yes/no?";
    }

    @Override
    public final String sureToAddUser(String username) {
        return String.format(this.getLoggingLocale(), this.sureToAddUser$str(), username);
    }

    protected String invalidConfirmationResponse$str() {
        return "WFLYDM0029: Invalid response. (Valid responses are %s and %s)";
    }

    @Override
    public final String invalidConfirmationResponse(String firstValues, String secondValues) {
        return String.format(this.getLoggingLocale(), this.invalidConfirmationResponse$str(), firstValues, secondValues);
    }

    protected String addedUser$str() {
        return "Added user '%s' to file '%s'";
    }

    @Override
    public final String addedUser(String username, String fileName) {
        return String.format(this.getLoggingLocale(), this.addedUser$str(), username, fileName);
    }

    protected String unableToAddUser$str() {
        return "WFLYDM0030: Unable to add user to %s due to error %s";
    }

    @Override
    public final String unableToAddUser(String file, String error) {
        return String.format(this.getLoggingLocale(), this.unableToAddUser$str(), file, error);
    }

    protected String unableToLoadUsers$str() {
        return "WFLYDM0031: Unable to add load users from %s due to error %s";
    }

    @Override
    public final String unableToLoadUsers(String file, String error) {
        return String.format(this.getLoggingLocale(), this.unableToLoadUsers$str(), file, error);
    }

    protected String errorHeader$str() {
        return "Error";
    }

    @Override
    public final String errorHeader() {
        return String.format(this.getLoggingLocale(), this.errorHeader$str(), new Object[0]);
    }

    protected String yesNo$str() {
        return "yes/no?";
    }

    @Override
    public final String yesNo() {
        return String.format(this.getLoggingLocale(), this.yesNo$str(), new Object[0]);
    }

    protected String multipleAuthenticationMechanismsDefined$str() {
        return "WFLYDM0033: Configuration for security realm '%s' includes multiple username/password based authentication mechanisms (%s). Only one is allowed";
    }

    @Override
    public final OperationFailedException multipleAuthenticationMechanismsDefined(String realmName, Set<String> mechanisms) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleAuthenticationMechanismsDefined$str(), realmName, mechanisms));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationFailedOneOfRequired$str() {
        return "WFLYDM0034: One of '%s' or '%s' required.";
    }

    @Override
    public final OperationFailedException operationFailedOneOfRequired(String attr1, String attr2) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.operationFailedOneOfRequired$str(), attr1, attr2));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationFailedOnlyOneOfRequired$str() {
        return "WFLYDM0035: Only one of '%s' or '%s' is required.";
    }

    @Override
    public final OperationFailedException operationFailedOnlyOneOfRequired(String attr1, String attr2) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.operationFailedOnlyOneOfRequired$str(), attr1, attr2));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSecurityContextEstablished$str() {
        return "WFLYDM0037: No security context has been established.";
    }

    @Override
    public final String noSecurityContextEstablished() {
        return String.format(this.getLoggingLocale(), this.noSecurityContextEstablished$str(), new Object[0]);
    }

    protected String filePrompt$str() {
        return "What type of user do you wish to add? %n a) Management User (mgmt-users.properties) %n b) Application User (application-users.properties)";
    }

    @Override
    public final String filePrompt() {
        return String.format(this.getLoggingLocale(), this.filePrompt$str(), new Object[0]);
    }

    protected String groupsPrompt$str() {
        return "What groups do you want this user to belong to? (Please enter a comma separated list, or leave blank for none)";
    }

    @Override
    public final String groupsPrompt() {
        return String.format(this.getLoggingLocale(), this.groupsPrompt$str(), new Object[0]);
    }

    protected String addedGroups$str() {
        return "Added user '%s' with groups %s to file '%s'";
    }

    @Override
    public final String addedGroups(String username, String groups, String fileName) {
        return String.format(this.getLoggingLocale(), this.addedGroups$str(), username, groups, fileName);
    }

    protected String invalidChoiceResponse$str() {
        return "WFLYDM0039: Invalid response. (Valid responses are A, a, B, or b)";
    }

    @Override
    public final String invalidChoiceResponse() {
        return String.format(this.getLoggingLocale(), this.invalidChoiceResponse$str(), new Object[0]);
    }

    protected String aboutToUpdateEnabledUser$str() {
        return "User '%s' already exists and is enabled, would you like to... %n a) Update the existing user password and roles %n b) Disable the existing user %n c) Type a new username";
    }

    @Override
    public final String aboutToUpdateEnabledUser(String user) {
        return String.format(this.getLoggingLocale(), this.aboutToUpdateEnabledUser$str(), user);
    }

    protected String aboutToUpdateDisabledUser$str() {
        return "User '%s' already exists and is disabled, would you like to... %n a) Update the existing user password and roles %n b) Enable the existing user %n c) Type a new username";
    }

    @Override
    public final String aboutToUpdateDisabledUser(String user) {
        return String.format(this.getLoggingLocale(), this.aboutToUpdateDisabledUser$str(), user);
    }

    protected String updateUser$str() {
        return "Updated user '%s' to file '%s'";
    }

    @Override
    public final String updateUser(String userName, String canonicalPath) {
        return String.format(this.getLoggingLocale(), this.updateUser$str(), userName, canonicalPath);
    }

    protected String unableToUpdateUser$str() {
        return "WFLYDM0040: Unable to update user to %s due to error %s";
    }

    @Override
    public final String unableToUpdateUser(String absolutePath, String message) {
        return String.format(this.getLoggingLocale(), this.unableToUpdateUser$str(), absolutePath, message);
    }

    protected String updatedGroups$str() {
        return "Updated user '%s' with groups %s to file '%s'";
    }

    @Override
    public final String updatedGroups(String username, String groups, String fileName) {
        return String.format(this.getLoggingLocale(), this.updatedGroups$str(), username, groups, fileName);
    }

    protected String invalidLocalUser$str() {
        return "WFLYDM0041: The user '%s' is not allowed in a local authentication.";
    }

    @Override
    public final IOException invalidLocalUser(String userName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidLocalUser$str(), userName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleCallbackHandlerForMechanism$str() {
        return "WFLYDM0042: Multiple CallbackHandlerServices for the same mechanism (%s)";
    }

    @Override
    public final StartException multipleCallbackHandlerForMechanism(String mechanismName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.multipleCallbackHandlerForMechanism$str(), mechanismName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noCallbackHandlerForMechanism$str() {
        return "WFLYDM0043: No CallbackHandler available for mechanism %s in realm %s";
    }

    @Override
    public final IllegalStateException noCallbackHandlerForMechanism(String mechanism, String realmName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noCallbackHandlerForMechanism$str(), mechanism, realmName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPlugInProvidersLoaded$str() {
        return "WFLYDM0044: No plug in providers found for module name %s";
    }

    @Override
    public final IllegalArgumentException noPlugInProvidersLoaded(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noPlugInProvidersLoaded$str(), name));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadPlugInProviders$str() {
        return "WFLYDM0045: Unable to load plug-in for module %s due to error (%s)";
    }

    @Override
    public final IllegalArgumentException unableToLoadPlugInProviders(String name, String error) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToLoadPlugInProviders$str(), name, error));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAuthenticationPlugInFound$str() {
        return "WFLYDM0046: No authentication plug-in found for name %s";
    }

    @Override
    public final IllegalArgumentException noAuthenticationPlugInFound(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAuthenticationPlugInFound$str(), name));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInitialisePlugIn$str() {
        return "WFLYDM0047: Unable to initialise plug-in %s due to error %s";
    }

    @Override
    public final IllegalStateException unableToInitialisePlugIn(String name, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToInitialisePlugIn$str(), name, message));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordNotStrongEnough$str() {
        return "WFLYDM0048: Password is not strong enough, it is '%s'. It should be at least '%s'.";
    }

    @Override
    public final String passwordNotStrongEnough(String currentStrength, String desiredStrength) {
        return String.format(this.getLoggingLocale(), this.passwordNotStrongEnough$str(), currentStrength, desiredStrength);
    }

    protected String passwordMustNotBeEqual$str() {
        return "WFLYDM0049: Password must not be equal to '%s', this value is restricted.";
    }

    @Override
    public final PasswordValidationException passwordMustNotBeEqual(String password) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordMustNotBeEqual$str(), password));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordMustHaveDigit$str() {
        return "WFLYDM0050: Password must have at least %d digit.";
    }

    @Override
    public final String passwordMustHaveDigit(int minDigit) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveDigit$str(), minDigit);
    }

    protected String passwordMustHaveSymbol$str() {
        return "WFLYDM0051: Password must have at least %s non-alphanumeric symbol.";
    }

    @Override
    public final String passwordMustHaveSymbol(int minSymbol) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveSymbol$str(), minSymbol);
    }

    protected String passwordMustHaveAlpha$str() {
        return "WFLYDM0052: Password must have at least %d alphanumeric character.";
    }

    @Override
    public final String passwordMustHaveAlpha(int minAlpha) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveAlpha$str(), minAlpha);
    }

    protected String passwordNotLongEnough$str() {
        return "WFLYDM0053: Password must have at least %s characters!";
    }

    @Override
    public final PasswordValidationException passwordNotLongEnough(int desiredLength) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordNotLongEnough$str(), desiredLength));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadKeyTrustFile$str() {
        return "WFLYDM0054: Unable to load key trust file.";
    }

    @Override
    public final IllegalStateException unableToLoadKeyTrustFile(Throwable t) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToLoadKeyTrustFile$str(), new Object[0]), t);
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToOperateOnTrustStore$str() {
        return "WFLYDM0055: Unable to operate on trust store.";
    }

    @Override
    public final IllegalStateException unableToOperateOnTrustStore(GeneralSecurityException gse) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToOperateOnTrustStore$str(), new Object[0]), gse);
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateDelegateTrustManager$str() {
        return "WFLYDM0056: Unable to create delegate trust manager.";
    }

    @Override
    public final IllegalStateException unableToCreateDelegateTrustManager() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToCreateDelegateTrustManager$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String onlyOneSyslogHandlerProtocol$str() {
        return "WFLYDM0057: The syslog-handler can only contain one protocol %s";
    }

    @Override
    public final XMLStreamException onlyOneSyslogHandlerProtocol(Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.onlyOneSyslogHandlerProtocol$str(), location));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noHandlerCalled$str() {
        return "WFLYDM0058: There is no handler called '%s'";
    }

    @Override
    public final IllegalStateException noHandlerCalled(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noHandlerCalled$str(), name));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sysLogProtocolAlreadyConfigured$str() {
        return "WFLYDM0059: There is already a protocol configured for the syslog handler at %s";
    }

    @Override
    public final OperationFailedException sysLogProtocolAlreadyConfigured(PathAddress append) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sysLogProtocolAlreadyConfigured$str(), append));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSyslogProtocol$str() {
        return "WFLYDM0060: No syslog protocol was given";
    }

    @Override
    public final OperationFailedException noSyslogProtocol() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSyslogProtocol$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noFormatterCalled$str() {
        return "WFLYDM0061: There is no formatter called '%s'";
    }

    @Override
    public final OperationFailedException noFormatterCalled(String formatterName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noFormatterCalled$str(), formatterName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveReferencedFormatter$str() {
        return "WFLYDM0062: Can not remove formatter, it is still referenced by the handler '%s'";
    }

    @Override
    public final OperationFailedException cannotRemoveReferencedFormatter(PathElement pathElement) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRemoveReferencedFormatter$str(), pathElement));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String handlerAlreadyExists$str() {
        return "WFLYDM0063: Handler names must be unique. There is already a handler called '%s' at %s";
    }

    @Override
    public final OperationFailedException handlerAlreadyExists(String name, PathAddress append) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.handlerAlreadyExists$str(), name, append));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleRealmsDetected$str() {
        return "WFLYDM0064: Different realm names detected '%s', '%s' reading user property files, all realms must be equal.";
    }

    @Override
    public final String multipleRealmsDetected(String realmOne, String realmTwo) {
        return String.format(this.getLoggingLocale(), this.multipleRealmsDetected$str(), realmOne, realmTwo);
    }

    protected String userRealmNotMatchDiscovered$str() {
        return "WFLYDM0065: The user supplied realm name '%s' does not match the realm name discovered from the property file(s) '%s'.";
    }

    @Override
    public final String userRealmNotMatchDiscovered(String supplied, String discovered) {
        return String.format(this.getLoggingLocale(), this.userRealmNotMatchDiscovered$str(), supplied, discovered);
    }

    protected String groupPropertiesButNoUserProperties$str() {
        return "WFLYDM0066: A group properties file '%s' has been specified, however no user properties has been specified.";
    }

    @Override
    public final String groupPropertiesButNoUserProperties(String groupProperties) {
        return String.format(this.getLoggingLocale(), this.groupPropertiesButNoUserProperties$str(), groupProperties);
    }

    protected String realmMustBeSpecified$str() {
        return "WFLYDM0067: A realm name must be specified.";
    }

    @Override
    public final String realmMustBeSpecified() {
        return String.format(this.getLoggingLocale(), this.realmMustBeSpecified$str(), new Object[0]);
    }

    protected String inconsistentRbacConfiguration$str() {
        return "WFLYDM0068: The current operation(s) would result in role based access control being enabled but leave it impossible for authenticated users to be assigned roles.";
    }

    @Override
    public final OperationFailedException inconsistentRbacConfiguration() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.inconsistentRbacConfiguration$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentRbacRuntimeState$str() {
        return "WFLYDM0069: The runtime role mapping configuration is inconsistent, the server must be restarted.";
    }

    @Override
    public final OperationFailedException inconsistentRbacRuntimeState() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.inconsistentRbacRuntimeState$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidChoiceUpdateUserResponse$str() {
        return "WFLYDM0070: Invalid response. (Valid responses are A, a, B, b, C or c)";
    }

    @Override
    public final String invalidChoiceUpdateUserResponse() {
        return String.format(this.getLoggingLocale(), this.invalidChoiceUpdateUserResponse$str(), new Object[0]);
    }

    protected String duplicateIncludeExclude$str() {
        return "WFLYDM0071: Role '%s' already contains an %s for type=%s, name=%s, realm=%s.";
    }

    @Override
    public final OperationFailedException duplicateIncludeExclude(String roleName, String incExcl, String type, String name, String realm) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.duplicateIncludeExclude$str(), roleName, incExcl, type, name, realm));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleAuthorizationConfigurationsDefined$str() {
        return "WFLYDM0072: Configuration for security realm '%s' includes multiple authorization configurations (%s). Only one is allowed";
    }

    @Override
    public final OperationFailedException multipleAuthorizationConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleAuthorizationConfigurationsDefined$str(), realmName, configurations));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleUsernameToDnConfigurationsDefined$str() {
        return "WFLYDM0073: Configuration for security realm '%s' includes multiple username-to-dn resources within the authorization=ldap resource (%s). Only one is allowed";
    }

    @Override
    public final OperationFailedException multipleUsernameToDnConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleUsernameToDnConfigurationsDefined$str(), realmName, configurations));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noGroupSearchDefined$str() {
        return "WFLYDM0074: Configuration for security realm '%s' does not contain any group-search resource within the authorization=ldap resource.";
    }

    @Override
    public final OperationFailedException noGroupSearchDefined(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noGroupSearchDefined$str(), realmName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleGroupSearchConfigurationsDefined$str() {
        return "WFLYDM0075: Configuration for security realm '%s' includes multiple group-search resources within the authorization=ldap resource (%s). Only one is allowed";
    }

    @Override
    public final OperationFailedException multipleGroupSearchConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleGroupSearchConfigurationsDefined$str(), realmName, configurations));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoleName$str() {
        return "WFLYDM0076: The role name '%s' is not a valid standard role.";
    }

    @Override
    public final OperationFailedException invalidRoleName(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidRoleName$str(), roleName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRoleNameDomain$str() {
        return "WFLYDM0077: The role name '%s' is not a valid standard role and is not a host scoped role or a server group scoped role.";
    }

    @Override
    public final OperationFailedException invalidRoleNameDomain(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidRoleNameDomain$str(), roleName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String roleMappingRemaining$str() {
        return "WFLYDM0078: The scoped role '%s' can not be removed as a role mapping still exists.";
    }

    @Override
    public final OperationFailedException roleMappingRemaining(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.roleMappingRemaining$str(), roleName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateScopedRole$str() {
        return "WFLYDM0079: A %s already exists with name '%s'";
    }

    @Override
    public final OperationFailedException duplicateScopedRole(String scopeType, String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.duplicateScopedRole$str(), scopeType, roleName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scopedRoleStandardName$str() {
        return "WFLYDM0080: The name '%s' conflicts with the standard role name of '%s' - comparison is case insensitive.";
    }

    @Override
    public final OperationFailedException scopedRoleStandardName(String scopedRole, String standardRole) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.scopedRoleStandardName$str(), scopedRole, standardRole));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badBaseRole$str() {
        return "WFLYDM0081: The base-role '%s' is not one of the standard roles for the current authorization provider.";
    }

    @Override
    public final OperationFailedException badBaseRole(String baseRole) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.badBaseRole$str(), baseRole));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordUsernameMatchError$str() {
        return "WFLYDM0082: The password must be different from the username";
    }

    @Override
    public final PasswordValidationException passwordUsernameMatchError() {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordUsernameMatchError$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noKey$str() {
        return "WFLYDM0083: The KeyStore %s does not contain any keys.";
    }

    @Override
    public final StartException noKey(String path) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noKey$str(), path));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aliasNotKey$str() {
        return "WFLYDM0084: The alias specified '%s' is not a Key, valid aliases are %s";
    }

    @Override
    public final StartException aliasNotKey(String alias, String validList) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.aliasNotKey$str(), alias, validList));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String aliasNotFound$str() {
        return "WFLYDM0085: The alias specified '%s' does not exist in the KeyStore, valid aliases are %s";
    }

    @Override
    public final StartException aliasNotFound(String alias, String validList) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.aliasNotFound$str(), alias, validList));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String keyStoreNotFound$str() {
        return "WFLYDM0086: The KeyStore can not be found at %s";
    }

    @Override
    public final StartException keyStoreNotFound(String path) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.keyStoreNotFound$str(), path));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleCacheConfigurationsDefined$str() {
        return "WFLYDM0087: Configuration for security realm '%s' includes multiple cache definitions at the same position in the hierarchy. Only one is allowed";
    }

    @Override
    public final OperationFailedException multipleCacheConfigurationsDefined(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleCacheConfigurationsDefined$str(), realmName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String usernameNotLoaded$str() {
        return "WFLYDM0088: Unable to load username for supplied username '%s'";
    }

    @Override
    public final NamingException usernameNotLoaded(String name) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.usernameNotLoaded$str(), name));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noNonProgressingOperationFound$str() {
        return "WFLYDM0089: No operation was found that has been holding the operation execution write lock for long than [%d] seconds";
    }

    @Override
    public final OperationFailedException noNonProgressingOperationFound(long timeout) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noNonProgressingOperationFound$str(), timeout));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeytab$str() {
        return "WFLYDM0090: Invalid Keytab path";
    }

    @Override
    public final StartException invalidKeytab(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidKeytab$str(), new Object[0]), (Throwable)cause);
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String subjectIdentityLoggedOut$str() {
        return "WFLYDM0091: logout has already been called on this SubjectIdentity.";
    }

    @Override
    public final IllegalStateException subjectIdentityLoggedOut() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.subjectIdentityLoggedOut$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainTGT$str() {
        return "WFLYDM0092: Unable to obtain Kerberos TGT";
    }

    @Override
    public final OperationFailedException unableToObtainTGT(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainTGT$str(), new Object[0]), (Throwable)cause);
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void keytabLoginFailed(String principal, String host, LoginException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.keytabLoginFailed$str(), (Object)principal, (Object)host);
    }

    protected String keytabLoginFailed$str() {
        return "WFLYDM0093: Login failed using Keytab for principal '%s' to handle request for host '%s'";
    }

    protected String kerberosWithoutKeytab$str() {
        return "WFLYDM0094: Kerberos is enabled for authentication on security realm '%s' but no Keytab has been added to the server-identity.";
    }

    @Override
    public final OperationFailedException kerberosWithoutKeytab(String realm) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.kerberosWithoutKeytab$str(), realm));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCipherSuitesInCommon$str() {
        return "WFLYDM0095: No cipher suites in common, supported=(%s), requested=(%s)";
    }

    @Override
    public final StartException noCipherSuitesInCommon(String supported, String requested) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noCipherSuitesInCommon$str(), supported, requested));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noProtocolsInCommon$str() {
        return "WFLYDM0096: No protocols in common, supported=(%s), requested=(%s)";
    }

    @Override
    public final StartException noProtocolsInCommon(String supported, String requested) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noProtocolsInCommon$str(), supported, requested));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String passwordShouldNotBeEqual$str() {
        return "WFLYDM0097: Password should not be equal to '%s', this value is restricted.";
    }

    @Override
    public final PasswordValidationException passwordShouldNotBeEqual(String password) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordShouldNotBeEqual$str(), password));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordUsernameShouldNotMatch$str() {
        return "WFLYDM0098: The password should be different from the username";
    }

    @Override
    public final PasswordValidationException passwordUsernameShouldNotMatch() {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordUsernameShouldNotMatch$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordShouldHaveXCharacters$str() {
        return "WFLYDM0099: Password should have at least %s characters!";
    }

    @Override
    public final PasswordValidationException passwordShouldHaveXCharacters(int desiredLength) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.getLoggingLocale(), this.passwordShouldHaveXCharacters$str(), desiredLength));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordShouldHaveAlpha$str() {
        return "WFLYDM0100: Password should have at least %d alphanumeric character.";
    }

    @Override
    public final String passwordShouldHaveAlpha(int minAlpha) {
        return String.format(this.getLoggingLocale(), this.passwordShouldHaveAlpha$str(), minAlpha);
    }

    protected String passwordShouldHaveDigit$str() {
        return "WFLYDM0101: Password should have at least %d digit.";
    }

    @Override
    public final String passwordShouldHaveDigit(int minDigit) {
        return String.format(this.getLoggingLocale(), this.passwordShouldHaveDigit$str(), minDigit);
    }

    protected String passwordShouldHaveSymbol$str() {
        return "WFLYDM0102: Password should have at least %s non-alphanumeric symbol.";
    }

    @Override
    public final String passwordShouldHaveSymbol(int minSymbol) {
        return String.format(this.getLoggingLocale(), this.passwordShouldHaveSymbol$str(), minSymbol);
    }

    protected String invalidSize$str() {
        return "WFLYDM0103: Invalid size %s";
    }

    @Override
    public final OperationFailedException invalidSize(String size) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSize$str(), size));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String suffixContainsMillis$str() {
        return "WFLYDM0104: The suffix (%s) can not contain seconds or milliseconds.";
    }

    @Override
    public final OperationFailedException suffixContainsMillis(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.suffixContainsMillis$str(), suffix));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSuffix$str() {
        return "WFLYDM0105: The suffix (%s) is invalid. A suffix must be a valid date format.";
    }

    @Override
    public final OperationFailedException invalidSuffix(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSuffix$str(), suffix));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filePermissionsProblemsFound$str() {
        return "WFLYDM0106: File permissions problems found while attempting to update %s file.";
    }

    @Override
    public final String filePermissionsProblemsFound(String file) {
        return String.format(this.getLoggingLocale(), this.filePermissionsProblemsFound$str(), file);
    }

    protected String domainRolloutNotProgressing$str() {
        return "WFLYDM0107: Operation '%s' has been holding the operation execution write lock for longer than [%d] seconds, but it is part of the rollout of a domain-wide operation with domain-uuid '%s' that has other operations that are alsonot progressing. Their ids are: %s. Cancellation of the operation on the domain controller is recommended.";
    }

    @Override
    public final OperationFailedException domainRolloutNotProgressing(String exclusiveLock, long timeout, String domainUUID, Collection relatedOps) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.domainRolloutNotProgressing$str(), exclusiveLock, timeout, domainUUID, relatedOps));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedResource$str() {
        return "WFLYDM0108: Unsupported resource '%s'";
    }

    @Override
    public final IllegalStateException unsupportedResource(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unsupportedResource$str(), name));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyTabFileNotFound$str() {
        return "WFLYDM0109: The Keytab file '%s' does not exist.";
    }

    @Override
    public final StartException keyTabFileNotFound(String fileName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.keyTabFileNotFound$str(), fileName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadSimpleNameForGroup$str() {
        return "WFLYDM0110: Unable to load a simple name for group '%s'";
    }

    @Override
    public final NamingException unableToLoadSimpleNameForGroup(String distinguishedName) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.unableToLoadSimpleNameForGroup$str(), distinguishedName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void keystoreWillBeCreated(String file, String host) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keystoreWillBeCreated$str(), (Object)file, (Object)host);
    }

    protected String keystoreWillBeCreated$str() {
        return "WFLYDM0111: Keystore %s not found, it will be auto-generated on first use with a self-signed certificate for host %s";
    }

    protected String failedToGenerateSelfSignedCertificate$str() {
        return "WFLYDM0112: Failed to generate self-signed certificate";
    }

    @Override
    public final RuntimeException failedToGenerateSelfSignedCertificate(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToGenerateSelfSignedCertificate$str(), new Object[0]), e);
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void keystoreHasBeenCreated(String file, String sha1, String sha256) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keystoreHasBeenCreated$str(), (Object)file, (Object)sha1, (Object)sha256);
    }

    protected String keystoreHasBeenCreated$str() {
        return "WFLYDM0113: Generated self-signed certificate at %s. Please note that self-signed certificates are not secure, and should only be used for testing purposes. Do not use this self-signed certificate in production.%nSHA-1 fingerprint of the generated key is %s%nSHA-256 fingerprint of the generated key is %s";
    }

    protected String failedToCreateLazyInitSSLContext$str() {
        return "WFLYDM0114: Failed to lazily initialize SSL context";
    }

    @Override
    public final RuntimeException failedToCreateLazyInitSSLContext(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreateLazyInitSSLContext$str(), new Object[0]), e);
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removedBrokenResource$str() {
        return "WFLYDM0135: The resource %s wasn't working properly and has been removed.";
    }

    @Override
    public final String removedBrokenResource(String address) {
        return String.format(this.getLoggingLocale(), this.removedBrokenResource$str(), address);
    }

    protected String noSubjectIdentityForProtocolAndHost$str() {
        return "WFLYDM0139: No SubjectIdentity found for %s/%s.";
    }

    @Override
    public final GeneralSecurityException noSubjectIdentityForProtocolAndHost(String protocol, String host) {
        GeneralSecurityException result = new GeneralSecurityException(String.format(this.getLoggingLocale(), this.noSubjectIdentityForProtocolAndHost$str(), protocol, host));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String usingDeprecatedSystemProperty$str() {
        return "WFLYDM0140: You shouldn't use the system property \"%s\" as it is deprecated. Use the management model configuration instead.";
    }

    @Override
    public final StartException usingDeprecatedSystemProperty(String propertyName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.usingDeprecatedSystemProperty$str(), propertyName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String legacyMechanismsAreNotSupported$str() {
        return "WFLYDM0142: Following mechanisms configured on the server (%s) are not supported by the realm '%s'.";
    }

    @Override
    public final StartException legacyMechanismsAreNotSupported(String mechanismNames, String realmName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.legacyMechanismsAreNotSupported$str(), mechanismNames, realmName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSensitiveClassificationAttribute$str() {
        return "WFLYDM0143: Invalid sensitive classification attribute '%s'";
    }

    @Override
    public final IllegalStateException invalidSensitiveClassificationAttribute(String attr) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidSensitiveClassificationAttribute$str(), attr));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String imcompatibleConfiguredRequiresAttributeValue$str() {
        return "WFLYDM0144: Sensitivity constraint %s contains imcompatible attribute value to other sensitive classification constraints.";
    }

    @Override
    public final OperationFailedException imcompatibleConfiguredRequiresAttributeValue(String addr) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.imcompatibleConfiguredRequiresAttributeValue$str(), addr));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityRealmsUnsupported$str() {
        return "WFLYDM0145: Security realms are no longer supported, please remove them from the configuration.";
    }

    @Override
    public final XMLStreamException securityRealmsUnsupported() {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.securityRealmsUnsupported$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outboundConnectionsUnsupported$str() {
        return "WFLYDM0146: Outbound connections are no longer supported, please remove them from the configuration.";
    }

    @Override
    public final XMLStreamException outboundConnectionsUnsupported() {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.outboundConnectionsUnsupported$str(), new Object[0]));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String passwordUsernameMustMatchInfo$str() {
        return "The password must be different from the username";
    }

    @Override
    public final String passwordUsernameMustMatchInfo() {
        return String.format(this.getLoggingLocale(), this.passwordUsernameMustMatchInfo$str(), new Object[0]);
    }

    protected String passwordUsernameShouldMatchInfo$str() {
        return "The password should be different from the username";
    }

    @Override
    public final String passwordUsernameShouldMatchInfo() {
        return String.format(this.getLoggingLocale(), this.passwordUsernameShouldMatchInfo$str(), new Object[0]);
    }

    protected String passwordMustNotEqualInfo$str() {
        return "The password must not be one of the following restricted values {%s}";
    }

    @Override
    public final String passwordMustNotEqualInfo(String restricted) {
        return String.format(this.getLoggingLocale(), this.passwordMustNotEqualInfo$str(), restricted);
    }

    protected String passwordShouldNotEqualInfo$str() {
        return "The password should not be one of the following restricted values {%s}";
    }

    @Override
    public final String passwordShouldNotEqualInfo(String restricted) {
        return String.format(this.getLoggingLocale(), this.passwordShouldNotEqualInfo$str(), restricted);
    }

    protected String passwordLengthInfo$str() {
        return "%s characters";
    }

    @Override
    public final String passwordLengthInfo(int desiredLength) {
        return String.format(this.getLoggingLocale(), this.passwordLengthInfo$str(), desiredLength);
    }

    protected String passwordMustHaveAlphaInfo$str() {
        return "%d alphabetic character(s)";
    }

    @Override
    public final String passwordMustHaveAlphaInfo(int minAlpha) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveAlphaInfo$str(), minAlpha);
    }

    protected String passwordMustHaveDigitInfo$str() {
        return "%d digit(s)";
    }

    @Override
    public final String passwordMustHaveDigitInfo(int minDigit) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveDigitInfo$str(), minDigit);
    }

    protected String passwordMustHaveSymbolInfo$str() {
        return "%s non-alphanumeric symbol(s)";
    }

    @Override
    public final String passwordMustHaveSymbolInfo(int minSymbol) {
        return String.format(this.getLoggingLocale(), this.passwordMustHaveSymbolInfo$str(), minSymbol);
    }

    protected String passwordMustContainInfo$str() {
        return "The password must contain at least %s";
    }

    @Override
    public final String passwordMustContainInfo(String requirements) {
        return String.format(this.getLoggingLocale(), this.passwordMustContainInfo$str(), requirements);
    }

    protected String passwordShouldContainInfo$str() {
        return "The password should contain at least %s";
    }

    @Override
    public final String passwordShouldContainInfo(String requirements) {
        return String.format(this.getLoggingLocale(), this.passwordShouldContainInfo$str(), requirements);
    }

    protected String sureToSetPassword$str() {
        return "Are you sure you want to use the password entered yes/no?";
    }

    @Override
    public final String sureToSetPassword() {
        return String.format(this.getLoggingLocale(), this.sureToSetPassword$str(), new Object[0]);
    }

    protected String usageDescription$str() {
        return "The add-user script is a utility for adding new users to the properties files for out-of-the-box authentication. It can be used to manage users in ManagementRealm and ApplicationRealm.";
    }

    @Override
    public final String usageDescription() {
        return String.format(this.getLoggingLocale(), this.usageDescription$str(), new Object[0]);
    }

    protected String argUsage$str() {
        return "Usage: ./add-user.sh [args...]%nwhere args include:";
    }

    @Override
    public final String argUsage() {
        return String.format(this.getLoggingLocale(), this.argUsage$str(), new Object[0]);
    }

    protected String argApplicationUsers$str() {
        return "If set add an application user instead of a management user";
    }

    @Override
    public final String argApplicationUsers() {
        return String.format(this.getLoggingLocale(), this.argApplicationUsers$str(), new Object[0]);
    }

    protected String argDomainConfigDirUsers$str() {
        return "Define the location of the domain config directory.";
    }

    @Override
    public final String argDomainConfigDirUsers() {
        return String.format(this.getLoggingLocale(), this.argDomainConfigDirUsers$str(), new Object[0]);
    }

    protected String argServerConfigDirUsers$str() {
        return "Define the location of the server config directory.";
    }

    @Override
    public final String argServerConfigDirUsers() {
        return String.format(this.getLoggingLocale(), this.argServerConfigDirUsers$str(), new Object[0]);
    }

    protected String argUserProperties$str() {
        return "The file name of the user properties file which can be an absolute path.";
    }

    @Override
    public final String argUserProperties() {
        return String.format(this.getLoggingLocale(), this.argUserProperties$str(), new Object[0]);
    }

    protected String argGroupProperties$str() {
        return "The file name of the group properties file which can be an absolute path. (If group properties is specified then user properties MUST also be specified).";
    }

    @Override
    public final String argGroupProperties() {
        return String.format(this.getLoggingLocale(), this.argGroupProperties$str(), new Object[0]);
    }

    protected String argPassword$str() {
        return "Password of the user, this will be checked against the password requirements defined within the add-user.properties configuration";
    }

    @Override
    public final String argPassword() {
        return String.format(this.getLoggingLocale(), this.argPassword$str(), new Object[0]);
    }

    protected String argUser$str() {
        return "Name of the user";
    }

    @Override
    public final String argUser() {
        return String.format(this.getLoggingLocale(), this.argUser$str(), new Object[0]);
    }

    protected String argRealm$str() {
        return "Name of the realm used to secure the management interfaces (default is \"ManagementRealm\")";
    }

    @Override
    public final String argRealm() {
        return String.format(this.getLoggingLocale(), this.argRealm$str(), new Object[0]);
    }

    protected String argSilent$str() {
        return "Activate the silent mode (no output to the console)";
    }

    @Override
    public final String argSilent() {
        return String.format(this.getLoggingLocale(), this.argSilent$str(), new Object[0]);
    }

    protected String argRole$str() {
        return "Comma-separated list of roles for the user.";
    }

    @Override
    public final String argRole() {
        return String.format(this.getLoggingLocale(), this.argRole$str(), new Object[0]);
    }

    protected String argGroup$str() {
        return "Comma-separated list of groups for the user.";
    }

    @Override
    public final String argGroup() {
        return String.format(this.getLoggingLocale(), this.argGroup$str(), new Object[0]);
    }

    protected String argEnable$str() {
        return "Enable the user";
    }

    @Override
    public final String argEnable() {
        return String.format(this.getLoggingLocale(), this.argEnable$str(), new Object[0]);
    }

    protected String argDisable$str() {
        return "Disable the user";
    }

    @Override
    public final String argDisable() {
        return String.format(this.getLoggingLocale(), this.argDisable$str(), new Object[0]);
    }

    protected String argConfirmWarning$str() {
        return "Automatically confirm warning in interactive mode";
    }

    @Override
    public final String argConfirmWarning() {
        return String.format(this.getLoggingLocale(), this.argConfirmWarning$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String yes$str() {
        return "yes";
    }

    @Override
    public final String yes() {
        return String.format(this.getLoggingLocale(), this.yes$str(), new Object[0]);
    }

    protected String shortYes$str() {
        return "y";
    }

    @Override
    public final String shortYes() {
        return String.format(this.getLoggingLocale(), this.shortYes$str(), new Object[0]);
    }

    protected String no$str() {
        return "no";
    }

    @Override
    public final String no() {
        return String.format(this.getLoggingLocale(), this.no$str(), new Object[0]);
    }

    protected String shortNo$str() {
        return "n";
    }

    @Override
    public final String shortNo() {
        return String.format(this.getLoggingLocale(), this.shortNo$str(), new Object[0]);
    }

    protected String alternativeRealm$str() {
        return "The realm name supplied must match the name used by the server configuration which by default would be '%s'";
    }

    @Override
    public final String alternativeRealm(String defaultRealm) {
        return String.format(this.getLoggingLocale(), this.alternativeRealm$str(), defaultRealm);
    }

    protected String realmConfirmation$str() {
        return "Are you sure you want to set the realm to '%s'";
    }

    @Override
    public final String realmConfirmation(String chosenRealm) {
        return String.format(this.getLoggingLocale(), this.realmConfirmation$str(), chosenRealm);
    }

    protected String passwordRequirements$str() {
        return "Password requirements are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    }

    @Override
    public final String passwordRequirements() {
        return String.format(this.getLoggingLocale(), this.passwordRequirements$str(), new Object[0]);
    }

    protected String passwordRecommendations$str() {
        return "Password recommendations are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    }

    @Override
    public final String passwordRecommendations() {
        return String.format(this.getLoggingLocale(), this.passwordRecommendations$str(), new Object[0]);
    }

    protected String userSuppliedRealm$str() {
        return "Using realm '%s' as specified on the command line.";
    }

    @Override
    public final String userSuppliedRealm(String realmName) {
        return String.format(this.getLoggingLocale(), this.userSuppliedRealm$str(), realmName);
    }

    protected String discoveredRealm$str() {
        return "Using realm '%s' as discovered from the existing property files.";
    }

    @Override
    public final String discoveredRealm(String realmName) {
        return String.format(this.getLoggingLocale(), this.discoveredRealm$str(), realmName);
    }

    protected String multipleRealmDeclarations$str() {
        return "Users properties file '%s' contains multiple realm name declarations";
    }

    @Override
    public final IOException multipleRealmDeclarations(String usersFile) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.multipleRealmDeclarations$str(), usersFile));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String callbackHandlerNotInitialized$str() {
        return "The callback handler is not initialized for domain server %s.";
    }

    @Override
    public final IllegalStateException callbackHandlerNotInitialized(String serverName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.callbackHandlerNotInitialized$str(), serverName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainCredential$str() {
        return "Unable to obtain credential for server %s";
    }

    @Override
    public final IllegalStateException unableToObtainCredential(String serverName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToObtainCredential$str(), serverName));
        DomainManagementLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

