/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    REMOTING_1_0("urn:jboss:domain:remoting:1.0"),
    REMOTING_1_1("urn:jboss:domain:remoting:1.1"),
    REMOTING_1_2("urn:jboss:domain:remoting:1.2"),
    REMOTING_2_0("urn:jboss:domain:remoting:2.0"),
    REMOTING_3_0("urn:jboss:domain:remoting:3.0"),
    REMOTING_4_0("urn:jboss:domain:remoting:4.0"),
    REMOTING_5_0("urn:jboss:domain:remoting:5.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = REMOTING_5_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

