/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneDoubleDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneDoubleFieldCodec
extends AbstractLuceneNumericFieldCodec<Double, Double> {
    public LuceneDoubleFieldCodec(Indexing indexing, DocValues docValues, Storage storage, Double indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, Double value, Double encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.doubleValue()));
    }

    @Override
    public Double decode(IndexableField field) {
        return (Double)field.numericValue();
    }

    @Override
    public Double encode(Double value) {
        return value;
    }

    @Override
    public Double decode(Double encoded) {
        return encoded;
    }

    @Override
    public LuceneNumericDomain<Double> getDomain() {
        return LuceneDoubleDomain.get();
    }
}

