/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class ScriptStyleBaseRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final String COMP_KEY = ScriptStyleBaseRenderer.class.getName() + "_COMPOSITE_COMPONENT";
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        String target = this.verifyTarget((String)component.getAttributes().get("target"));
        if (target != null) {
            UIComponent cc = UIComponent.getCurrentCompositeComponent((FacesContext)context);
            if (cc != null) {
                component.getAttributes().put(COMP_KEY, cc.getClientId(context));
            }
            context.getViewRoot().addComponentResource(context, component, target);
        }
    }

    public final void decode(FacesContext context, UIComponent component) {
    }

    public final boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent curCC;
        char sep;
        UIComponent cc;
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (null != ccID && (cc = -1 != ccID.indexOf(sep = UINamingContainer.getSeparatorChar((FacesContext)context)) ? context.getViewRoot().findComponent(":" + ccID) : ScriptStyleBaseRenderer.findComponentIgnoringNamingContainers((UIComponent)context.getViewRoot(), ccID, true)) != (curCC = UIComponent.getCurrentCompositeComponent((FacesContext)context))) {
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, cc);
            component.pushComponentToEL(context, component);
        }
    }

    public final void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren;
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        int childCount = component.getChildCount();
        boolean bl = renderChildren = 0 < childCount;
        if (null == name) {
            if (0 == childCount) {
                if (context.isProjectStage(ProjectStage.Development)) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "outputScript or outputStylesheet with no library, no name, and no body content", "Is body content intended?");
                    context.addMessage(component.getClientId(context), message);
                }
                renderChildren = false;
            }
        } else if (0 < childCount) {
            logger.info("outputScript or outputStylesheet with name attribute and nested content. Ignoring nested content.");
            renderChildren = false;
        }
        if (renderChildren) {
            ResponseWriter writer = context.getResponseWriter();
            this.startInlineElement(context, writer, component);
            super.encodeChildren(context, component);
            this.endInlineElement(writer, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String msg;
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        if (null == name) {
            return;
        }
        int queryPos = name.indexOf("?");
        String query = null;
        if (queryPos > -1 && name.length() > queryPos) {
            query = name.substring(queryPos + 1);
            name = name.substring(0, queryPos);
        }
        String library = (String)attributes.get("library");
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        if (resourceHandler.isResourceRendered(context, name, library)) {
            return;
        }
        Resource resource = resourceHandler.createResource(name, library);
        Object resourceUrl = "RES_NOT_FOUND";
        ResponseWriter writer = context.getResponseWriter();
        this.startExternalElement(context, writer, component);
        WebConfiguration webConfig = WebConfiguration.getInstance();
        if (library == null && name != null && name.startsWith(webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory))) {
            if (context.isProjectStage(ProjectStage.Development)) {
                msg = "Illegal path, direct contract references are not allowed: " + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
            resource = null;
        }
        if (resource == null) {
            if (context.isProjectStage(ProjectStage.Development)) {
                msg = "Unable to find resource " + (String)(library == null ? "" : library + ", ") + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
        } else {
            resourceUrl = resource.getRequestPath();
            if (query != null) {
                resourceUrl = (String)resourceUrl + (((String)resourceUrl).indexOf("?") > -1 ? "&amp;" : "?") + query;
            }
            resourceUrl = context.getExternalContext().encodeResourceURL((String)resourceUrl);
        }
        this.endExternalElement(writer, component, (String)resourceUrl);
        resourceHandler.markResourceRendered(context, name, library);
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (ccID != null) {
            component.popComponentFromEL(context);
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, component);
        }
    }

    private static UIComponent findComponentIgnoringNamingContainers(UIComponent base, String id, boolean checkId) {
        if (checkId && id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = (UIComponent)i.next();
            if (checkId && id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ScriptStyleBaseRenderer.findComponentIgnoringNamingContainers(kid, id, true);
            if (result != null) break;
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    protected abstract void startInlineElement(FacesContext var1, ResponseWriter var2, UIComponent var3) throws IOException;

    protected abstract void endInlineElement(ResponseWriter var1, UIComponent var2) throws IOException;

    protected abstract void startExternalElement(FacesContext var1, ResponseWriter var2, UIComponent var3) throws IOException;

    protected abstract void endExternalElement(ResponseWriter var1, UIComponent var2, String var3) throws IOException;

    protected String verifyTarget(String toVerify) {
        return toVerify;
    }
}

