/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.AbstractMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class MutationExecutorSingleSelfExecuting
extends AbstractMutationExecutor {
    private final SelfExecutingUpdateOperation operation;
    private final JdbcValueBindingsImpl valueBindings;

    public MutationExecutorSingleSelfExecuting(SelfExecutingUpdateOperation operation, SharedSessionContractImplementor session) {
        this.operation = operation;
        this.valueBindings = new JdbcValueBindingsImpl(operation.getMutationType(), operation.getMutationTarget(), this::findJdbcValueDescriptor, session);
    }

    private JdbcValueDescriptor findJdbcValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        return this.operation.findValueDescriptor(columnName, usage);
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        if (inclusionChecker.include(this.operation.getTableDetails())) {
            this.operation.performMutation(this.valueBindings, valuesAnalysis, session);
        }
    }

    @Override
    public void release() {
    }
}

