/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;

public class BasicSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements ReturnableType<J> {
    public BasicSqmPathSource(String localPathName, SqmPathSource<J> pathModel, BasicDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, pathModel, domainType, jpaBindableType);
    }

    @Override
    public BasicDomainType<J> getSqmPathType() {
        return (BasicDomainType)super.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Basic paths cannot be dereferenced");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmBasicValuedSimplePath(navigablePath, this.pathModel, lhs, lhs.nodeBuilder());
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Class<J> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    public String toString() {
        return "BasicSqmPathSource(" + this.getPathName() + " : " + this.getJavaType().getSimpleName() + ")";
    }
}

