/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.hibernate.QueryException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class ArgumentTypesValidator
implements ArgumentsValidator {
    private static final int ENUM_UNKNOWN_JDBC_TYPE = -101977;
    final ArgumentsValidator delegate;
    private final FunctionParameterType[] types;

    public ArgumentTypesValidator(ArgumentsValidator delegate, FunctionParameterType ... types) {
        this.types = types;
        if (delegate == null) {
            delegate = StandardArgumentsValidators.exactly(types.length);
        }
        this.delegate = delegate;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        this.delegate.validate(arguments, functionName, typeConfiguration);
        int count = 0;
        for (SqmTypedNode<?> argument : arguments) {
            FunctionParameterType type;
            JdbcTypeIndicators indicators = typeConfiguration.getCurrentBaseSqlTypeIndicators();
            SqmExpressible<?> nodeType = argument.getNodeType();
            FunctionParameterType functionParameterType = type = count < this.types.length ? this.types[count++] : this.types[this.types.length - 1];
            if (nodeType == null) continue;
            JavaType<?> javaType = nodeType.getExpressibleJavaType();
            if (javaType != null) {
                try {
                    this.checkType(count, functionName, type, this.getJdbcType(indicators, javaType), javaType.getJavaTypeClass());
                }
                catch (JdbcTypeRecommendationException jdbcTypeRecommendationException) {
                    // empty catch block
                }
            }
            switch (type) {
                case TEMPORAL_UNIT: {
                    if (argument instanceof SqmExtractUnit || argument instanceof SqmDurationUnit) break;
                    this.throwError(type, (Type)((Object)Object.class), functionName, count);
                    break;
                }
                case TRIM_SPEC: {
                    if (argument instanceof SqmTrimSpecification) break;
                    this.throwError(type, (Type)((Object)Object.class), functionName, count);
                    break;
                }
                case COLLATION: {
                    if (argument instanceof SqmCollation) break;
                    this.throwError(type, (Type)((Object)Object.class), functionName, count);
                }
            }
        }
    }

    private int getJdbcType(JdbcTypeIndicators indicators, JavaType<?> javaType) {
        if (javaType.getJavaTypeClass().isEnum()) {
            return -101977;
        }
        return javaType.getRecommendedJdbcType(indicators).getDefaultSqlTypeCode();
    }

    @Override
    public void validateSqlTypes(List<? extends SqlAstNode> arguments, String functionName) {
        int count = 0;
        for (SqlAstNode sqlAstNode : arguments) {
            JdbcMappingContainer expressionType;
            if (!(sqlAstNode instanceof Expression) || (expressionType = ((Expression)sqlAstNode).getExpressionType()) == null) continue;
            ParameterDetector detector = new ParameterDetector();
            sqlAstNode.accept(detector);
            if (detector.detected) {
                count += expressionType.getJdbcTypeCount();
                continue;
            }
            count = this.validateArgument(count, expressionType, functionName);
        }
    }

    private int validateArgument(int count, JdbcMappingContainer expressionType, String functionName) {
        int jdbcTypeCount = expressionType.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            FunctionParameterType type;
            JdbcMapping mapping = expressionType.getJdbcMapping(i);
            FunctionParameterType functionParameterType = type = count < this.types.length ? this.types[count++] : this.types[this.types.length - 1];
            if (type == null) continue;
            this.checkType(count, functionName, type, mapping.getJdbcType().getDefaultSqlTypeCode(), mapping.getJavaTypeDescriptor().getJavaType());
        }
        return count;
    }

    private void checkType(int count, String functionName, FunctionParameterType type, int code, Type javaType) {
        switch (type) {
            case COMPARABLE: {
                if (SqlTypes.isCharacterType(code) || SqlTypes.isTemporalType(code) || SqlTypes.isNumericType(code) || code == 3000) break;
                if (javaType == UUID.class && (code == -2 || SqlTypes.isCharacterType(code))) {
                    return;
                }
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case STRING: {
                if (SqlTypes.isCharacterType(code) || code == -101977) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case STRING_OR_CLOB: {
                if (SqlTypes.isCharacterOrClobType(code)) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case NUMERIC: {
                if (SqlTypes.isNumericType(code)) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case INTEGER: {
                if (SqlTypes.isIntegral(code) || code == -101977) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case BOOLEAN: {
                if (code == 16 || code == -7 || code == -6 || code == 5) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case TEMPORAL: {
                if (SqlTypes.isTemporalType(code)) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case DATE: {
                if (SqlTypes.hasDatePart(code)) break;
                this.throwError(type, javaType, functionName, count);
                break;
            }
            case TIME: {
                if (SqlTypes.hasTimePart(code)) break;
                this.throwError(type, javaType, functionName, count);
            }
        }
    }

    private void throwError(FunctionParameterType type, Type javaType, String functionName, int count) {
        throw new QueryException(String.format("Parameter %d of function %s() has type %s, but argument is of type %s", new Object[]{count, functionName, type, javaType.getTypeName()}));
    }

    @Override
    public String getSignature() {
        String sig = this.delegate.getSignature();
        for (int i = 0; i < this.types.length; ++i) {
            Object argName = this.types.length == 1 ? "arg" : "arg" + i;
            sig = sig.replace((CharSequence)argName, this.types[i] + " " + (String)argName);
        }
        return sig;
    }

    private static class ParameterDetector
    extends AbstractSqlAstWalker {
        private boolean detected;

        private ParameterDetector() {
        }

        @Override
        public void visitParameter(JdbcParameter jdbcParameter) {
            this.detected = true;
        }
    }
}

