/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPath;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class DiscriminatorPathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression expression;

    public DiscriminatorPathInterpretation(NavigablePath navigablePath, EntityMappingType mapping, TableGroup tableGroup, SqlAstCreationState sqlAstCreationState) {
        super(navigablePath, mapping.getDiscriminatorMapping(), tableGroup);
        JdbcMapping jdbcMappingToUse = mapping.getDiscriminatorMapping().getJdbcMapping();
        this.expression = this.getDiscriminatorMapping().resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, sqlAstCreationState);
    }

    public static SqmPathInterpretation<?> from(DiscriminatorSqmPath path, SqmToSqlAstConverter converter) {
        assert (path.getEntityDescriptor().hasSubclasses());
        NavigablePath navigablePath = path.getNavigablePath();
        TableGroup tableGroup = converter.getFromClauseAccess().getTableGroup(navigablePath.getParent());
        ModelPartContainer modelPart = tableGroup.getModelPart();
        EntityMappingType entityMapping = modelPart instanceof EntityValuedModelPart ? ((EntityValuedModelPart)modelPart).getEntityMappingType() : (EntityMappingType)((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType();
        return new DiscriminatorPathInterpretation(navigablePath, entityMapping, tableGroup, converter);
    }

    public EntityDiscriminatorMapping getDiscriminatorMapping() {
        return (EntityDiscriminatorMapping)super.getExpressionType();
    }

    @Override
    public EntityDiscriminatorMapping getExpressionType() {
        return this.getDiscriminatorMapping();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, TypeConfiguration typeConfiguration) {
        return new ResultSetMappingSqlSelection(valuesArrayPosition, this.getDiscriminatorMapping());
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getDiscriminatorMapping().createDomainResult(this.getNavigablePath(), this.getTableGroup(), resultVariable, creationState);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }
}

