/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Collection;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSessionRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

class MailServerWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    MailServerWriteAttributeHandler(AttributeDefinition ... attributeDefinitions) {
        super("mail-session", attributeDefinitions);
    }

    MailServerWriteAttributeHandler(Collection<AttributeDefinition> attributeDefinitions) {
        super("mail-session", attributeDefinitions);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals(MailServerDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ModelNode> handbackHolder) throws OperationFailedException {
        if (attributeName.equals(MailServerDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
        }
        return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder);
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, ModelNode invalidatedParentModel) throws OperationFailedException {
        if (attributeName.equals(MailServerDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (ModelNode)resolvedValue);
        }
        super.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, invalidatedParentModel);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        MailSessionAdd.installSessionProviderService(context, parentAddress, parentModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(parentAddress).append(new String[]{"provider"});
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        MailSessionRemove.removeSessionProviderService(context, context.getCurrentAddress().getParent(), parentModel);
    }
}

