/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;

public class HSQLSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public HSQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    protected boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsRecursiveClauseArrayAndRowEmulation() {
        return false;
    }

    @Override
    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept(this);
            this.appendSql(" as varchar(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression expression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(expression) || this.areAllResultsPlainParametersOrLiterals(expression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = expression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(expression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(expression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression expression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(expression) || this.areAllResultsPlainParametersOrLiterals(expression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = expression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(expression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(expression, resultRenderer);
        }
    }

    protected boolean areAllResultsPlainParametersOrLiterals(CaseSearchedExpression caseSearchedExpression) {
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult) && this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT || this.isLiteral(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                Expression result = whenFragments.get(i).getResult();
                if (!(this.isParameter(result) ? this.getParameterRenderingMode() != SqlAstNodeRenderingMode.DEFAULT : !this.isLiteral(result))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean areAllResultsPlainParametersOrLiterals(CaseSimpleExpression caseSimpleExpression) {
        List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
        Expression firstResult = whenFragments.get(0).getResult();
        if (this.isParameter(firstResult) && this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT || this.isLiteral(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                Expression result = whenFragments.get(i).getResult();
                if (!(this.isParameter(result) ? this.getParameterRenderingMode() != SqlAstNodeRenderingMode.DEFAULT : !this.isLiteral(result))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause()) {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonStandard(lhs, operator, rhs);
            return;
        }
        switch (operator) {
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                if (lhsExpressionType.getSingleJdbcMapping().getJdbcType() instanceof ArrayJdbcType) {
                    lhs.accept(this);
                    this.appendSql(operator == ComparisonOperator.DISTINCT_FROM ? "<>" : "=");
                    rhs.accept(this);
                    break;
                }
                this.render(lhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                this.appendSql(operator.sqlText());
                this.render(rhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                break;
            }
            default: {
                this.renderComparisonStandard(lhs, operator, rhs);
            }
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from (values(0))";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return true;
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        BinaryArithmeticOperator operator = arithmeticExpression.getOperator();
        if (operator == BinaryArithmeticOperator.MODULO) {
            this.append("mod");
            this.appendSql('(');
            arithmeticExpression.getLeftHandOperand().accept(this);
            this.appendSql(',');
            arithmeticExpression.getRightHandOperand().accept(this);
            this.appendSql(')');
        } else {
            this.appendSql('(');
            this.render(arithmeticExpression.getLeftHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
            this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
            this.render(arithmeticExpression.getRightHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
            this.appendSql(')');
        }
    }
}

