/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.infinispan.listener.PostActivateBlockingListener;
import org.wildfly.clustering.infinispan.listener.PostPassivateBlockingListener;
import org.wildfly.clustering.infinispan.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.infinispan.listener.PrePassivateNonBlockingListener;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class FineSessionAttributesFactory<S, C, L, V>
implements SessionAttributesFactory<C, AtomicReference<Map<String, UUID>>> {
    private final Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Cache<Key<String>, Object> writeCache;
    private final Cache<Key<String>, Object> silentCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final MutatorFactory<SessionAttributeKey, V> mutatorFactory;
    private final HttpSessionActivationListenerProvider<S, C, L> provider;
    private final Function<String, SessionAttributeActivationNotifier> notifierFactory;
    private final Executor executor;
    private final ListenerRegistration evictListenerRegistration;
    private final ListenerRegistration evictAttributesListenerRegistration;
    private final ListenerRegistration prePassivateListenerRegistration;
    private final ListenerRegistration postActivateListenerRegistration;

    public FineSessionAttributesFactory(InfinispanSessionAttributesFactoryConfiguration<S, C, L, Object, V> configuration) {
        this.namesCache = configuration.getCache();
        this.attributeCache = configuration.getCache();
        this.writeCache = configuration.getWriteOnlyCache();
        this.silentCache = configuration.getSilentWriteCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new InfinispanMutatorFactory(this.attributeCache, this.properties);
        this.provider = configuration.getHttpSessionActivationListenerProvider();
        this.notifierFactory = configuration.getActivationNotifierFactory();
        this.executor = configuration.getBlockingManager().asExecutor(this.getClass().getName());
        this.evictListenerRegistration = new PostPassivateBlockingListener(configuration.getCache(), this::cascadeEvict).register(SessionCreationMetaDataKey.class);
        this.evictAttributesListenerRegistration = new PrePassivateNonBlockingListener(this.namesCache, this::cascadeEvictAttributes).register(SessionAttributeNamesKey.class);
        this.prePassivateListenerRegistration = !this.properties.isPersistent() ? new PrePassivateBlockingListener(this.attributeCache, this::prePassivate).register(SessionAttributeKey.class) : null;
        this.postActivateListenerRegistration = !this.properties.isPersistent() ? new PostActivateBlockingListener(this.attributeCache, this::postActivate).register(SessionAttributeKey.class) : null;
    }

    public void close() {
        this.evictListenerRegistration.close();
        this.evictAttributesListenerRegistration.close();
        if (this.prePassivateListenerRegistration != null) {
            this.prePassivateListenerRegistration.close();
        }
        if (this.postActivateListenerRegistration != null) {
            this.postActivateListenerRegistration.close();
        }
    }

    public AtomicReference<Map<String, UUID>> createValue(String id, Void context) {
        return new AtomicReference<Map<String, UUID>>(Collections.emptyMap());
    }

    public AtomicReference<Map<String, UUID>> findValue(String id) {
        return this.getValue(id, true);
    }

    public AtomicReference<Map<String, UUID>> tryValue(String id) {
        return this.getValue(id, false);
    }

    private AtomicReference<Map<String, UUID>> getValue(String id, boolean purgeIfInvalid) {
        Map names = (Map)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            TreeMap<SessionAttributeKey, String> attributes = new TreeMap<SessionAttributeKey, String>();
            for (Map.Entry entry : names.entrySet()) {
                attributes.put(new SessionAttributeKey(id, (UUID)entry.getValue()), (String)entry.getKey());
            }
            Map entries = this.attributeCache.getAdvancedCache().getAll(attributes.keySet());
            for (Map.Entry attribute : attributes.entrySet()) {
                Object value = entries.get(attribute.getKey());
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (IOException e) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)attribute.getValue());
                    }
                } else {
                    InfinispanWebLogger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)attribute.getValue());
                }
                if (purgeIfInvalid) {
                    this.purge(id);
                }
                return null;
            }
            return new AtomicReference<Map<String, UUID>>(names);
        }
        return new AtomicReference<Map<String, UUID>>(Collections.emptyMap());
    }

    public boolean remove(String id) {
        return this.delete(this.writeCache, id);
    }

    public boolean purge(String id) {
        return this.delete(this.silentCache, id);
    }

    private boolean delete(Cache<Key<String>, Object> cache, String id) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        Map names = (Map)this.namesCache.get((Object)key);
        if (names != null) {
            for (UUID attributeId : names.values()) {
                cache.remove((Object)new SessionAttributeKey(id, attributeId));
            }
            cache.remove((Object)key);
        }
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, AtomicReference<Map<String, UUID>> names, ImmutableSessionMetaData metaData, C context) {
        ImmutableSessionAttributeActivationNotifier notifier = new ImmutableSessionAttributeActivationNotifier(this.provider, (ImmutableSession)new CompositeImmutableSession(id, metaData, this.createImmutableSessionAttributes(id, names)), context);
        return new FineSessionAttributes((Object)new SessionAttributeNamesKey(id), names, this.namesCache, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller, this.mutatorFactory, this.immutability, this.properties, (SessionAttributeActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, AtomicReference<Map<String, UUID>> names) {
        return new FineImmutableSessionAttributes(names, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller);
    }

    private static Function<UUID, SessionAttributeKey> getKeyFactory(final String id) {
        return new Function<UUID, SessionAttributeKey>(){

            @Override
            public SessionAttributeKey apply(UUID attributeId) {
                return new SessionAttributeKey(id, attributeId);
            }
        };
    }

    private void cascadeEvict(SessionCreationMetaDataKey key) {
        this.namesCache.evict((Object)new SessionAttributeNamesKey((String)key.getId()));
    }

    private void cascadeEvictAttributes(SessionAttributeNamesKey key, Map<String, UUID> value) {
        String sessionId = (String)key.getId();
        for (UUID attributeId : value.values()) {
            this.executor.execute(() -> this.attributeCache.evict((Object)new SessionAttributeKey(sessionId, attributeId)));
        }
    }

    private void prePassivate(SessionAttributeKey key, V value) {
        this.notify(SessionAttributeActivationNotifier.PRE_PASSIVATE, key, value);
    }

    private void postActivate(SessionAttributeKey key, V value) {
        this.notify(SessionAttributeActivationNotifier.POST_ACTIVATE, key, value);
    }

    private void notify(BiConsumer<SessionAttributeActivationNotifier, Object> notification, SessionAttributeKey key, V value) {
        String sessionId = (String)key.getId();
        try (SessionAttributeActivationNotifier notifier = this.notifierFactory.apply((String)key.getId());){
            notification.accept(notifier, this.marshaller.read(value));
        }
        catch (IOException e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, sessionId, key.getAttributeId().toString());
        }
    }
}

