/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;

public class TransformUtils {
    private TransformUtils() {
    }

    static List<String> validateDeprecatedProperites(ModelNode model) {
        LinkedList<String> propertiesToReject = new LinkedList<String>();
        for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT) {
            if (!model.hasDefined(attributeDefinition.getName()) || !model.get(attributeDefinition.getName()).equals(JacORBSubsystemDefinitions.DEFAULT_ENABLED_PROPERTY)) continue;
            propertiesToReject.add(attributeDefinition.getName());
        }
        for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT) {
            if (!model.hasDefined(attributeDefinition.getName())) continue;
            propertiesToReject.add(attributeDefinition.getName());
        }
        return propertiesToReject;
    }

    /*
     * Enabled aggressive block sorting
     */
    static ModelNode transformModel(ModelNode legacyModel) {
        ModelNode model = new ModelNode();
        for (Property property : legacyModel.asPropertyList()) {
            ModelNode value;
            String expressionVariable;
            boolean expression;
            ModelNode legacyValue;
            String name;
            block27: {
                name = property.getName();
                legacyValue = property.getValue();
                if (!legacyValue.isDefined()) continue;
                if (name.equals("ior-settings")) {
                    TransformUtils.transformIorSettings(model, legacyValue);
                    continue;
                }
                if (legacyValue.getType() == ModelType.EXPRESSION) {
                    expression = true;
                    Matcher matcher = Pattern.compile("\\A\\$\\{(.*):(.*)\\}\\Z").matcher(legacyValue.asExpression().getExpressionString());
                    if (matcher.find()) {
                        expressionVariable = matcher.group(1);
                        String abc = matcher.group(2);
                        legacyValue = new ModelNode(abc);
                        break block27;
                    } else {
                        model.get(name).set(legacyValue);
                        continue;
                    }
                }
                expression = false;
                expressionVariable = null;
            }
            switch (name) {
                case "giop-minor-version": {
                    name = "giop-version";
                    value = new ModelNode("1." + legacyValue.asString());
                    break;
                }
                case "transactions": {
                    if (legacyValue.asString().equals("on")) {
                        value = new ModelNode("full");
                        break;
                    }
                    if (legacyValue.asString().equals("off")) {
                        value = new ModelNode("none");
                        break;
                    }
                    value = legacyValue;
                    break;
                }
                case "security": {
                    if (legacyValue.asString().equals("off")) {
                        value = new ModelNode("none");
                        break;
                    }
                    value = new ModelNode("elytron");
                    JacORBLogger.ROOT_LOGGER.migratedToElytronSecurityWarning();
                    break;
                }
                case "support-ssl": 
                case "add-component-via-interceptor": 
                case "export-corbaloc": 
                case "iona": {
                    if (legacyValue.asString().equals("on")) {
                        value = ModelNode.TRUE;
                        break;
                    }
                    value = ModelNode.FALSE;
                    break;
                }
                default: {
                    value = legacyValue;
                }
            }
            if (value.asString().equals("off")) continue;
            if (expression) {
                String newExpression = "${" + expressionVariable;
                if (expressionVariable != null) {
                    newExpression = newExpression + ":" + value.asString();
                }
                newExpression = newExpression + "}";
                value = new ModelNode(new ValueExpression(newExpression));
            }
            model.get(name).set(value);
        }
        if (!legacyModel.get("socket-binding").isDefined()) {
            model.get("socket-binding").set(JacORBSubsystemDefinitions.ORB_SOCKET_BINDING.getDefaultValue());
        }
        return model;
    }

    private static void transformIorSettings(ModelNode model, ModelNode legacyValue) {
        for (Property category : legacyValue.get("default").get("setting").asPropertyList()) {
            for (Property property : category.getValue().asPropertyList()) {
                model.get(property.getName()).set(property.getValue());
            }
        }
    }
}

