/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.util;

public final class Interval<K extends Comparable<K>> {
    private static final Comparable MINUS_INF = new Comparable(){

        public String toString() {
            return "-INF";
        }

        public int compareTo(Object obj) {
            return obj == this ? 0 : -1;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private static final Comparable PLUS_INF = new Comparable(){

        public String toString() {
            return "+INF";
        }

        public int compareTo(Object obj) {
            return obj == this ? 0 : 1;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    public final K low;
    public final boolean includeLower;
    public final K up;
    public final boolean includeUpper;

    public static <K extends Comparable<K>> K getMinusInf() {
        return (K)MINUS_INF;
    }

    public static <K extends Comparable<K>> K getPlusInf() {
        return (K)PLUS_INF;
    }

    public Interval(K low, boolean includeLower, K up, boolean includeUpper) {
        if (low == null || up == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        this.low = low;
        this.includeLower = includeLower;
        this.up = up;
        this.includeUpper = includeUpper;
    }

    public boolean contains(K value) {
        return (this.includeLower ? this.low.compareTo(value) <= 0 : this.low.compareTo(value) < 0) && (this.includeUpper ? this.up.compareTo(value) >= 0 : this.up.compareTo(value) > 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.includeLower == other.includeLower && this.includeUpper == other.includeUpper && this.low.equals(other.low) && this.up.equals(other.up);
    }

    public int hashCode() {
        int result = this.low.hashCode();
        result = 31 * result + (this.includeLower ? 1 : 0);
        result = 31 * result + this.up.hashCode();
        result = 31 * result + (this.includeUpper ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.includeLower ? "[" : "(") + this.low + ", " + this.up + (this.includeUpper ? "]" : ")");
    }
}

