/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.XAJMSContext;
import org.hornetq.jms.client.HornetQConnectionForContext;
import org.hornetq.jms.client.HornetQJMSContext;
import org.hornetq.jms.client.HornetQXAJMSContext;
import org.hornetq.jms.client.JmsExceptionUtils;
import org.hornetq.jms.client.ThreadAwareContext;
import org.hornetq.utils.ReferenceCounter;
import org.hornetq.utils.ReferenceCounterUtil;

public abstract class HornetQConnectionForContextImpl
implements HornetQConnectionForContext {
    final Runnable closeRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                HornetQConnectionForContextImpl.this.close();
            }
            catch (JMSException e) {
                throw JmsExceptionUtils.convertToRuntimeException(e);
            }
        }
    };
    final ReferenceCounter refCounter = new ReferenceCounterUtil(this.closeRunnable);
    protected final ThreadAwareContext threadAwareContext = new ThreadAwareContext();

    @Override
    public JMSContext createContext(int sessionMode) {
        switch (sessionMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 100: 
            case 101: {
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid ackmode: " + sessionMode);
            }
        }
        this.refCounter.increment();
        return new HornetQJMSContext(this, sessionMode, this.threadAwareContext);
    }

    @Override
    public XAJMSContext createXAContext() {
        this.refCounter.increment();
        return new HornetQXAJMSContext(this, this.threadAwareContext);
    }

    @Override
    public void closeFromContext() {
        this.refCounter.decrement();
    }

    protected void incrementRefCounter() {
        this.refCounter.increment();
    }

    public ThreadAwareContext getThreadAwareContext() {
        return this.threadAwareContext;
    }
}

