/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataDiscoverer;

public final class TypeMetadataContributorProvider<C> {
    private final Map<MappableTypeModel, List<C>> contributionByType;
    private final List<TypeMetadataDiscoverer<C>> metadataDiscoverers;
    private final Set<MappableTypeModel> typesSubmittedToDiscoverers = new HashSet<MappableTypeModel>();

    public static <C> Builder<C> builder() {
        return new Builder();
    }

    private TypeMetadataContributorProvider(Builder<C> builder) {
        this.contributionByType = ((Builder)builder).contributionByType;
        this.metadataDiscoverers = ((Builder)builder).metadataDiscoverers;
    }

    public Set<C> get(MappableTypeModel typeModel) {
        return typeModel.descendingSuperTypes().map(this::getContributionIncludingAutomaticallyDiscovered).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<? extends MappableTypeModel> typesContributedTo() {
        return Collections.unmodifiableSet(new LinkedHashSet<MappableTypeModel>(this.contributionByType.keySet()));
    }

    private List<C> getContributionIncludingAutomaticallyDiscovered(MappableTypeModel typeModel) {
        if (!this.typesSubmittedToDiscoverers.contains(typeModel)) {
            for (TypeMetadataDiscoverer<C> metadataDiscoverer : this.metadataDiscoverers) {
                Optional<C> discoveredContributor = metadataDiscoverer.discover(typeModel);
                if (!discoveredContributor.isPresent()) continue;
                this.contributionByType.computeIfAbsent(typeModel, ignored -> new ArrayList()).add(discoveredContributor.get());
            }
            this.typesSubmittedToDiscoverers.add(typeModel);
        }
        return this.contributionByType.get(typeModel);
    }

    public static final class Builder<C> {
        private final Map<MappableTypeModel, List<C>> contributionByType = new LinkedHashMap<MappableTypeModel, List<C>>();
        private final List<TypeMetadataDiscoverer<C>> metadataDiscoverers = new ArrayList<TypeMetadataDiscoverer<C>>();

        private Builder() {
        }

        public void contributor(MappableTypeModel typeModel, C contributor) {
            this.contributionByType.computeIfAbsent(typeModel, ignored -> new ArrayList()).add(contributor);
        }

        public void discoverer(TypeMetadataDiscoverer<C> metadataDiscoverer) {
            this.metadataDiscoverers.add(metadataDiscoverer);
        }

        public TypeMetadataContributorProvider<C> build() {
            return new TypeMetadataContributorProvider(this);
        }
    }
}

