/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class SchemaElement {
    private final QName name;
    private final QName type;
    private final Set<QName> appliedTypes = new HashSet<QName>();
    private boolean reference;
    private SchemaElement delegate = null;
    private QName base;
    private final Set<String> attributes = new TreeSet<String>();

    public SchemaElement(QName name, QName type) {
        this.name = name;
        this.type = type;
        this.reference = false;
    }

    public SchemaElement(QName name, boolean reference) {
        this.name = name;
        this.reference = reference;
        this.type = null;
    }

    public SchemaElement(QName name) {
        this(name, null);
    }

    public SchemaElement delegate(SchemaElement delegate) {
        this.delegate = delegate;
        this.reference = false;
        return this;
    }

    public void addAttribute(String attribute) {
        if (this.delegate != null) {
            this.delegate.addAttribute(attribute);
        } else {
            this.attributes.add(attribute);
        }
    }

    public void addAttributes(Collection<String> attrs) {
        if (this.delegate != null) {
            this.delegate.addAttributes(attrs);
        } else {
            this.attributes.addAll(attrs);
        }
    }

    public void addAppliedType(QName type) {
        this.appliedTypes.add(type);
    }

    public boolean isTypeApplied(QName type) {
        return this.appliedTypes.contains(type);
    }

    public String name() {
        if (this.delegate != null) {
            return this.delegate.name();
        }
        return this.name.getLocalPart();
    }

    public QName qname() {
        if (this.delegate != null) {
            return this.delegate.qname();
        }
        return this.name;
    }

    public QName type() {
        if (this.delegate != null) {
            return this.delegate.type();
        }
        return this.type;
    }

    public QName base() {
        if (this.delegate != null) {
            return this.delegate.base();
        }
        return this.base;
    }

    public boolean isReference() {
        return this.reference;
    }

    public SchemaElement base(QName base) {
        if (this.delegate != null) {
            this.delegate.base(base);
        } else {
            this.base = base;
        }
        return this;
    }

    public Set<String> attributes() {
        if (this.delegate != null) {
            return this.delegate.attributes();
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    public String toString() {
        return "<SchemaElement name=" + this.name() + ", attributes=" + this.attributes() + ">";
    }

    public boolean equals(Object obj) {
        if (this.delegate != null) {
            return this.delegate.equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement that = (SchemaElement)obj;
        return this.name.equals(that.name) && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        if (this.delegate != null) {
            return this.delegate.hashCode();
        }
        return this.name.hashCode() + this.attributes.hashCode();
    }
}

